/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapMultiValueMemberKey;
import crazydev.iccube.olap.entity.member.OlapMultiValueRegularCaseInsensitiveMemberKey;
import crazydev.iccube.olap.entity.scalar.OlapComparableVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.util.Arrays;

class OlapMultiValueRegularMemberKey
extends OlapMultiValueMemberKey {
    private final OlapBuilderInputType[] types;
    private final Comparable[] values;

    OlapMultiValueRegularMemberKey(OlapBuilderInputType[] types, Comparable[] values) {
        if (types.length <= 1) {
            throw new CdProgrammingException("Inconsistent multi-value key creation!");
        }
        if (types.length != values.length) {
            throw new CdProgrammingException("Inconsistent multi-value key creation!");
        }
        this.types = types;
        this.values = values;
    }

    @Override
    public OlapScalarEntity asScalarEntity() {
        return new OlapComparableVectorEntity(Arrays.asList(this.values), true);
    }

    @Override
    public OlapBuilderInputType[] getTypes() {
        return this.types;
    }

    @Override
    public Comparable[] getValues() {
        return this.values;
    }

    @Override
    public OlapMemberKey toUpperCase() {
        if (Arrays.stream(this.types).noneMatch(OlapBuilderInputType::isString)) {
            return this;
        }
        Comparable[] nvalues = new Comparable[this.values.length];
        System.arraycopy(this.values, 0, nvalues, 0, this.values.length);
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isString()) continue;
            Comparable value = this.values[i];
            String upperCase = value.toString().toUpperCase();
            nvalues[i] = upperCase;
        }
        return new OlapMultiValueRegularCaseInsensitiveMemberKey(this.types, nvalues);
    }
}

