/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.collection.CdArrays;
import crazydev.common.collection.CdComparableArray;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierMultiValueKeyPart;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

abstract class OlapMultiValueMemberKey
extends OlapMemberKey<OlapMultiValueMemberKey> {
    OlapMultiValueMemberKey() {
    }

    @Override
    public Comparable getValue() {
        return new CdComparableArray(this.getValues());
    }

    @Override
    public OlapScalarEntity asScalarEntity(int pos) {
        if (pos >= 0 && pos < this.getValues().length) {
            return this.getTypes()[pos].toScalarEntity(this.getValues()[pos]);
        }
        return OlapEmptyEntity.INSTANCE;
    }

    @Override
    public Object asJavaNativeValue() {
        return this.getValues();
    }

    @Override
    public boolean isEquals(String value) {
        return false;
    }

    @Override
    public boolean isEquals(String[] values) {
        if (this.getValues().length != values.length) {
            return false;
        }
        for (int idx = 0; idx < values.length; ++idx) {
            String thisValue = this.asScalarEntity(idx).asString();
            if (thisValue.equals(values[idx])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void appendUniqueName(StringBuilder sb) {
        for (int idx = 0; idx < this.getValues().length; ++idx) {
            sb.append(idx == 0 ? ".&[" : "&[").append(CdMdxUtils.escape((String)this.asScalarEntity(idx).asString())).append("]");
        }
    }

    @Override
    public OlapEntityIdentifier asIdentifier() {
        String[] keys = new String[this.getValues().length];
        for (int idx = 0; idx < this.getValues().length; ++idx) {
            keys[idx] = CdMdxUtils.escape((String)this.asScalarEntity(idx).asString());
        }
        OlapEntityIdentifierMultiValueKeyPart part = new OlapEntityIdentifierMultiValueKeyPart(keys);
        return new OlapEntityIdentifier(part);
    }

    @Override
    public int compareTo(OlapMemberKey o) {
        if (o == OlapNoValueMemberKey.INSTANCE) {
            return -1;
        }
        return CdArrays.compareTo((Comparable[])this.getValues(), (Comparable[])o.getValues());
    }

    @Override
    @Nullable
    public Object toTidyTableValue() {
        OlapBuilderInputType[] types = this.getTypes();
        Comparable[] values = this.getValues();
        if (types == null || types.length != values.length) {
            return null;
        }
        ArrayList<Object> keys = new ArrayList<Object>();
        for (int ii = 0; ii < values.length; ++ii) {
            OlapBuilderInputType type = types[ii];
            Comparable value = values[ii];
            OlapScalarEntity entity = type.toScalarEntity(value);
            keys.add(entity.toTidyTableValue());
        }
        return keys;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof OlapMultiValueMemberKey)) {
            return false;
        }
        OlapMultiValueMemberKey that = (OlapMultiValueMemberKey)o;
        return Arrays.equals(this.getValues(), that.getValues());
    }

    @Override
    public int hashCode() {
        Object[] values = this.getValues();
        return values != null ? Arrays.hashCode(values) : 0;
    }

    @Override
    public String asStringForDrillthrough() {
        return Arrays.toString(this.getValues());
    }

    @Override
    public String toString() {
        return Arrays.toString(this.getValues()) + "-" + Arrays.toString((Object[])this.getTypes());
    }

    @Override
    public boolean isSingleValue() {
        return false;
    }
}

