/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.enums.OlapMemberNotKeyOrder;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.enums.OlapMemberOrderKind;
import crazydev.iccube.olap.component.naming.OlapDefaultNamesContext;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.common.OlapMemberChildrenList;
import crazydev.iccube.olap.entity.common.OlapNewMemberChildrenList;
import crazydev.iccube.olap.entity.common.OlapNewMemberSortedChildrenList;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class OlapMemberChildrenListFactory {
    static final String propertyName = "IcMemberRanking";

    public static OlapMemberChildren buildEmptyChildrenList(@Nullable OlapLevel childrenLevel) {
        if (childrenLevel == null) {
            return new OlapMemberChildrenList();
        }
        OlapUserDefinedMemberProperty orderProperty = childrenLevel.lookupPropertyByName(propertyName);
        OlapMemberOrderByType orderBy = childrenLevel.getOrderBy();
        OlapMemberOrderKind orderKind = childrenLevel.getOrderKind();
        OlapMemberNotKeyOrder orderNoKey = childrenLevel.getOrderNoKey();
        Comparator<String> orderLanguage = orderBy == OlapMemberOrderByType.BY_NAME ? childrenLevel.getHierarchy().getLocalizedStringComparator() : null;
        return OlapMemberChildrenListFactory.buildEmptyChildrenList(childrenLevel, orderBy, orderKind, orderNoKey, orderProperty, orderLanguage);
    }

    private static OlapMemberChildren buildEmptyChildrenList(OlapLevel childrenLevel, OlapMemberOrderByType orderBy, OlapMemberOrderKind orderKind, OlapMemberNotKeyOrder orderNoKey, OlapUserDefinedMemberProperty orderProperty, @Nullable Comparator<String> stringComparator) {
        if (orderBy == null || orderBy == OlapMemberOrderByType.NONE) {
            if (orderNoKey != null) {
                return new OlapNewMemberSortedChildrenList(childrenLevel, (o1, o2) -> {
                    OlapMemberKey key1 = o1.getKey();
                    OlapMemberKey key2 = o2.getKey();
                    if (key1 == OlapNoValueMemberKey.INSTANCE || key2 == OlapNoValueMemberKey.INSTANCE) {
                        return OlapMemberChildrenListFactory.compareNoKey(orderNoKey, key1, key2);
                    }
                    return 0;
                });
            }
            return new OlapNewMemberChildrenList(childrenLevel);
        }
        OlapMemberOrderKind.MemberComparator comparator = orderKind.getComparator(stringComparator);
        OlapDefaultNamesContext nameContext = OlapDefaultNamesContext.SINGLETON;
        switch (orderBy) {
            case BY_NAME: {
                return new OlapNewMemberSortedChildrenList(childrenLevel, (o1, o2) -> {
                    OlapMemberKey key1 = o1.getKey();
                    OlapMemberKey key2 = o2.getKey();
                    if (orderNoKey != null && (key1 == OlapNoValueMemberKey.INSTANCE || key2 == OlapNoValueMemberKey.INSTANCE)) {
                        return OlapMemberChildrenListFactory.compareNoKey(orderNoKey, key1, key2);
                    }
                    int cmp = comparator.compare(o1.getName(nameContext), o2.getName(nameContext));
                    if (cmp == 0) {
                        try {
                            return comparator.compare(key1, key2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return cmp;
                });
            }
            case BY_KEY: {
                return new OlapNewMemberSortedChildrenList(childrenLevel, (o1, o2) -> {
                    OlapMemberKey key1 = o1.getKey();
                    OlapMemberKey key2 = o2.getKey();
                    if (orderNoKey != null && (key1 == OlapNoValueMemberKey.INSTANCE || key2 == OlapNoValueMemberKey.INSTANCE)) {
                        return OlapMemberChildrenListFactory.compareNoKey(orderNoKey, key1, key2);
                    }
                    return comparator.compare(key1, key2);
                });
            }
            case BY_COLUMN: {
                if (orderProperty == null) {
                    throw new CdProgrammingException("Unable to find mandatory ranking property [IcMemberRanking] in level");
                }
                return new OlapNewMemberSortedChildrenList(childrenLevel, (o1, o2) -> {
                    OlapMemberKey key1 = o1.getKey();
                    OlapMemberKey key2 = o2.getKey();
                    if (orderNoKey != null && (key1 == OlapNoValueMemberKey.INSTANCE || key2 == OlapNoValueMemberKey.INSTANCE)) {
                        return OlapMemberChildrenListFactory.compareNoKey(orderNoKey, key1, key2);
                    }
                    if (key1 == OlapNoValueMemberKey.INSTANCE) {
                        return comparator.compare(key1, key2);
                    }
                    if (key2 == OlapNoValueMemberKey.INSTANCE) {
                        return -comparator.compare(key2, key1);
                    }
                    OlapScalarEntity prop1 = o1.getPropertyValue(null, orderProperty);
                    OlapScalarEntity prop2 = o2.getPropertyValue(null, orderProperty);
                    if (prop1 == null) {
                        throw new CdProgrammingException("Missing value for property [IcMemberRanking] for member [" + o1.getUniqueName(nameContext) + "]");
                    }
                    if (prop2 == null) {
                        throw new CdProgrammingException("Missing value for property [IcMemberRanking] for member [" + o2.getUniqueName(nameContext) + "]");
                    }
                    int cmp = comparator.compare(prop1, prop2);
                    if (cmp == 0) {
                        return comparator.compare(key1, key2);
                    }
                    return cmp;
                });
            }
        }
        throw new CdProgrammingException("Unknown type [" + String.valueOf((Object)orderBy) + "]");
    }

    private static int compareNoKey(OlapMemberNotKeyOrder orderNoKey, OlapMemberKey key1, OlapMemberKey key2) {
        if (key1 != OlapNoValueMemberKey.INSTANCE) {
            return orderNoKey.compValue();
        }
        if (key2 != OlapNoValueMemberKey.INSTANCE) {
            return -orderNoKey.compValue();
        }
        return 0;
    }
}

