/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.collection.CdCollections;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.IOlapMeasureHolder;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import java.util.List;

public class OlapMeasureVectorMember
extends OlapMeasureMember
implements IOlapMeasureHolder<OlapMeasureMember> {
    private static long SHALLOW_SIZE_OF = -1L;
    private final List<OlapMeasureMember> measures;

    public OlapMeasureVectorMember(List<OlapMeasureMember> measures, String name, OlapAggregationType aggrType) {
        this(measures, OlapMeasureVectorMember.first(measures).getLevel(), name, OlapMeasureVectorMember.first(measures).getMeasureGroup(), aggrType);
    }

    private OlapMeasureVectorMember(List<OlapMeasureMember> measures, OlapLevel level, String name, IOlapBuilderBaseFactsDef measureGroup, OlapAggregationType aggrType) {
        super(level, S_MeasureIndex.NONE, name, measureGroup, OlapBuilderInputType.JAVA_OBJECT, aggrType, OlapMeasureVectorMember.isEmptyIsZero(measures), null);
        OlapMeasureVectorMember.sanityCheck(measureGroup, measures);
        this.measures = measures;
        if (measures.stream().anyMatch(OlapMeasureMember::hasTableAggregation)) {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    private static OlapMeasureMember first(List<OlapMeasureMember> measures) {
        OlapMeasureMember first = (OlapMeasureMember)CdCollections.first(measures);
        if (first == null) {
            throw new RuntimeException("internal error: no measures");
        }
        return first;
    }

    private static boolean isEmptyIsZero(List<OlapMeasureMember> measures) {
        for (OlapMeasureMember measure : measures) {
            if (!measure.isEmptyIsZero()) continue;
            return true;
        }
        return false;
    }

    private static void sanityCheck(IOlapBuilderBaseFactsDef measureGroup, List<OlapMeasureMember> measures) {
        for (OlapMeasureMember measure : measures) {
            if (measure.getMeasureGroup() == measureGroup) continue;
            throw new RuntimeException("internal error: measure group mismatch [" + measureGroup.getMeasureGroupName() + "] [" + measure.getMeasureGroupName() + "] [" + String.valueOf(measure) + "]");
        }
    }

    @Override
    public boolean isRegular() {
        return false;
    }

    @Override
    public OlapTuple[] unroll(GFContext context) {
        OlapTuple[] unrolled = new OlapTuple[this.measures.size()];
        for (int ii = 0; ii < this.measures.size(); ++ii) {
            OlapMeasureMember measure = this.measures.get(ii);
            unrolled[ii] = measure;
        }
        return unrolled;
    }

    public List<OlapMeasureMember> getMeasures() {
        return this.measures;
    }

    public OlapMeasureMember getMeasure(int idx) {
        return this.measures.get(idx);
    }

    @Override
    public OlapMeasureMember asNoEmptyMeasure() {
        throw new RuntimeException("internal error: inconsistent measures-vector processing (as-no-empty)");
    }

    @Override
    public boolean isMeasureVector() {
        return true;
    }

    @Override
    public int getMeasureVectorSize() {
        return this.measures.size();
    }

    @Override
    public int size() {
        return this.measures.size();
    }

    @Override
    public OlapMeasureMember get(int i) {
        return this.measures.get(i);
    }

    @Override
    protected S_MeasureRef resolveClusterMeasureRef() {
        throw new RuntimeException("internal error: inconsistent usage of resolveClusterMeasureRef [" + ONames.uname4Log(this) + "]");
    }

    @Override
    public S_MeasureRef[] getClusterRefs() {
        if (this.measureRefs == null) {
            this.measureRefs = this.resolveClusterMeasureRefs();
        }
        return this.measureRefs;
    }

    private S_MeasureRef[] resolveClusterMeasureRefs() {
        S_MeasureRef[] measureRefs = new S_MeasureRef[this.measures.size()];
        for (int ii = 0; ii < this.measures.size(); ++ii) {
            OlapMeasureMember measure = this.measures.get(ii);
            measureRefs[ii] = measure.resolveClusterMeasureRef();
        }
        return measureRefs;
    }
}

