/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.olap.OlapEntityType;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.cluster.shared.schema.S_MeasureRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.IOlapMeasure;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapMemberUniqueNameType;
import crazydev.iccube.olap.entity.member.OlapNoEmptyMeasureMemberFactory;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.member.OlapTerminalMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapStringMdxCellPropertyValue;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregator;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregatorFactory;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.facts.IOlapFactMeasureGroupManagerForEval;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapMeasureMember
extends OlapTerminalMember
implements IOlapMeasure {
    public static final String FRIENDLY_NAME = "measure";
    private static long SHALLOW_SIZE_OF = -1L;
    protected final String name;
    protected final OlapAggregationType hierarchyAggregationType;
    protected final OlapBuilderInputType cubeDataType;
    protected final boolean emptyIsZeroAsDouble;
    private final S_MeasureIndex index;
    private final IOlapBuilderBaseFactsDef measureGroup;
    private final OlapMeasureMember asNoEmptyMeasure;
    private final Map<String, OlapScalarEntity> properties = new ConcurrentHashMap<String, OlapScalarEntity>();
    protected boolean emptyIsZero;
    protected volatile S_MeasureRef[] measureRefs;
    @Nullable
    protected OlapCellProperties cellProperties;
    @Nullable
    private OlapHierarchy rollupHierarchy;
    private volatile IOlapFactMeasureGroupManagerForEval factsManager;
    @Nullable
    private IOlapFactTableAggregatorFactory tableAggregator;
    private OlapMember parent;

    protected OlapMeasureMember(OlapLevel level, S_MeasureIndex index, String name, IOlapBuilderBaseFactsDef measureGroup, OlapBuilderInputType cubeDataType, OlapAggregationType hierarchyAggregationType, boolean emptyIsZero, @Nullable OlapNoEmptyMeasureMemberFactory factory) {
        super(null, level, null, null);
        this.index = index;
        this.name = name;
        this.measureGroup = measureGroup;
        this.cubeDataType = cubeDataType;
        this.hierarchyAggregationType = hierarchyAggregationType;
        this.emptyIsZero = emptyIsZero;
        this.emptyIsZeroAsDouble = hierarchyAggregationType.outputScalarTypeIsDouble(cubeDataType.isFloatDouble());
        this.asNoEmptyMeasure = hierarchyAggregationType.useNoEmptyAggregation() ? (factory == null ? new OlapMeasureMember(this.getLevel(), this.getMeasureIndex(), ONames.name4Log(this), this.getMeasureGroup(), this.getCubeDataType(), OlapAggregationType.NO_EMPTY, this.isEmptyIsZero(), null) : factory.create(this.getLevel(), this.getMeasureIndex(), ONames.name4Log(this), this.getMeasureGroup(), this.getCubeDataType(), OlapAggregationType.NO_EMPTY, this.isEmptyIsZero())) : this;
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.MEASURE;
    }

    @Override
    public OlapEntityVarType getValType() {
        OlapBuilderInputType dataType = this.getCubeDataType();
        return OlapEntityVarType.fromInputType(dataType);
    }

    public boolean isRegular() {
        return true;
    }

    public void addCellProperty(OlapStringMdxCellPropertyValue cellPropertyValue) {
        if (this.cellProperties == null) {
            this.cellProperties = new OlapCellProperties();
        }
        this.cellProperties.addCellPropertyValue(cellPropertyValue);
    }

    @Nullable
    public Boolean isCached() {
        return this.cellProperties != null ? this.cellProperties.isCached() : null;
    }

    @Override
    protected boolean useDataHandler() {
        return false;
    }

    @Override
    @Nullable
    public OlapMember getParent() {
        return this.parent;
    }

    @Override
    protected void setParent(OlapMember parent) {
        this.parent = parent;
    }

    @Override
    public String getName(OlapNameContext nameContext) {
        return nameContext.getMemberName(this, this.name);
    }

    @Override
    @Nullable
    protected String doGetCaption(Locale locale) {
        String myCaption;
        if (this.cellProperties != null && CdStringUtils.isNotNullAndNotBlank((String)(myCaption = this.cellProperties.getCaption(locale)))) {
            return myCaption;
        }
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        return localization.getMeasureCaption(locale, this);
    }

    @Override
    @Nullable
    public String getDescription(Locale locale) {
        String caption;
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String descriptionL = localization.getMeasureDescription(locale, this);
        if (CdStringUtils.isNotNullAndNotBlank((String)descriptionL)) {
            return descriptionL;
        }
        String string = caption = this.cellProperties != null ? this.cellProperties.getDescription(locale) : null;
        if (CdStringUtils.isNotNullAndNotBlank((String)caption)) {
            return caption;
        }
        return null;
    }

    @Override
    public OlapMemberKey getKey() {
        return OlapNoValueMemberKey.INSTANCE;
    }

    @Override
    public Comparable getKeyValue() {
        return OlapNoValueMemberKey.INSTANCE;
    }

    @Override
    public boolean isMeasure() {
        return true;
    }

    @Override
    public OlapMeasureMember getMeasureMember() {
        return this;
    }

    public OlapBuilderInputType getCubeDataType() {
        return this.cubeDataType;
    }

    @Override
    @Nullable
    public String getDisplayFolder(Locale locale, OlapNameContext context) {
        return this.getDisplayFolder(locale, context, this.cellProperties != null ? this.cellProperties.getDisplayFolder() : null);
    }

    @Override
    public String getMeasureGroupName() {
        return this.measureGroup.getMeasureGroupName();
    }

    @Override
    public String getMeasureGroupNameForPermissions() {
        return this.measureGroup.getMeasureGroupName();
    }

    public String getMeasureGroupCaption(Locale locale, OlapNameContext nameContext) {
        String measureGroupName;
        OlapCube cube;
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String caption = localization.getMeasureGroupCaption(locale, cube = this.getCube(), measureGroupName = this.getMeasureGroupName());
        if (CdStringUtils.isNullOrBlank((String)caption)) {
            return measureGroupName;
        }
        return caption;
    }

    public IOlapBuilderBaseFactsDef getMeasureGroup() {
        return this.measureGroup;
    }

    public S_MeasureIndex getMeasureIndex() {
        return this.index;
    }

    @Override
    public OlapAggregationType getHierarchyAggregationType() {
        return this.hierarchyAggregationType;
    }

    @Nullable
    public OlapHierarchy getRollupHierarchy() {
        return this.rollupHierarchy;
    }

    public void setRollupHierarchy(@Nullable OlapHierarchy rollupHierarchy) {
        this.rollupHierarchy = rollupHierarchy;
    }

    public boolean isEmptyIsZero() {
        return this.emptyIsZero;
    }

    @Nullable
    public OlapScalarEntity setPropertyValue(String name, OlapScalarEntity value) {
        return this.properties.put(name, value);
    }

    @Override
    @Nullable
    protected OlapScalarEntity doGetPropertyValue(@Nullable OlapMemberFilter memberFilter, String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public boolean hasUserDefinedProperty(String propName) {
        return this.properties.get(propName) != null;
    }

    @Override
    @Nullable
    public OlapCellProperties getCellProperties() {
        return this.cellProperties;
    }

    public void setCellProperties(@Nullable OlapCellProperties cellProperties) {
        this.cellProperties = cellProperties;
    }

    @Override
    @Nullable
    public OlapCellPropertyValue getCellPropertyValue(OlapCellProperty property) {
        return this.cellProperties != null ? this.cellProperties.getCellPropertyValue(property) : null;
    }

    @Override
    public String getUniqueName(OlapNameContext nameContext) {
        return this.getDimension().getUniqueName(nameContext) + ".[" + CdMdxUtils.escape((String)this.getName(nameContext)) + "]";
    }

    @Override
    public OlapMemberUniqueNameType getUniqueNameType() {
        return OlapMemberUniqueNameType.X_MEASURE;
    }

    @Override
    public String getUniqueNameWithoutKeys(OlapNameContext nameContext) {
        return this.getDimension().getUniqueName(nameContext) + ".[" + CdMdxUtils.escape((String)this.getName(nameContext)) + "]";
    }

    @Override
    public OlapEntityType getEntityType() {
        return OlapEntityType.MEASURE;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    public OlapMeasureMember asNoEmptyMeasure() {
        return this.asNoEmptyMeasure;
    }

    public S_MeasureRef[] getClusterRefs() {
        if (this.measureRefs == null) {
            this.measureRefs = this.resolveClusterMeasureRefs();
        }
        return this.measureRefs;
    }

    private S_MeasureRef[] resolveClusterMeasureRefs() {
        return new S_MeasureRef[]{this.resolveClusterMeasureRef()};
    }

    protected S_MeasureRef resolveClusterMeasureRef() {
        OlapMeasuresDimension dimension = (OlapMeasuresDimension)this.getDimension();
        OlapSchema schema = dimension.getSchema();
        S_SchemaDef schemaDef = schema.getClusterSchemaDef();
        OlapCube cube = dimension.getCube();
        String cubeName = cube.getNameX();
        S_CubeDef cubeDef = schemaDef.resolveCube(cubeName);
        S_MeasureDef def = cubeDef.getMeasure(this.getNameX());
        S_MeasureRef ref = def.getRef();
        return ref;
    }

    @Nullable
    public OlapFactMeasureGroupBaseManager getMeasureGroupForNonEmptyBehavior() {
        IOlapFactMeasureGroupManagerForEval facts = this.getFactManager();
        if (facts instanceof OlapFactMeasureGroupBaseManager) {
            return (OlapFactMeasureGroupBaseManager)facts;
        }
        return null;
    }

    public IOlapFactMeasureGroupManagerForEval getFactManager() {
        if (this.factsManager == null) {
            this.factsManager = this.resolveFactManager();
        }
        return this.factsManager;
    }

    private IOlapFactMeasureGroupManagerForEval resolveFactManager() {
        OlapSchema schema = this.getDimension().getSchema();
        IOlapFactMeasureGroupManagerForEval factManager = schema.getFactManager(this);
        return factManager;
    }

    @Override
    public boolean existAllways() {
        return true;
    }

    public boolean measureHasNullsInFactColumns() {
        return this.getFactManager().measureHasNullsInFactColumns(this);
    }

    @Nullable
    public IOlapFactTableAggregator getTableAggregator() {
        return this.tableAggregator == null ? null : this.tableAggregator.newInstance();
    }

    public void setTableAggregator(IOlapFactTableAggregatorFactory tableAggregator) {
        this.tableAggregator = tableAggregator;
    }

    public boolean hasTableAggregation() {
        return this.tableAggregator != null;
    }
}

