/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapHollowableMember
extends OlapMember {
    private OlapMember factIndexingMember;

    protected OlapHollowableMember(OlapBuilderContext context, OlapLevel level, @Nullable OlapMember parent, @Nullable String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues memberProperties) {
        super(context, level, parent, name, key, memberProperties);
    }

    protected OlapHollowableMember(IOlapMemoryLevelMember dataHandler, int dataHandlerIdx, int uniqueHierarchyMemberIndex) {
        super(dataHandler, dataHandlerIdx, uniqueHierarchyMemberIndex);
    }

    @Override
    public boolean isFactHollow() {
        return this.factIndexingMember != null;
    }

    @Override
    @Nullable
    public final OlapMember getDefinedFactIndexingMember() {
        if (this.factIndexingMember != null && this.factIndexingMember.useDataHandler()) {
            IOlapMemoryLevelMember fIDataHandler = this.factIndexingMember.dataHandler;
            return fIDataHandler.refreshForOnTheFly(this.factIndexingMember);
        }
        return this.factIndexingMember;
    }

    @Override
    public final void setDefinedIndexingMember(OlapMember member) {
        this.factIndexingMember = member;
    }

    @Override
    @NotNull
    public OlapMember getFactIndexingMember() {
        OlapMember factIndexingMember = this.getDefinedFactIndexingMember();
        return factIndexingMember == null ? this : factIndexingMember.getFactIndexingMember();
    }

    protected void setFactIndexingMember(OlapBuilderContext context, OlapMember member) {
        if (member.isAll()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        if (this.mightBeFactHollow()) {
            this.setDefinedIndexingMember(member);
        }
    }

    void removeFactHollow(OlapBuilderContext context) {
        if (this.factIndexingMember != null && context != null) {
            context.onRemoveHollow(this, this.factIndexingMember);
            this.factIndexingMember = null;
            this.dataHandler.removeFactIndexingMember(this.dataHandlerIdx);
        }
    }

    protected boolean mightBeFactHollow() {
        return this.getHierarchy().mightBeFactHollow() && !this.isAll();
    }
}

