/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapNoBaseRegularMember;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapHollowRegularMember
extends OlapNoBaseRegularMember {
    private static long SHALLOW_SIZE_OF = -1L;
    private OlapMember baseMember;

    protected OlapHollowRegularMember(OlapBuilderContext context, OlapLevel level, @Nullable OlapMember parent, @Nullable String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues propertiesValues) {
        super(context, level, parent, name, key, propertiesValues);
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    protected boolean mightBeHollow() {
        return false;
    }

    @Override
    public OlapMember addBaseHierarchyChild(OlapBuilderContext context, OlapMember mainHierChild) {
        super.addBaseHierarchyChild(context, mainHierChild);
        this.addLinkToMainMember(mainHierChild);
        return mainHierChild;
    }

    @Override
    public void addLinkToMainMember(OlapMember mainHierChild) {
        OlapMember matchingMember = mainHierChild.getAncestor(this.getLevel().getHollowLevel());
        if (this.baseMember != null && !OlapMember.equal(matchingMember, this.baseMember)) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        this.baseMember = matchingMember;
    }

    @Override
    @NotNull
    public OlapMember getFactIndexingMember() {
        return this.baseMember.getFactIndexingMember();
    }

    @Override
    public boolean isFactHollow() {
        return true;
    }

    @Override
    public boolean isStructuralFactHollow() {
        return true;
    }

    @Override
    void handleFactHollowOnAddChild(OlapBuilderContext context, OlapMember child) {
    }
}

