/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.collection.CdActionEx;
import crazydev.common.collection.CdSetList;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.catmember.OlapCategoryMemberProperties;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.util.OlapNameIdentifiable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapAbstractCategoryMemberLogic {
    protected final OlapCategoryMember categoryMember;

    public OlapAbstractCategoryMemberLogic(OlapCategoryMember categoryMember) {
        this.categoryMember = categoryMember;
        this.sanityCheck();
    }

    private void sanityCheck() {
        OlapMember parent = this.categoryMember.getParent();
        if (parent != null && parent.getHierarchy() != this.categoryMember.getHierarchy()) {
            throw new RuntimeException("internal error : both category members should belong to the same hierarchy");
        }
    }

    public void init(OlapMdxStatementExecutionContext context) {
        CdSetList tree = new CdSetList();
        tree.add((Object)this.categoryMember);
        this.checkCycle((CdSetList<OlapCategoryMember>)tree);
        OlapCategoryMemberProperties properties = this.categoryMember.getProperties();
        if (properties.addChildren()) {
            this.categoryMember.resetOnDemandChildren();
            this.createChildren();
        }
        this.calculateDimensionality();
        this.categoryMember.registerToCluster(context);
    }

    protected void checkCycle(CdSetList<OlapCategoryMember> tree) {
        HashSet children = new HashSet();
        this.forEachTupleSet((CdActionEx<OlapTuple>)((CdActionEx)(idx, tuple) -> {
            for (int i = 0; i < tuple.getMemberCount(); ++i) {
                OlapMember member = tuple.getMember(i);
                if (!(member instanceof OlapCategoryMember)) continue;
                OlapCategoryMember categoryMember = (OlapCategoryMember)member;
                if (tree.contains((Object)categoryMember)) {
                    throw new OlapEvaluationException((OlapErrorLocation)null, OlapErrorCode.CATEGORY_CYCLE, new Serializable[]{ONames.uname4Log(categoryMember), ONames.name4Log((List<? extends OlapNameIdentifiable>)tree)});
                }
                children.add(categoryMember);
            }
            return true;
        }));
        for (OlapCategoryMember child : children) {
            CdSetList newTree = new CdSetList(tree);
            newTree.add((Object)child);
            child.getLogic().checkCycle((CdSetList<OlapCategoryMember>)newTree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createChildren() {
        OlapLevel olapLevel = this.categoryMember.getLevel();
        synchronized (olapLevel) {
            this.forEachTupleSet((CdActionEx<OlapTuple>)((CdActionEx)(idx, tuple) -> {
                this.categoryMember.createChild((OlapTuple)tuple);
                return true;
            }));
        }
    }

    protected void calculateDimensionality() {
        boolean apply2all = !this.sameTupleSetDimensionality();
        this.forEachTupleSet((CdActionEx<OlapTuple>)((CdActionEx)(idx, tuple) -> {
            this.categoryMember.setFactDimensionality((OlapTuple)tuple);
            return apply2all;
        }));
    }

    @Nullable
    public OlapSubCubeEntity getSubCube() {
        return null;
    }

    @Nullable
    public OlapIterator<? extends OlapTuple> getTupleIterator() {
        return null;
    }

    protected abstract boolean sameTupleSetDimensionality();

    protected abstract void forEachTupleSet(CdActionEx<OlapTuple> var1);

    public abstract boolean isOther();
}

