/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.level.IOlapLevelNameFactory;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMemberWithChildren;
import crazydev.iccube.olap.entity.member.OlapTupleCategoryMember;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nullable;

public abstract class OlapAbstractCategoryMember
extends OlapMemberWithChildren {
    private static final AtomicLong NEXT_CACHE_ID = new AtomicLong(0L);
    private final long cacheId = NEXT_CACHE_ID.getAndIncrement();
    private final OlapDimensionality factsDimensionality = new OlapDimensionality();
    @Nullable
    private final OlapEngineSessionContext session;
    @Nullable
    private final OlapEngineRequestContext request;

    protected OlapAbstractCategoryMember(@Nullable OlapEngineSessionContext session, @Nullable OlapEngineRequestContext request, OlapMember parent, String name) {
        super(null, OlapAbstractCategoryMember.getOrCreateLevel(parent), parent, name, null);
        this.session = session;
        this.request = request;
    }

    protected OlapAbstractCategoryMember(@Nullable OlapEngineSessionContext session, @Nullable OlapEngineRequestContext request, OlapMember parent, OlapLevel level) {
        super(null, level, parent, null, null);
        this.session = session;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OlapLevel getOrCreateLevel(OlapMember parent) {
        OlapDimension olapDimension = parent.getDimension();
        synchronized (olapDimension) {
            OlapLevel parentLevel = parent.getLevel();
            if (parentLevel.getNextLevel() != null) {
                return parentLevel.getNextLevel();
            }
            OlapLevel rootLevel = parent.getHierarchy().getFirstLevel();
            int levelDepth = parentLevel.getDepth() + 1;
            String levelName = OlapAbstractCategoryMember.createLevelName(rootLevel, levelDepth);
            OlapLevel newLevel = new OlapLevel(rootLevel.getHierarchy(), levelName, null, levelDepth, OlapMemberOrderByType.NONE, null, true, true, true);
            rootLevel.getHierarchy().addLevel(newLevel);
            return newLevel;
        }
    }

    private static String createLevelName(OlapLevel rootLevel, int depth) {
        OlapHierarchy hierarchy = rootLevel.getHierarchy();
        IOlapLevelNameFactory factory = hierarchy.getLevelNameFactory();
        Object name = factory == null ? rootLevel.getName(OlapNameContext.DEFAULT_VALUES) + "-" + depth : factory.createLevelName(depth);
        return name;
    }

    public long getCacheId() {
        return this.cacheId;
    }

    public void resetFactDimensionality() {
        this.factsDimensionality.clear();
    }

    public abstract OlapHierarchyScope getScope();

    @Nullable
    public OlapEngineSessionContext getSessionContext() {
        return this.session;
    }

    @Nullable
    public OlapEngineRequestContext getRequestContext() {
        return this.request;
    }

    protected void setFactDimensionality(OlapTuple underlying) {
        for (int i = 0; i < underlying.getMemberCount(); ++i) {
            OlapMember member = underlying.getMember(i);
            if (member instanceof OlapAbstractCategoryMember) {
                OlapAbstractCategoryMember categoryMember = (OlapAbstractCategoryMember)member;
                this.factsDimensionality.add(categoryMember.factsDimensionality);
                continue;
            }
            this.factsDimensionality.add(member.getDimension());
        }
    }

    protected void createChild(OlapTuple tuple) {
        if (tuple instanceof OlapMember) {
            OlapMember member = (OlapMember)tuple;
            new OlapMemberCategoryMember(this.session, this.request, (OlapMember)this, member);
        } else {
            new OlapTupleCategoryMember(this.session, this.request, (OlapMember)this, tuple);
        }
    }

    @Override
    public boolean isIn4Facts(OlapDimensionality dimensionality) {
        return dimensionality.intersects(this.factsDimensionality);
    }

    @Override
    protected boolean needsBitmapAtOlapMemberLevel(OlapLevel level) {
        return false;
    }

    @Override
    public boolean canNotBeCompacted() {
        return true;
    }

    @Override
    @Nullable
    public OlapBitmap getBaseMemberBitmap() {
        return OlapBitmap.getOne();
    }

    @Override
    protected void setBaseMemberBitmap(OlapMember child) {
    }

    @Override
    @Nullable
    public OlapBitmap getBaseMemberBitmap4Exist() {
        OlapMember parent = this.getParent();
        if (parent != null) {
            return parent.getBaseMemberBitmap();
        }
        return OlapBitmap.getOne();
    }

    @Override
    public boolean isCategoryMember() {
        return true;
    }

    public boolean isUnderlyingMember() {
        return false;
    }

    public OlapMember getUnderlyingMember() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Nullable
    public OlapIterator<? extends OlapTuple> getTupleIterator() {
        return null;
    }

    @Nullable
    public OlapSubCubeEntity getSubCube() {
        return null;
    }

    @Override
    public boolean isOtherCategory() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " [category] [cache-id:" + this.cacheId + "]";
    }

    @Override
    protected void setFactIndexingMember(OlapBuilderContext context, OlapMember member) {
    }
}

