/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.id;

import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapKeyIdentifiable;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierKeyPart;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.util.OlapIdentifiable;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class OlapEntityIdentifierMultiValueKeyPart
extends OlapEntityIdentifierKeyPart {
    private final String[] keys;

    public OlapEntityIdentifierMultiValueKeyPart(String[] keys) {
        this.keys = keys;
    }

    @Override
    public boolean isDelimited() {
        return true;
    }

    @Override
    public int getValueCount() {
        return this.keys.length;
    }

    public String getKey(int idx) {
        return this.keys[idx];
    }

    @Nullable
    public Comparable[] getJavaNativeValues(OlapBuilderInputType[] types) {
        Comparable[] values = new Comparable[types.length];
        for (int idx = 0; idx < values.length; ++idx) {
            Comparable value = types[idx].parseJavaNativeValue(this.keys[idx]);
            if (value == null) {
                return null;
            }
            values[idx] = value;
        }
        return values;
    }

    @Override
    public boolean isIdentifying(OlapNameContext nameContext, OlapIdentifiable entity) {
        if (entity instanceof OlapKeyIdentifiable) {
            OlapKeyIdentifiable keyIdentifiable = (OlapKeyIdentifiable)entity;
            OlapMemberKey keyEntity = keyIdentifiable.getKey();
            return keyEntity.isEquals(this.keys);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapEntityIdentifierMultiValueKeyPart that = (OlapEntityIdentifierMultiValueKeyPart)o;
        return Arrays.equals(this.keys, that.keys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.keys) {
            sb.append("&[").append(key).append("]");
        }
        return sb.toString();
    }
}

