/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.id;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierNamePart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import org.jetbrains.annotations.Nullable;

public class OlapEntityIdentifier {
    @Nullable
    private final MdxIdentifierExpression mdx;
    private final OlapEntityIdentifierPart[] parts;

    public OlapEntityIdentifier(String ... names) {
        this.mdx = null;
        this.parts = new OlapEntityIdentifierPart[names.length];
        for (int idx = 0; idx < names.length; ++idx) {
            this.parts[idx] = new OlapEntityIdentifierNamePart(true, names[idx]);
        }
    }

    public OlapEntityIdentifier(OlapEntityIdentifierPart ... parts) {
        this((MdxIdentifierExpression)null, parts);
    }

    public OlapEntityIdentifier(@Nullable MdxIdentifierExpression mdx, OlapEntityIdentifierPart ... parts) {
        this.mdx = mdx;
        this.parts = parts;
    }

    public String debug() {
        return Integer.toHexString(super.hashCode());
    }

    public boolean isAll() {
        return this.parts.length == 1 && this.parts[0].isAll();
    }

    public boolean isKey() {
        for (int idx = 0; idx < this.parts.length; ++idx) {
            if (!this.parts[idx].isKey()) continue;
            return true;
        }
        return false;
    }

    public int getPartCount() {
        return this.parts.length;
    }

    public OlapEntityIdentifierPart getFirstPart() {
        if (this.parts.length == 0) {
            throw new CdProgrammingException("Inconsistent getFirstPart usage!");
        }
        return this.parts[0];
    }

    public OlapEntityIdentifierPart getPart(int idx) {
        return this.parts[idx];
    }

    public OlapEntityIdentifierPart getLastPart() {
        if (this.parts.length == 0) {
            throw new CdProgrammingException("Inconsistent getLastPart usage!");
        }
        return this.parts[this.parts.length - 1];
    }

    public String getFirstPartAsName() {
        OlapEntityIdentifierPart firstPart = this.getFirstPart();
        if (!(firstPart instanceof OlapEntityIdentifierNamePart)) {
            throw new CdProgrammingException("Inconsistent getFirstPartAsName usage!");
        }
        return ((OlapEntityIdentifierNamePart)firstPart).getName();
    }

    public String getPartAsName(int idx) {
        OlapEntityIdentifierPart part = this.parts[idx];
        if (!(part instanceof OlapEntityIdentifierNamePart)) {
            throw new CdProgrammingException("Inconsistent getPartAsName usage!");
        }
        return ((OlapEntityIdentifierNamePart)part).getName();
    }

    public String getLastPartAsName() {
        OlapEntityIdentifierPart lastPart = this.getLastPart();
        if (!(lastPart instanceof OlapEntityIdentifierNamePart)) {
            throw new CdProgrammingException("Inconsistent getLastPartAsName usage!");
        }
        return ((OlapEntityIdentifierNamePart)lastPart).getName();
    }

    @Nullable
    public OlapEntityIdentifier prefix() {
        if (this.parts.length > 1) {
            return this.subIdentifier(0, this.parts.length - 1);
        }
        return null;
    }

    public OlapEntityIdentifier subIdentifier(int from) {
        return this.subIdentifier(from, this.parts.length);
    }

    public OlapEntityIdentifier subIdentifier(int from, int to) {
        if (from > to) {
            throw new CdProgrammingException("MDX identifier expression inconsistency [from:" + from + "] [to:" + to + "] [len:" + this.parts.length + "]");
        }
        if (from < 0) {
            throw new CdProgrammingException("MDX identifier expression inconsistency [from:" + from + "] [len:" + this.parts.length + "]");
        }
        if (from >= this.parts.length) {
            throw new CdProgrammingException("MDX identifier expression inconsistency [from:" + from + "] [len:" + this.parts.length + "]");
        }
        if (to > this.parts.length) {
            throw new CdProgrammingException("MDX identifier expression inconsistency [to:" + to + "] [len:" + this.parts.length + "]");
        }
        if (from == 0 && to == this.parts.length) {
            return this;
        }
        OlapEntityIdentifierPart[] sub = new OlapEntityIdentifierPart[to - from];
        System.arraycopy(this.parts, from, sub, 0, sub.length);
        MdxIdentifierExpression subMdx = null;
        if (this.mdx != null) {
            subMdx = this.mdx.subIdentifier(from, to);
        }
        return new OlapEntityIdentifier(subMdx, sub);
    }

    @Nullable
    public String asSingleRegularName() {
        if (this.isKey() || this.getPartCount() != 1) {
            return null;
        }
        OlapEntityIdentifierPart firstPart = this.getFirstPart();
        if (firstPart instanceof OlapEntityIdentifierNamePart) {
            OlapEntityIdentifierNamePart firstNamePart = (OlapEntityIdentifierNamePart)firstPart;
            String xname = firstNamePart.getName();
            return xname;
        }
        return null;
    }

    @Nullable
    public String asSingleNonDelimitedRegularName() {
        OlapEntityIdentifierNamePart firstNamePart;
        if (this.isKey() || this.getPartCount() != 1) {
            return null;
        }
        OlapEntityIdentifierPart firstPart = this.getFirstPart();
        if (firstPart instanceof OlapEntityIdentifierNamePart && !(firstNamePart = (OlapEntityIdentifierNamePart)firstPart).isDelimited()) {
            String xname = firstNamePart.getName();
            return xname;
        }
        return null;
    }

    @Nullable
    public String asMdxString() {
        return this.mdx != null ? this.mdx.asMdx() : null;
    }

    public String asString() {
        if (this.mdx != null) {
            return this.mdx.asMdx();
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < this.parts.length; ++idx) {
            String part = this.parts[idx].toString();
            if (idx > 0) {
                sb.append(".");
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public final boolean equals(Object o) {
        throw new CdProgrammingException();
    }

    public final int hashCode() {
        throw new CdProgrammingException();
    }

    public String toString() {
        return this.asString();
    }
}

