/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.hierarchy;

import crazydev.common.collection.CdAction;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderExcelTimeLineSupport;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapMultiLevelHierarchy
extends OlapHierarchy {
    private final boolean parentChild;
    private boolean isHollow;

    public OlapMultiLevelHierarchy(OlapDimension dimension, OlapHierarchyScope scope, int tupleDimensionalityIndex, String name, @Nullable String description, boolean isBase, boolean isCategory, boolean addAllLevel, @Nullable String allLevelName, boolean aggrFactOnAncestor, boolean parentChild, @Nullable OlapBuilderExcelTimeLineSupport excelTimeLineSupport, @Nullable Locale locale, @Nullable String folderName) {
        super(dimension, scope, tupleDimensionalityIndex, name, description, isBase, isCategory, aggrFactOnAncestor, excelTimeLineSupport, locale, folderName);
        if (addAllLevel) {
            String levelName = allLevelName == null || allLevelName.isEmpty() ? OlapBuilderBaseHierarchy.DEFAULT_ALL_LEVEL_NAME : allLevelName;
            this.addLevel(OlapLevel.createAllLevel(this, levelName));
        }
        this.parentChild = parentChild;
    }

    @Override
    public boolean isParentChild() {
        return this.parentChild;
    }

    @Override
    public OlapLevel addLevel(OlapLevel level) {
        if (level.getHierarchy() != this) {
            throw new CdProgrammingException("Level inconsistency.");
        }
        if (level.isAll() && !this.levels.isEmpty()) {
            throw new CdProgrammingException("Level inconsistency.");
        }
        if (!this.levels.isEmpty()) {
            OlapLevel last = (OlapLevel)this.levels.get(this.levels.size() - 1);
            last.setNextLevel(level);
            level.setPreviousLevel(last);
        }
        this.levels.add(level);
        return level;
    }

    @Override
    public List<OlapLevel> getLevels() {
        return this.levels;
    }

    @Override
    @Nullable
    public OlapLevel getAllLevel() {
        OlapLevel firstLevel = this.levels.isEmpty() ? null : (OlapLevel)this.levels.get(0);
        return firstLevel != null && firstLevel.isAll() ? firstLevel : null;
    }

    @Override
    public OlapLevel getFactIndexingLevel() {
        return this.getLastLevel();
    }

    @Override
    public void validateConsistency(OlapBuilderErrorManager errorManager) {
        super.validateConsistency(errorManager);
        if (this.getAllLevel() != null) {
            this.assertConsistencyForHasAll(errorManager.getNameContext());
        } else {
            this.assertConsistencyForNotHasAll(errorManager.getNameContext());
        }
    }

    private void assertConsistencyForHasAll(OlapNameContext nameContext) {
        if (this.getLevels().size() < 1) {
            throw new CdProgrammingException("multi-level (has-all) hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: no level.");
        }
        OlapLevel allLevel = this.getAllLevel();
        if (allLevel == null) {
            throw new CdProgrammingException("multi-level (has-all) hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: no all-level.");
        }
        if (!allLevel.isAll()) {
            throw new CdProgrammingException("multi-level (has-all) hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: all-level is not all-level.");
        }
        if (allLevel.getMemberCount() != 1) {
            throw new CdProgrammingException("multi-level (has-all) hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: all-level has more than one member.");
        }
        OlapMember allMember = this.getAllMember();
        if (allMember == null) {
            throw new CdProgrammingException("Multilevel (hasAll-1) hierarchy inconsistency.");
        }
        if (!allMember.isAll()) {
            throw new CdProgrammingException("Multilevel (hasAll-2) hierarchy inconsistency.");
        }
    }

    private void assertConsistencyForNotHasAll(OlapNameContext nameContext) {
        if (this.getLevels().size() < 1) {
            throw new CdProgrammingException("multi-level (no-all) hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: no level.");
        }
        if (this.getAllLevel() != null) {
            throw new CdProgrammingException("multi-level (no-all) hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: has all-level");
        }
        if (this.getAllMember() != null) {
            throw new CdProgrammingException("multi-level (no-all) hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: has all-member");
        }
        if (this.getNonNullDefaultMember(null).isAll()) {
            throw new CdProgrammingException("multi-level (no-all) hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: default member is all.");
        }
    }

    @Override
    public void forEachMember(CdAction<OlapMember> action) {
        OlapMember allMember = this.getAllMember();
        if (allMember != null) {
            action.apply((Object)allMember);
        }
        for (OlapLevel level : this.levels) {
            if (level.isAll()) continue;
            level.getDataHandler().forEachMember(action);
        }
    }

    @Nullable
    public OlapMember lookupMemberByKey(Comparable lookupKep) {
        OlapMemberKey key;
        OlapMember allMember = this.getAllMember();
        if (allMember != null && (key = allMember.getKey()).isSingleValue() && key.getValue().equals(lookupKep)) {
            return allMember;
        }
        for (OlapLevel level : this.levels) {
            OlapMember lookupMember = level.lookupMemberByKeyValue(lookupKep);
            if (lookupMember == null) continue;
            return lookupMember;
        }
        return null;
    }

    public void checkAndSetHollow() {
        boolean isHollow = true;
        for (int i = 0; i < this.levels.size(); ++i) {
            OlapLevel olapLevel = (OlapLevel)this.levels.get(i);
            if (olapLevel.isAll() || olapLevel.isHollow()) continue;
            isHollow = false;
            break;
        }
        this.isHollow = isHollow;
    }

    @Override
    public boolean isHollow() {
        return this.isHollow;
    }
}

