/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.hierarchy;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.level.OlapLevel;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapFlatHierarchy
extends OlapHierarchy {
    public OlapFlatHierarchy(OlapDimension dimension, int tupleDimensionalityIndex, String name, @Nullable String description, boolean isBase, boolean isCategory, @Nullable String levelName) {
        super(dimension, OlapHierarchyScope.SCHEMA, tupleDimensionalityIndex, name, description, isBase, isCategory, true, null, null, null);
        if (levelName != null) {
            this.addLevel(new OlapLevel((OlapHierarchy)this, levelName, null, 0, OlapMemberOrderByType.NONE, null, true, true, true));
        }
    }

    @Override
    public boolean isParentChild() {
        return false;
    }

    @Override
    public OlapLevel addLevel(OlapLevel level) {
        this.levels.add(level);
        return level;
    }

    @Override
    public List<OlapLevel> getLevels() {
        return this.levels;
    }

    public OlapLevel getLevel() {
        return (OlapLevel)this.levels.get(0);
    }

    @Override
    @Nullable
    public OlapLevel getAllLevel() {
        return null;
    }

    @Override
    public OlapLevel getFactIndexingLevel() {
        return this.getLastLevel();
    }

    @Override
    public void validateConsistency(OlapBuilderErrorManager errorManager) {
        super.validateConsistency(errorManager);
        OlapNameContext nameContext = errorManager.getNameContext();
        if (this.getLevels().size() != 1) {
            throw new CdProgrammingException("flat hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: more than one level.");
        }
        if (this.getAllLevel() != null) {
            throw new CdProgrammingException("flat hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: has a all-level.");
        }
        if (this.getAllMember() != null) {
            throw new CdProgrammingException("flat hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency: has a all-member");
        }
    }
}

