/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.dimension;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapFlatHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapMeasuresDimension
extends OlapDimension {
    public static final String UNAME = "[Measures]";
    public static final String NAME = "Measures";
    public static final String HIERARCHY_NAME = "Measures";
    public static final String LEVEL_NAME = "MeasuresLevel";
    private OlapCube cube;

    public OlapMeasuresDimension(OlapSchema schema, IOlapFactListFactory listFactory, int dimensionIndex, int tupleDimensionalityIndex) {
        super(null, schema, listFactory, dimensionIndex, false, "Measures", false);
        OlapFlatHierarchy hierarchy = this.addHierarchy(new OlapFlatHierarchy(this, tupleDimensionalityIndex, "Measures", null, true, false, LEVEL_NAME));
        List<OlapLevel> levels = hierarchy.getLevels();
        for (OlapLevel level : levels) {
            int index = schema.getNextLevelIndexAndIncrement();
            level.setUniqueIndex(index);
        }
    }

    @Override
    public OlapCube getCube() {
        return this.cube;
    }

    public void setupCube(OlapRegularCube cube) {
        this.cube = cube;
    }

    @Override
    public boolean isMeasures() {
        return true;
    }

    public OlapHierarchy getHierarchy() {
        return this.getBaseHierarchy();
    }

    public OlapLevel getLevel() {
        OlapFlatHierarchy hierarchy = (OlapFlatHierarchy)this.getMeasureHierarchy();
        return hierarchy.getLevel();
    }

    @Nullable
    public OlapMeasureMember unfilteredLookupMeasureByKey(OlapNameContext nameContext, IOlapBuilderMeasureDef key) {
        List<OlapMeasureMember> measures = this.getMeasureMembers(null);
        int size = measures.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapMeasureMember measure = measures.get(ii);
            if (!OlapCaseInsensitiveName.equals(measure.getName(nameContext), key.getName())) continue;
            return measure;
        }
        return null;
    }

    @Nullable
    public OlapMeasureMember unfilteredLookupMeasureByName(OlapNameContext nameContext, String name) {
        List<OlapMeasureMember> measures = this.getMeasureMembers(null);
        for (OlapMeasureMember measure : measures) {
            if (!OlapCaseInsensitiveName.equals(measure.getName(nameContext), name)) continue;
            return measure;
        }
        return null;
    }

    public void setCellProperties(OlapNameContext nameContext, String name, OlapCellProperties cellProperties) {
        OlapMeasureMember measure = this.unfilteredLookupMeasureByName(nameContext, name);
        if (measure != null) {
            measure.setCellProperties(cellProperties);
        }
    }

    @Override
    public void validateConsistency(OlapBuilderErrorManager errorManager) {
        if (this.getHierarchyCount() != 1) {
            throw new CdProgrammingException("[Measures] dimension inconsistency : multiple hierarchies.");
        }
        OlapHierarchy hierarchy = this.getMeasureHierarchy();
        if (!(hierarchy instanceof OlapFlatHierarchy)) {
            throw new CdProgrammingException("[Measures] dimension inconsistency : not a expected 'flat' hierarchy [" + hierarchy.getClass().getSimpleName() + "].");
        }
        super.validateConsistency(errorManager);
    }

    public OlapMeasureMember getDefaultMeasure(@Nullable OlapMemberFilter tupleFilter) {
        return (OlapMeasureMember)this.getMeasureHierarchy().getNonNullDefaultMember(tupleFilter);
    }

    public List<OlapMeasureMember> getMeasureMembers(@Nullable OlapMemberFilter tupleFilter) {
        OlapMember member;
        ArrayList<OlapMeasureMember> measures = new ArrayList<OlapMeasureMember>();
        OlapIterator memberIterator = this.getLevel().getMembers(tupleFilter).getIterator(false);
        memberIterator.reset();
        while ((member = (OlapMember)memberIterator.next()) != null) {
            measures.add((OlapMeasureMember)member);
        }
        OlapCubeCalculatedMemberManager manager = this.cube.getCalcMemberManager();
        List<OlapUserMeasureMember> userDefinedMeasures = manager.lookupUserMeasures(tupleFilter);
        measures.addAll(userDefinedMeasures);
        return measures;
    }

    @Override
    public boolean excludeDimensionName() {
        return true;
    }

    @Override
    public String getUniqueName(OlapNameContext nameContext) {
        return UNAME;
    }
}

