/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.dimension;

import crazydev.common.collection.CdAction;
import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.olap.OlapEntityType;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorizationx.permissions.dimension.OlapRoleDimensionAllPermissions;
import crazydev.iccube.authorizationx.permissions.dimension.OlapRoleDimensionPermissions;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.type.MembersBehavior;
import crazydev.iccube.builder.type.MembersUpperLowerStrategyType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaDimensionIndex;
import crazydev.iccube.olap.schema.OlapSchemaReference;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.schema.stats.OlapDimensionStats;
import crazydev.iccube.olap.schema.stats.OlapHierarchyStats;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapDimension
extends OlapNonScalarAbstractEntity
implements OlapNameIdentifiableEntity {
    public static final String FRIENDLY_NAME = "dimension";
    private final OlapRoleDimensionAllPermissions allPermissions;
    private final OlapSchemaReference schemaReference;
    private final IOlapFactListFactory listFactory;
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final MembersBehavior membersBehavior;
    private final boolean isFactIndexing;
    private final boolean indexingByRange;
    private final OlapSchemaDimensionIndex dimensionalityIndex;
    private final List<OlapHierarchy> hierarchies = new ArrayList<OlapHierarchy>();
    private final boolean alwaysVisibleReporting;
    private final MembersUpperLowerStrategyType membersUpperLowerCaseStrategy;
    @Nullable
    private OlapHierarchy baseHierarchy;
    private String uniqueName;
    @Nullable
    private OlapMember unknownMember;
    private boolean canDoHollow = true;
    private int loadingRowCount = 0;
    private volatile long processingElapsedMS;

    public OlapDimension(@Nullable IOlapBuilderDimensionDef dimensionDef, OlapSchema schema, IOlapFactListFactory listFactory, int dimensionIndex, boolean isFactIndexing, String name, boolean indexingByRange) {
        this.allPermissions = new OlapRoleDimensionAllPermissions(this);
        this.schemaReference = new OlapSchemaReference(schema);
        this.listFactory = listFactory;
        this.name = name;
        this.description = dimensionDef != null ? dimensionDef.getDescription() : null;
        this.membersBehavior = dimensionDef != null ? dimensionDef.getMembersBehavior() : null;
        this.isFactIndexing = isFactIndexing;
        this.indexingByRange = indexingByRange;
        this.alwaysVisibleReporting = dimensionDef != null && dimensionDef.getAlwaysVisibleReporting();
        MembersUpperLowerStrategyType membersUpperLowerStrategyType = this.membersUpperLowerCaseStrategy = dimensionDef != null ? dimensionDef.getMembersUpperLowerCaseStrategy() : null;
        if (dimensionIndex == -1) {
            throw new RuntimeException("internal error: inconsistent index [" + dimensionIndex + "] for dimension [" + name + "]");
        }
        this.dimensionalityIndex = new OlapSchemaDimensionIndex(dimensionIndex);
        this.processingElapsedMS = -1L;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.DIMENSION;
    }

    public void resetForSchema(OlapSchema otherSchema, int nextDimensionIndexOffset, int nextHierarchyIndexOffset) {
        this.schemaReference.resetForSchema(otherSchema);
        for (OlapHierarchy hierarchy : this.hierarchies) {
            this.dimensionalityIndex.resetForSchema(otherSchema, nextDimensionIndexOffset);
            hierarchy.resetForSchema(otherSchema, nextHierarchyIndexOffset);
        }
    }

    public void validateConsistency(OlapBuilderErrorManager errorManager) {
        List<OlapHierarchy> myHierarchies = this.getHierarchies();
        if (myHierarchies.isEmpty()) {
            errorManager.addError(OlapBuilderErrorCode.DIMENSION_NO_HIERARCHY, new Serializable[]{ONames.uname4Log(this)});
        }
        for (OlapHierarchy hierarchy : myHierarchies) {
            hierarchy.validateConsistency(errorManager);
        }
    }

    public IOlapFactListFactory getListFactory() {
        return this.listFactory;
    }

    @Nullable
    public OlapCube getCube() {
        return null;
    }

    public OlapRoleDimensionPermissions getAllPermissions() {
        return this.allPermissions;
    }

    public OlapSchema getSchema() {
        return this.schemaReference.getSchema();
    }

    public String getNameX() {
        return this.getName(OlapNameContext.DEFAULT_VALUES);
    }

    @Override
    public String getName(OlapNameContext nameContext) {
        return nameContext.getDimensionName(this, this.name);
    }

    @Override
    public String getUniqueName(OlapNameContext nameContext) {
        if (nameContext.hasNewUniqueName(this)) {
            return "[" + CdMdxUtils.escape((String)this.getName(nameContext)) + "]";
        }
        if (this.uniqueName == null) {
            this.uniqueName = this.createUniqueName();
        }
        return this.uniqueName;
    }

    private String createUniqueName() {
        return "[" + CdMdxUtils.escape((String)this.name) + "]";
    }

    @Override
    public String getCaption(Locale locale, OlapNameContext nameContext) {
        OlapSchema schema = this.getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String caption = localization.getDimensionCaption(locale, this);
        if (CdStringUtils.isNullOrBlank((String)caption)) {
            caption = this.getName(nameContext);
        }
        return caption;
    }

    @Override
    @Nullable
    public String getDescription(Locale locale) {
        OlapSchema schema = this.getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String descriptionL = localization.getDimensionDescription(locale, this);
        if (CdStringUtils.isNotNullAndNotBlank((String)descriptionL)) {
            return descriptionL;
        }
        return this.description;
    }

    @Override
    public boolean isAllMember() {
        return false;
    }

    public boolean isIndexingByRange() {
        return this.indexingByRange;
    }

    public OlapHierarchy getFactIndexingHierarchy() {
        OlapHierarchy hierarchy = this.getBaseHierarchy();
        if (!hierarchy.isBase()) {
            throw new CdProgrammingException("Hierarchy '" + String.valueOf(hierarchy) + "' is not a base hierarchy");
        }
        return hierarchy;
    }

    public OlapHierarchy getMeasureHierarchy() {
        if (this.isMeasures()) {
            return this.getBaseHierarchy();
        }
        throw new CdProgrammingException("[Measures] only!");
    }

    public OlapHierarchy getBaseHierarchy() {
        OlapHierarchy myBaseHierarchy = this.baseHierarchy;
        if (myBaseHierarchy == null) {
            throw new CdProgrammingException("No base hierarchy has been defined in the dimension [" + ONames.name4Log(this) + "].");
        }
        return myBaseHierarchy;
    }

    @Nullable
    public OlapHierarchy getBaseHierarchyEx() {
        return this.baseHierarchy;
    }

    public int getHierarchyCount() {
        return this.getHierarchies().size();
    }

    public int getHierarchyCount(IOlapDimensionsPermission permissions) {
        return this.getHierarchies(permissions).size();
    }

    public boolean isSingleHierarchy(IOlapDimensionsPermission permissions) {
        return this.getHierarchyCount(permissions) == 1;
    }

    public OlapHierarchy getSingleHierarchy(IOlapDimensionsPermission permissions) {
        List<OlapHierarchy> authorized = this.getHierarchies(permissions);
        if (authorized.size() == 1) {
            return authorized.get(0);
        }
        throw new CdDoNotCallMeProgrammingException();
    }

    @Nullable
    public OlapHierarchy getDefaultTimeHierarchy(IOlapDimensionsPermission permissions) {
        if (!this.isDefaultTimeDimension()) {
            throw new CdDoNotCallMeProgrammingException();
        }
        List<OlapHierarchy> authorized = this.getHierarchies(permissions);
        if (!authorized.isEmpty()) {
            return authorized.get(0);
        }
        return null;
    }

    public List<OlapHierarchy> getHierarchies() {
        return this.hierarchies;
    }

    public List<OlapHierarchy> getHierarchies(IOlapDimensionsPermission permissions) {
        IOlapDimensionPermission dimensionPermissions = permissions.getDimensionPermissions(this);
        return this.getHierarchies(dimensionPermissions);
    }

    public List<OlapHierarchy> getHierarchies(IOlapDimensionPermission permissions) {
        if (!permissions.getDimension().equals(this)) {
            throw new CdProgrammingException("internal error : unexpected dimension [" + ONames.name4Log(permissions.getDimension()) + "] : " + ONames.name4Log(this));
        }
        ArrayList<OlapHierarchy> authorized = new ArrayList<OlapHierarchy>();
        for (OlapHierarchy hierarchy : this.getHierarchies()) {
            if (!permissions.isHierarchyAuthorized(hierarchy)) continue;
            authorized.add(hierarchy);
        }
        return authorized;
    }

    public <T extends OlapHierarchy> T addHierarchy(T hierarchy) {
        this.hierarchies.add(hierarchy);
        if (hierarchy.isBase()) {
            OlapHierarchy myBaseHierarchy = this.baseHierarchy;
            if (myBaseHierarchy != null) {
                throw new CdProgrammingException("In dimension [" + ONames.name4Log(this) + "], cannot add the base hierarchy [" + ONames.name4Log(hierarchy) + "] because of an existing base hierarchy [" + ONames.name4Log(myBaseHierarchy) + "] - only one base hierarchy is authorized.");
            }
            this.baseHierarchy = hierarchy;
        }
        return hierarchy;
    }

    public boolean isMeasures() {
        return false;
    }

    public boolean isTime() {
        return false;
    }

    @Override
    protected OlapTupleSet<?> toSet_(IOlapPrepareContext context) {
        try {
            return this.getSingleHierarchy(context.getDimensionsPermissions()).toSet(context);
        }
        catch (RuntimeException ignore) {
            throw new OlapEvaluationException(context, OlapErrorCode.TO_SET_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY, new Serializable[]{this.getName(context.getNameContext())});
        }
    }

    @Override
    public boolean isToSetApplicable(IOlapPrepareContext context) {
        return this.isSingleHierarchy(context.getDimensionsPermissions());
    }

    @Override
    public OlapTuple toTuple(IOlapPrepareContext context) {
        return this.getSingleHierarchy(context.getDimensionsPermissions()).toTuple(context);
    }

    @Override
    public boolean isToTupleApplicable(IOlapPrepareContext context) {
        return this.isSingleHierarchy(context.getDimensionsPermissions());
    }

    @Override
    @Nullable(value="possibly null when delegating the call to the (possibly empty 'coz of filtering) hierarchy default member")
    public @Nullable(value="possibly null when delegating the call to the (possibly empty 'coz of filtering) hierarchy default member") OlapMember toNullableMember(IOlapPrepareContext context) {
        return this.getSingleHierarchy(context.getDimensionsPermissions()).toNullableMember(context);
    }

    @Override
    public boolean isToMemberApplicable(IOlapPrepareContext context) {
        return this.isSingleHierarchy(context.getDimensionsPermissions());
    }

    @Override
    public OlapScalarEntity toValue(GFContext context, GFTupleEvaluator evaluator) {
        return this.getSingleHierarchy(context.getDimensionsPermissions()).toValue(context, evaluator);
    }

    @Override
    public boolean isToValueApplicable(GFContext context, GFTupleEvaluator evaluator) {
        return this.isSingleHierarchy(context.getDimensionsPermissions());
    }

    @Override
    public boolean isScoping(OlapMember member) {
        return member.getDimension().equals(this);
    }

    @Override
    public boolean isScoping(OlapHierarchy hierarchy) {
        return hierarchy.getDimension().equals(this);
    }

    @Override
    public OlapEntityType getEntityType() {
        return OlapEntityType.DIMENSION;
    }

    public OlapNonScalarEntity lookupEntityByMdxIdentifier(OlapNameContext nameContext, IOlapDimensionsPermission permissions, @Nullable List<OlapHierarchy> extraHierarchies, OlapEntityIdentifier id) {
        OlapNonScalarEntity entity = null;
        if (extraHierarchies != null && !extraHierarchies.isEmpty()) {
            entity = OlapDimension.doLookupEntityByMdxIdentifier(nameContext, permissions, extraHierarchies, id);
        }
        if (entity == null) {
            List<OlapHierarchy> myHierarchies = this.getHierarchies(permissions);
            entity = OlapDimension.doLookupEntityByMdxIdentifier(nameContext, permissions, myHierarchies, id);
        }
        return entity != null ? entity : OlapNullEntity.INSTANCE;
    }

    @Nullable
    private static OlapNonScalarEntity doLookupEntityByMdxIdentifier(OlapNameContext nameContext, IOlapDimensionsPermission permissions, List<OlapHierarchy> hierarchies, OlapEntityIdentifier id) {
        OlapHierarchy hierarchy;
        int idx;
        OlapEntityIdentifierPart hierarchyId = id.getPart(0);
        int hierarchiesSize = hierarchies.size();
        for (idx = 0; idx < hierarchiesSize; ++idx) {
            hierarchy = hierarchies.get(idx);
            if (!hierarchyId.isIdentifying(nameContext, hierarchy)) continue;
            if (id.getPartCount() == 1) {
                return hierarchy;
            }
            OlapEntityIdentifier next = id.subIdentifier(1);
            return hierarchy.lookupEntityByMdxIdentifier(nameContext, permissions, next);
        }
        for (idx = 0; idx < hierarchiesSize; ++idx) {
            hierarchy = hierarchies.get(idx);
            OlapNonScalarEntity entity = hierarchy.lookupEntityByMdxIdentifier(nameContext, permissions, id);
            if (entity.isMdxNull()) continue;
            return entity;
        }
        return null;
    }

    public boolean isDefaultTimeDimension() {
        return false;
    }

    @Nullable
    public OlapHierarchy lookupHierarchyByName(OlapNameContext nameContext, String name) {
        int size = this.hierarchies.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapHierarchy hierarchy = this.hierarchies.get(ii);
            if (!OlapCaseInsensitiveName.equals(hierarchy.getName(nameContext), name)) continue;
            return hierarchy;
        }
        return null;
    }

    @Nullable
    public OlapHierarchy lookupHierarchyByName(OlapNameContext nameContext, IOlapDimensionsPermission permissions, String name) {
        for (OlapHierarchy hierarchy : this.getHierarchies(permissions)) {
            if (!OlapCaseInsensitiveName.equals(hierarchy.getName(nameContext), name)) continue;
            return hierarchy;
        }
        return null;
    }

    public int getDimensionalityIndex() {
        return this.dimensionalityIndex.getValue();
    }

    public int getTupleDimensionalityIndex() {
        return this.getBaseHierarchy().getTupleDimensionalityIndex();
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public final int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) {
        return "[" + CdMdxUtils.escape((String)this.name) + "]";
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    public String toString() {
        return this.name + " (" + this.getDimensionalityIndex() + ")";
    }

    @Nullable
    public OlapMember getUnknownMemberForFacts() {
        return this.unknownMember;
    }

    public void setUnknownMember(OlapMember unknownMember) {
        this.unknownMember = unknownMember;
    }

    @Nullable
    public String addUnknownMember(OlapBuilderContext context, String unknownMemberName) {
        OlapNameContext nameContext = context.getNameContext();
        OlapHierarchy baseHierarchy = this.getBaseHierarchy();
        OlapMember leafBaseMember = baseHierarchy.addUnknownMember(context, null, unknownMemberName);
        if (leafBaseMember == null) {
            return baseHierarchy.getName(nameContext);
        }
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            OlapHierarchy hierarchy = this.hierarchies.get(i);
            if (hierarchy.isBase()) continue;
            hierarchy.addUnknownMember(context, leafBaseMember, unknownMemberName);
        }
        this.setUnknownMember(leafBaseMember);
        this.getHierarchies().forEach(hier -> hier.getLevels().forEach(olapLevel -> olapLevel.getDataHandler().onProcessAttributes()));
        return null;
    }

    public void onFinishBuild(boolean incrLoad, boolean incrLoadActive) {
        int size = this.hierarchies.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapHierarchy hierarchy = this.hierarchies.get(ii);
            hierarchy.onFinishBuild(incrLoad, incrLoadActive);
        }
    }

    public void setProcessingElapsedMS(long processingElapsedMS) {
        this.processingElapsedMS = processingElapsedMS;
    }

    public long getProcessingElapsedMS() {
        return this.processingElapsedMS;
    }

    public boolean isFactIndexing() {
        return this.isFactIndexing;
    }

    public void forEachNoBaseTerminalMember(OlapMember baseMember, CdAction<OlapMember> action) {
        for (OlapHierarchy hierarchy : this.hierarchies) {
            if (hierarchy.isHollow()) continue;
            hierarchy.forEachNoBaseTerminalMember(baseMember, action);
        }
    }

    public boolean excludeDimensionName() {
        OlapSchema schema = this.getSchema();
        return schema.excludeDimensionName();
    }

    public Comparable adaptKeyValue(Comparable javaNativeDataValue) {
        return javaNativeDataValue;
    }

    public int getMemberCount() {
        int count = 0;
        for (OlapHierarchy hierarchy : this.getHierarchies()) {
            count += hierarchy.getMemberCount();
        }
        return count;
    }

    public void assertMissingHierarchy(OlapHierarchy hierarchy) {
        for (OlapHierarchy olapHierarchy : this.hierarchies) {
            if (olapHierarchy != hierarchy) continue;
            throw new RuntimeException("internal error : unexpected hierarchy : " + ONames.uname4Log(hierarchy));
        }
    }

    public void removeAllCategoryHierarchies() {
        ArrayList<OlapHierarchy> toDelete = new ArrayList<OlapHierarchy>();
        for (OlapHierarchy hierarchy : this.hierarchies) {
            if (!hierarchy.acceptCategoryMembers()) continue;
            hierarchy.deleteAllCategoryMembers();
            if (!hierarchy.isCategory()) continue;
            toDelete.add(hierarchy);
        }
        for (OlapHierarchy hierarchy : toDelete) {
            this.removeCategoryHierarchy(hierarchy);
        }
    }

    public boolean removeCategoryHierarchy(OlapHierarchy hierarchy) {
        if (this.hierarchies.remove(hierarchy)) {
            OlapSchema schema = this.getSchema();
            int index = hierarchy.getTupleDimensionalityIndex();
            schema.releaseNextHierarchyIndex(index);
        }
        return false;
    }

    public OlapDimensionStats createStats() {
        ArrayList<OlapHierarchyStats> hierarchyStats = new ArrayList<OlapHierarchyStats>();
        for (OlapHierarchy hierarchy : this.hierarchies) {
            hierarchyStats.add(hierarchy.createStats());
        }
        return new OlapDimensionStats(this.name, hierarchyStats, this.getProcessingElapsedMS());
    }

    public OlapDimensionStats createIncrLoadStats() {
        ArrayList<OlapHierarchyStats> hierarchyStats = new ArrayList<OlapHierarchyStats>();
        for (OlapHierarchy hierarchy : this.hierarchies) {
            hierarchyStats.add(hierarchy.createIncrLoadStats());
        }
        return new OlapDimensionStats(this.name, hierarchyStats, this.getProcessingElapsedMS());
    }

    @Override
    public String toStringForDebugger() {
        return this.getUniqueName(OlapNameContext.DEFAULT_VALUES);
    }

    public void setCanNotDoHollow() {
        this.canDoHollow = false;
    }

    public boolean canDoHollow() {
        return this.canDoHollow;
    }

    public boolean isAlwaysVisibleReporting() {
        return this.alwaysVisibleReporting;
    }

    public boolean isMembersAllMembers() {
        return this.membersBehavior == MembersBehavior.ALL_MEMBERS;
    }

    public OlapHierarchy getHierarchyByName(String hierarchyName) {
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            OlapHierarchy olapHierarchy = this.hierarchies.get(i);
            if (!olapHierarchy.getNameX().equals(hierarchyName)) continue;
            return olapHierarchy;
        }
        return null;
    }

    public void incrementOnNewLoadRowToBuild() {
        ++this.loadingRowCount;
    }

    public int rowCount() {
        return this.loadingRowCount;
    }

    public MembersUpperLowerStrategyType membersUpperLowerCaseStrategy() {
        return this.membersUpperLowerCaseStrategy == null ? this.getSchema().membersUpperLowerCaseStrategy() : this.membersUpperLowerCaseStrategy;
    }
}

