/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.common;

import crazydev.common.collection.CdPaginatedSortedIntList;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.olap.entity.common.OlapNewChildren;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapNewMemberSortedChildrenList
extends OlapNewChildren {
    protected static long SHALLOW_SIZE_OF = -1L;
    private final CdPaginatedSortedIntList memberLevelIdx = new CdPaginatedSortedIntList((o1, o2) -> comparator.compare(this.getMemberFromLevelIdx((int)o1), this.getMemberFromLevelIdx((int)o2)));

    public OlapNewMemberSortedChildrenList(OlapLevel expectedLevel, Comparator<OlapMember> comparator) {
        super(expectedLevel);
    }

    @Override
    public void trimToSize() {
        super.trimToSize();
        this.memberLevelIdx.trimToSize();
    }

    @Override
    public boolean isEmpty() {
        return this.memberLevelIdx.isEmpty();
    }

    @Override
    public int size() {
        return this.memberLevelIdx.size();
    }

    @Override
    protected int getDataHandlerIdx(int idx) {
        return this.memberLevelIdx.getInt(idx);
    }

    @Override
    protected int getMembersDataHandlerIdx(int dataHandlerIdx) {
        return this.memberLevelIdx.indexOf(dataHandlerIdx);
    }

    @Override
    protected void addToMemberList(int dataHandlerIdx) {
        this.memberLevelIdx.add(dataHandlerIdx);
    }

    @Override
    @Nullable
    public OlapMember binaryLookupFromKey4Comp(OlapLevel keyLevel, Object keyValue) {
        Object keyForCompare = keyLevel.getKeyForCompare(keyValue);
        int pos = this.memberLevelIdx.binarySearch(keyForCompare, this.getComparatorForBinarySearch(keyLevel.getOrderKind().isAsc()));
        if (pos >= 0) {
            OlapMember member = this.get(pos);
            return member;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapMember binaryRangeLookupFromKey4Comp(Object keyForCompare, boolean isAsc, boolean hasUnknown) {
        if (hasUnknown) {
            return this.searchRangeLookupFRomKey4Comp(keyForCompare, isAsc);
        }
        if (isAsc) {
            int pos = this.memberLevelIdx.binarySearch(keyForCompare, this.getComparatorForBinarySearch(true));
            int memberPos = pos >= 0 ? pos : Math.min(this.size() - 1, Math.max(0, -2 - pos));
            return this.get(memberPos);
        }
        int pos = this.memberLevelIdx.binarySearch(keyForCompare, this.getComparatorForBinarySearch(false));
        int memberPos = pos >= 0 ? pos : Math.min(this.size() - 1, Math.max(0, -1 - pos));
        return this.get(memberPos);
    }

    @Nullable
    private OlapMember searchRangeLookupFRomKey4Comp(Object keyForCompare, boolean isAsc) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        int createdUnknownMemberIdx = this.createdUnknownDataHandlerIdx();
        Comparator comparator = this.getComparatorForBinarySearch(isAsc);
        int invalidPrevIdx = Integer.MIN_VALUE;
        int prevIdx = Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            int dataHandlerIdx = this.memberLevelIdx.getInt(i);
            if (dataHandlerIdx == createdUnknownMemberIdx) continue;
            int res = comparator.compare(dataHandlerIdx, keyForCompare);
            if (res == 0) {
                return this.getMemberFromLevelIdx(dataHandlerIdx);
            }
            if (res > 0) {
                return this.getMemberFromLevelIdx(prevIdx == Integer.MIN_VALUE || !isAsc ? dataHandlerIdx : prevIdx);
            }
            prevIdx = dataHandlerIdx;
        }
        if (prevIdx == Integer.MIN_VALUE) {
            return null;
        }
        return this.getMemberFromLevelIdx(prevIdx);
    }

    @NotNull
    private Comparator getComparatorForBinarySearch(boolean isAsc) {
        return (o1, keyForCompare) -> {
            int dataHandlerIdx;
            IOlapMemoryLevelMember dataHandler;
            int idx = (Integer)o1;
            if (idx >= 0) {
                dataHandler = this.expectedLevel.getDataHandler();
                dataHandlerIdx = idx;
            } else {
                OlapMember raggedMember = this.getFromRagged(idx);
                dataHandler = raggedMember.getLevel().getDataHandler();
                dataHandlerIdx = raggedMember.getDataHandlerIdx();
            }
            int compareValue = dataHandler.naturalCompareWithKeyForCompare(dataHandlerIdx, keyForCompare);
            return isAsc ? -compareValue : compareValue;
        };
    }

    @Override
    public long shallowSizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += this.memberLevelIdx.sizeOf();
        return size += super.shallowSizeOf();
    }
}

