/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.cmember;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSessionCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapSessionCalculatedMembers
implements IOlapCalculatedMembers {
    private final OlapSessionCalculatedMemberManager sessionCalcMemberManager;
    @Nullable
    private final OlapCalculatedMemberManager calcMemberManager;

    public OlapSessionCalculatedMembers(OlapSessionCalculatedMemberManager sessionCalcMemberManager, @Nullable OlapCalculatedMemberManager calcMemberManager) {
        this.sessionCalcMemberManager = sessionCalcMemberManager;
        this.calcMemberManager = calcMemberManager;
    }

    @Override
    public List<OlapUserMeasureMember> getUserMeasures(@Nullable OlapMemberFilter memberFilter) {
        String cubeName;
        ArrayList<OlapUserMeasureMember> measures = new ArrayList<OlapUserMeasureMember>();
        if (this.calcMemberManager != null) {
            measures.addAll(this.calcMemberManager.getUserMeasures(memberFilter));
        }
        measures.addAll(this.sessionCalcMemberManager.getUserMeasures(memberFilter));
        if (this.calcMemberManager != null && (cubeName = this.calcMemberManager.getCubeName()) != null) {
            measures.addAll(this.sessionCalcMemberManager.getUserMeasures(cubeName, memberFilter));
        }
        return measures;
    }

    @Override
    public List<OlapMember> getVisibleCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        String cubeName;
        ArrayList<OlapMember> calcMembers = new ArrayList<OlapMember>();
        if (this.calcMemberManager != null) {
            calcMembers.addAll(this.calcMemberManager.getVisibleCalculatedMembers(tupleFilter));
        }
        calcMembers.addAll(this.sessionCalcMemberManager.getVisibleCalculatedMembers(tupleFilter));
        if (this.calcMemberManager != null && (cubeName = this.calcMemberManager.getCubeName()) != null) {
            calcMembers.addAll(this.sessionCalcMemberManager.getVisibleCalculatedMembers(cubeName, tupleFilter));
        }
        return calcMembers;
    }

    @Override
    public List<OlapMember> getInvisibleCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        String cubeName;
        ArrayList<OlapMember> calcMembers = new ArrayList<OlapMember>();
        if (this.calcMemberManager != null) {
            calcMembers.addAll(this.calcMemberManager.getInvisibleCalculatedMembers(tupleFilter));
        }
        calcMembers.addAll(this.sessionCalcMemberManager.getInvisibleCalculatedMembers(tupleFilter));
        if (this.calcMemberManager != null && (cubeName = this.calcMemberManager.getCubeName()) != null) {
            calcMembers.addAll(this.sessionCalcMemberManager.getInvisibleCalculatedMembers(cubeName, tupleFilter));
        }
        return calcMembers;
    }

    @Override
    @Nullable
    public OlapMember lookupCalculatedMember(OlapNameContext nameContext, OlapEntityIdentifier id) {
        OlapMember member = this.sessionCalcMemberManager.lookupCalculatedMember(nameContext, id);
        if (member != null) {
            return member;
        }
        if (this.calcMemberManager != null) {
            String cubeName = this.calcMemberManager.getCubeName();
            if (cubeName != null && (member = this.sessionCalcMemberManager.lookupCalculatedMember(cubeName, nameContext, id)) != null) {
                return member;
            }
            member = this.calcMemberManager.lookupCalculatedMember(nameContext, id);
        }
        return member;
    }
}

