/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.cmember;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapSelectCalculatedMemberManager
extends OlapCalculatedMemberManager {
    private final OlapCubeCalculatedMemberManager cubeCalcMemberManager;
    private final Map<OlapHierarchy, Integer> indices = new HashMap<OlapHierarchy, Integer>();

    public OlapSelectCalculatedMemberManager(OlapCubeCalculatedMemberManager cubeCalculatedMemberManager) {
        this.cubeCalcMemberManager = cubeCalculatedMemberManager;
        cubeCalculatedMemberManager.setupOtherLastPositions(this);
    }

    @Override
    @Nullable
    public String getCubeName() {
        return this.cubeCalcMemberManager.getCubeName();
    }

    @Override
    protected boolean contains(OlapNameContext nameContext, OlapMember member) {
        return super.contains(nameContext, member) || this.cubeCalcMemberManager.contains(nameContext, member);
    }

    public OlapMember addIfNotContained(@Nullable OlapErrorLocation errorLocation, OlapNameContext nameContext, OlapMember member) {
        if (!member.isDefinedAtSelectStatementLevel()) {
            throw new CdProgrammingException("internal error: not a SELECT calc. member!");
        }
        if (this.contains(nameContext, member)) {
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.DUPLICATED_CALC_MEMBER, new Serializable[]{member.getName(nameContext)});
        }
        OlapHierarchy hierarchy = member.getHierarchy();
        Integer index = this.indices.get(hierarchy);
        if (index == null) {
            index = hierarchy.getCurrentMemberIndex();
        }
        index = index + 1;
        this.indices.put(hierarchy, index);
        member.setLocalUniqueHierarchyMemberIndex(index);
        return this.doAddIfNotContained(errorLocation, nameContext, member);
    }

    @Override
    protected boolean containsUserMeasure(OlapNameContext nameContext, OlapUserMeasureMember member) {
        return super.containsUserMeasure(nameContext, member) || this.cubeCalcMemberManager.containsUserMeasure(nameContext, member);
    }

    public void addUserMeasureIfNotContained(@Nullable OlapErrorLocation errorLocation, OlapNameContext nameContext, OlapUserMeasureMember measure) {
        if (!measure.isDefinedAtSelectStatementLevel()) {
            throw new RuntimeException("internal error: not a SELECT measure");
        }
        if (this.containsUserMeasure(nameContext, measure)) {
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.DUPLICATED_MEASURE, new Serializable[]{measure.getName(nameContext)});
        }
        this.doAddUserMeasureIfNotContained(errorLocation, nameContext, measure);
    }

    @Override
    @Nullable
    public OlapMember lookupCalculatedMember(OlapNameContext nameContext, OlapEntityIdentifier id) {
        OlapMember member = this.cubeCalcMemberManager.lookupCalculatedMember(nameContext, id);
        if (member != null) {
            return member;
        }
        return super.lookupCalculatedMember(nameContext, id);
    }

    @Override
    public List<OlapMember> getAllCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        List<OlapMember> calcMembers = this.cubeCalcMemberManager.getAllCalculatedMembers(tupleFilter);
        calcMembers.addAll(super.getAllCalculatedMembers(tupleFilter));
        return calcMembers;
    }

    @Override
    public List<OlapUserMeasureMember> getUserMeasures(@Nullable OlapMemberFilter memberFilter) {
        List<OlapUserMeasureMember> measures = this.cubeCalcMemberManager.getUserMeasures(memberFilter);
        measures.addAll(super.getUserMeasures(memberFilter));
        return measures;
    }

    @Override
    public List<OlapMember> getVisibleCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        List<OlapMember> calcMembers = this.cubeCalcMemberManager.getVisibleCalculatedMembers(tupleFilter);
        calcMembers.addAll(super.getVisibleCalculatedMembers(tupleFilter));
        return calcMembers;
    }

    @Override
    public List<OlapMember> getInvisibleCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        List<OlapMember> calcMembers = this.cubeCalcMemberManager.getInvisibleCalculatedMembers(tupleFilter);
        calcMembers.addAll(super.getInvisibleCalculatedMembers(tupleFilter));
        return calcMembers;
    }

    @Override
    @Nullable
    public OlapUserMeasureMember lookupUserMeasure(OlapNameContext nameContext, OlapEntityIdentifier id) {
        OlapUserMeasureMember measure = this.cubeCalcMemberManager.lookupUserMeasure(nameContext, id);
        if (measure != null) {
            return measure;
        }
        return super.lookupUserMeasure(nameContext, id);
    }

    @Override
    public List<OlapUserMeasureMember> lookupUserMeasures(OlapMemberFilter filter) {
        ArrayList<OlapUserMeasureMember> measures_ = new ArrayList<OlapUserMeasureMember>();
        List<OlapUserMeasureMember> measuresC = this.cubeCalcMemberManager.lookupUserMeasures(filter);
        measures_.addAll(measuresC);
        List<OlapUserMeasureMember> measuresS = super.lookupUserMeasures(filter);
        measures_.addAll(measuresS);
        return measures_;
    }

    @Override
    protected boolean isSelectScope() {
        return true;
    }
}

