/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.cmember;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaCalculatedMemberManager
extends OlapCalculatedMemberManager {
    public OlapMember addIfNotContained(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions, OlapNameContext nameContext, OlapMember member) {
        if (member.isMeasure()) {
            throw new CdProgrammingException("internal error: cannot add a calculated *measure*");
        }
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        return this.doAddIfNotContained(errorLocation, nameContext, member);
    }

    public void deleteAll(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions) {
        this.doDeleteAll(o -> !schemaPermissions.isReadOnly());
    }

    public void delete(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions, @Nullable OlapMember member) {
        if (member != null && member.isMeasure()) {
            throw new CdProgrammingException("internal error: cannot delete a calculated *measure*");
        }
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        if (member == null) {
            return;
        }
        this.doDelete(member);
    }

    @Override
    protected boolean isSelectScope() {
        return false;
    }
}

