/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.cmember;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapSchemaCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public abstract class OlapCalculatedMemberManager
implements IOlapCalculatedMembers {
    private final Object LOCK = new Object();
    private final Map<OlapMember, Integer> lastPositionsInParent = new HashMap<OlapMember, Integer>();
    private final Map<OlapLevel, Integer> lastPositionsInLevel = new HashMap<OlapLevel, Integer>();
    private final List<OlapMember> visibleCalcMembers = new ArrayList<OlapMember>();
    private final List<OlapMember> invisibleCalcMembers = new ArrayList<OlapMember>();
    private final List<OlapUserMeasureMember> measures = new ArrayList<OlapUserMeasureMember>();

    @Nullable
    public String getCubeName() {
        return null;
    }

    private static <T extends OlapEntity> void setupCalcMemberRank(Map<T, Integer> ranks, OlapMember cmember, T anchor, int position) {
        cmember.setPositionInAnchor(position);
        ranks.put(anchor, position + 1);
    }

    @Nullable
    private static OlapMember checkFullPath(OlapNameContext nameContext, OlapEntityIdentifier identifier, OlapMember member) {
        OlapMember checked;
        int prevPartPos = identifier.getPartCount() - 2;
        if (prevPartPos < 0) {
            return member;
        }
        OlapEntityIdentifierPart prevPart = identifier.getPart(prevPartPos);
        if (prevPart.isIdentifying(nameContext, member.getLevel()) && (checked = OlapCalculatedMemberManager.checkFullPathFromLevel(nameContext, identifier, member, prevPartPos)) != null) {
            return checked;
        }
        if (prevPart.isIdentifying(nameContext, member.getHierarchy()) && (checked = OlapCalculatedMemberManager.checkFullPathFromHierarchy(nameContext, identifier, member, prevPartPos)) != null) {
            return checked;
        }
        if (prevPart.isIdentifying(nameContext, member.getDimension()) && (checked = OlapCalculatedMemberManager.checkFullPathFromDimension(identifier, member, prevPartPos)) != null) {
            return checked;
        }
        return OlapCalculatedMemberManager.checkFullPathFromParent(identifier, nameContext, member, prevPartPos + 1);
    }

    @Nullable
    private static OlapMember checkFullPathFromLevel(OlapNameContext nameContext, OlapEntityIdentifier identifier, OlapMember member, int pos) {
        int prevPartPos = pos - 1;
        if (prevPartPos < 0) {
            if (member.isMeasure()) {
                return member;
            }
            return null;
        }
        OlapEntityIdentifierPart prevPart = identifier.getPart(prevPartPos);
        if (prevPart.isIdentifying(nameContext, member.getHierarchy())) {
            return OlapCalculatedMemberManager.checkFullPathFromHierarchy(nameContext, identifier, member, prevPartPos);
        }
        if (prevPart.isIdentifying(nameContext, member.getDimension())) {
            return OlapCalculatedMemberManager.checkFullPathFromDimension(identifier, member, prevPartPos);
        }
        return null;
    }

    @Nullable
    private static OlapMember checkFullPathFromHierarchy(OlapNameContext nameContext, OlapEntityIdentifier identifier, OlapMember member, int pos) {
        int prevPartPos = pos - 1;
        if (prevPartPos < 0) {
            if (member.isMeasure()) {
                return member;
            }
            return member;
        }
        OlapEntityIdentifierPart prevPart = identifier.getPart(prevPartPos);
        if (prevPart.isIdentifying(nameContext, member.getDimension())) {
            return OlapCalculatedMemberManager.checkFullPathFromDimension(identifier, member, prevPartPos);
        }
        return null;
    }

    @Nullable
    private static OlapMember checkFullPathFromDimension(OlapEntityIdentifier identifier, OlapMember member, int pos) {
        int prevPartPos = pos - 1;
        if (prevPartPos < 0) {
            return member;
        }
        return null;
    }

    @Nullable
    private static OlapMember checkFullPathFromParent(OlapEntityIdentifier identifier, OlapNameContext nameContext, OlapMember member, int pos) {
        OlapEntityIdentifierPart prevPart;
        int prevPartPos = pos;
        OlapMember parent = member;
        OlapMember matchingParent = member;
        while (true) {
            parent = parent.getParent();
            prevPart = identifier.getPart(--prevPartPos);
            if (parent == null || prevPartPos < 0 || !prevPart.isIdentifying(nameContext, parent)) break;
            matchingParent = parent;
        }
        if (prevPartPos < 0) {
            return null;
        }
        prevPart = identifier.getPart(prevPartPos);
        if (prevPart.isIdentifying(nameContext, matchingParent.getLevel())) {
            return OlapCalculatedMemberManager.checkFullPathFromLevel(nameContext, identifier, member, prevPartPos);
        }
        if (prevPart.isIdentifying(nameContext, member.getHierarchy())) {
            return OlapCalculatedMemberManager.checkFullPathFromHierarchy(nameContext, identifier, member, prevPartPos);
        }
        if (prevPart.isIdentifying(nameContext, member.getDimension())) {
            return OlapCalculatedMemberManager.checkFullPathFromDimension(identifier, member, prevPartPos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.visibleCalcMembers.size() + this.invisibleCalcMembers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OlapMember doAddIfNotContained(@Nullable OlapErrorLocation errorLocation, OlapNameContext nameContext, OlapMember member) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.contains(nameContext, member)) {
                throw new OlapEvaluationException(errorLocation, OlapErrorCode.DUPLICATED_CALC_MEMBER, new Serializable[]{ONames.name4Log(member)});
            }
            this.setupRank(member);
            if (member.isVisible()) {
                this.visibleCalcMembers.add(member);
            } else {
                this.invisibleCalcMembers.add(member);
            }
            return member;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddUserMeasureIfNotContained(@Nullable OlapErrorLocation errorLocation, OlapNameContext nameContext, OlapUserMeasureMember measure) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.containsUserMeasure(nameContext, measure)) {
                throw new OlapEvaluationException(errorLocation, OlapErrorCode.DUPLICATED_MEASURE, new Serializable[]{measure.getName(nameContext)});
            }
            this.measures.add(measure);
            this.setupRank(measure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeleteAll(Predicate<?> authorizationLogic) {
        Object object = this.LOCK;
        synchronized (object) {
            if (authorizationLogic.test(null)) {
                this.visibleCalcMembers.clear();
                this.invisibleCalcMembers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeleteAllUserMeasures(Predicate<?> authorizationLogic) {
        Object object = this.LOCK;
        synchronized (object) {
            if (authorizationLogic.test(null)) {
                this.measures.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(@Nullable OlapMember member) {
        if (member == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            boolean vDeleted = this.visibleCalcMembers.remove(member);
            boolean iDeleted = this.invisibleCalcMembers.remove(member);
            if (vDeleted || iDeleted) {
                this.onDeleted(member);
            }
        }
    }

    protected void onDeleted(OlapMember member) {
        if (member instanceof OlapSchemaCalculatedMember) {
            ((OlapSchemaCalculatedMember)member).invalidateFormula();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeleteUserMeasure(@Nullable OlapUserMeasureMember member) {
        Object object = this.LOCK;
        synchronized (object) {
            this.measures.remove(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean contains(OlapNameContext nameContext, OlapMember member) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.hasVisibleCalculatedMember(nameContext, member) || this.hasInvisibleCalculatedMember(nameContext, member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsUserMeasure(OlapNameContext nameContext, OlapUserMeasureMember member) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.hasUserMeasure(nameContext, member);
        }
    }

    private boolean hasVisibleCalculatedMember(OlapNameContext nameContext, OlapMember member) {
        return OlapCalculatedMemberManager.hasCalculatedMember(this.visibleCalcMembers, nameContext, member);
    }

    private boolean hasInvisibleCalculatedMember(OlapNameContext nameContext, OlapMember member) {
        return OlapCalculatedMemberManager.hasCalculatedMember(this.invisibleCalcMembers, nameContext, member);
    }

    private boolean hasUserMeasure(OlapNameContext nameContext, OlapUserMeasureMember member) {
        for (OlapMeasureMember olapMeasureMember : this.measures) {
            OlapDimension dim2;
            OlapDimension dim1;
            if (!OlapCaseInsensitiveName.equals(member.getName(nameContext), olapMeasureMember.getName(nameContext)) || !(dim1 = member.getDimension()).equals(dim2 = olapMeasureMember.getDimension())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCalculatedMember(List<OlapMember> calcMembers, OlapNameContext nameContext, OlapMember member) {
        for (OlapMember cmember : calcMembers) {
            if (!OlapCaseInsensitiveName.equals(cmember.getName(nameContext), member.getName(nameContext))) continue;
            OlapMember cmemberParent = cmember.getParent();
            OlapMember memberParent = member.getParent();
            if (!(cmemberParent == null && memberParent == null ? cmember.getLevel().equals(member.getLevel()) : cmemberParent != null && memberParent != null && cmemberParent.equals(memberParent))) continue;
            return true;
        }
        return false;
    }

    private void setupRank(OlapMember member) {
        if (member.hasPositionInAnchor()) {
            return;
        }
        if (member.getParent() != null) {
            this.setupRankInParent(member);
        } else {
            this.setupRankInLevel(member);
        }
    }

    private void setupRankInParent(OlapMember cmember) {
        OlapMember parent = cmember.getParent();
        if (parent != null) {
            Integer lastPositionInParent = this.lastPositionsInParent.get(parent);
            if (lastPositionInParent != null) {
                OlapCalculatedMemberManager.setupCalcMemberRank(this.lastPositionsInParent, cmember, parent, lastPositionInParent);
            } else {
                int childrenCount = parent.getChildrenCount();
                OlapCalculatedMemberManager.setupCalcMemberRank(this.lastPositionsInParent, cmember, parent, childrenCount);
            }
        }
    }

    private void setupRankInLevel(OlapMember cmember) {
        OlapLevel level = cmember.getLevel();
        Integer lastPositionInLevel = this.lastPositionsInLevel.get(level);
        if (lastPositionInLevel != null) {
            OlapCalculatedMemberManager.setupCalcMemberRank(this.lastPositionsInLevel, cmember, level, lastPositionInLevel);
        } else {
            int memberCount = level.getMemberCount();
            OlapCalculatedMemberManager.setupCalcMemberRank(this.lastPositionsInLevel, cmember, level, memberCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OlapMember lookupCalculatedMember(OlapNameContext nameContext, OlapEntityIdentifier id) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapMember cmember = this.lookupVisibleCalculatedMember(nameContext, id);
            if (cmember == null) {
                cmember = this.lookupInvisibleCalculatedMember(nameContext, id);
            }
            return cmember;
        }
    }

    @Nullable
    private OlapMember lookupVisibleCalculatedMember(OlapNameContext nameContext, OlapEntityIdentifier id) {
        return this.lookupCalculatedMember(this.visibleCalcMembers, nameContext, id);
    }

    @Nullable
    private OlapMember lookupInvisibleCalculatedMember(OlapNameContext nameContext, OlapEntityIdentifier id) {
        return this.lookupCalculatedMember(this.invisibleCalcMembers, nameContext, id);
    }

    @Nullable
    private OlapMember lookupCalculatedMember(List<OlapMember> calcMembers, OlapNameContext nameContext, OlapEntityIdentifier id) {
        for (OlapMember cmember : calcMembers) {
            OlapMember xmember;
            if (!id.getLastPart().isIdentifying(nameContext, cmember) || (xmember = OlapCalculatedMemberManager.checkFullPath(nameContext, id, cmember)) == null) continue;
            return xmember;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapMember> getAllCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        Object object = this.LOCK;
        synchronized (object) {
            List<OlapMember> visible = this.getCalculatedMembers(this.visibleCalcMembers, tupleFilter);
            List<OlapMember> invisible = this.getCalculatedMembers(this.invisibleCalcMembers, tupleFilter);
            ArrayList<OlapMember> all = new ArrayList<OlapMember>();
            all.addAll(visible);
            all.addAll(invisible);
            return all;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OlapUserMeasureMember> getUserMeasures(@Nullable OlapMemberFilter memberFilter) {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<OlapUserMeasureMember> filtered = new ArrayList<OlapUserMeasureMember>();
            if (memberFilter == null) {
                filtered.addAll(this.measures);
            } else {
                for (OlapUserMeasureMember measure : this.measures) {
                    if (!memberFilter.isAccepting(measure)) continue;
                    filtered.add(measure);
                }
            }
            return filtered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OlapMember> getVisibleCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getCalculatedMembers(this.visibleCalcMembers, tupleFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OlapMember> getInvisibleCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.getCalculatedMembers(this.invisibleCalcMembers, tupleFilter);
        }
    }

    private List<OlapMember> getCalculatedMembers(List<OlapMember> calcMembers, @Nullable OlapMemberFilter tupleFilter) {
        ArrayList<OlapMember> filteredCalcMembers = new ArrayList<OlapMember>();
        if (tupleFilter == null) {
            filteredCalcMembers.addAll(calcMembers);
        } else {
            for (OlapMember cmember : calcMembers) {
                if (!tupleFilter.isAccepting(cmember)) continue;
                filteredCalcMembers.add(cmember);
            }
        }
        return filteredCalcMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupOtherLastPositions(OlapCalculatedMemberManager other) {
        Object object = this.LOCK;
        synchronized (object) {
            other.lastPositionsInLevel.putAll(this.lastPositionsInLevel);
            other.lastPositionsInParent.putAll(this.lastPositionsInParent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCategoryMembers() {
        if (this.isSelectScope()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (OlapMember member : this.visibleCalcMembers) {
                member.resetCategory();
            }
            for (OlapMember member : this.invisibleCalcMembers) {
                member.resetCategory();
            }
        }
    }

    protected abstract boolean isSelectScope();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public OlapUserMeasureMember lookupUserMeasure(OlapNameContext nameContext, OlapEntityIdentifier id) {
        OlapEntityIdentifierPart part;
        int partCount = id.getPartCount();
        if (partCount == 1) {
            part = id.getLastPart();
        } else {
            if (partCount != 2) return null;
            OlapEntityIdentifierPart first = id.getFirstPart();
            String firstAsName = first.asName();
            if (first.isKey() || firstAsName == null || !OlapCaseInsensitiveName.equals("measures", firstAsName)) return null;
            part = id.getLastPart();
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (OlapUserMeasureMember measure : this.measures) {
                if (!part.isIdentifying(nameContext, measure)) continue;
                return measure;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapUserMeasureMember> lookupUserMeasures(@Nullable OlapMemberFilter filter) {
        ArrayList<OlapUserMeasureMember> measures_ = new ArrayList<OlapUserMeasureMember>();
        Object object = this.LOCK;
        synchronized (object) {
            for (OlapUserMeasureMember measure : this.measures) {
                if (filter != null && !filter.isAccepting(measure)) continue;
                measures_.add(measure);
            }
        }
        return measures_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupUserMeasureCellProperties() {
        Object object = this.LOCK;
        synchronized (object) {
            for (OlapUserMeasureMember measure : this.measures) {
                measure.setupCellProperties();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAllCategoryCalculatedMembers(OlapHierarchy hierarchy) {
        Object object = this.LOCK;
        synchronized (object) {
            boolean hasDeleteSomething = false;
            ArrayList<OlapMember> toDelete = new ArrayList<OlapMember>();
            for (OlapMember member : this.visibleCalcMembers) {
                if (!member.getHierarchy().equals(hierarchy)) continue;
                toDelete.add(member);
            }
            if (this.visibleCalcMembers.removeAll(toDelete)) {
                hasDeleteSomething = true;
            }
            toDelete.clear();
            for (OlapMember member : this.invisibleCalcMembers) {
                if (!member.getHierarchy().equals(hierarchy)) continue;
                toDelete.add(member);
            }
            if (this.invisibleCalcMembers.removeAll(toDelete)) {
                hasDeleteSomething = true;
            }
            return hasDeleteSomething;
        }
    }
}

