/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class OlapScalarEntityFactory {
    public static OlapScalarEntity create(@Nullable Object value) {
        if (value == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return new OlapNumericEntity(integer.intValue());
        }
        if (value instanceof Long) {
            Long integer = (Long)value;
            return new OlapNumericEntity(integer);
        }
        if (value instanceof String) {
            String str = (String)value;
            return new OlapStringEntity(str);
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return new OlapDateEntity(date);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime date = (LocalDateTime)value;
            return new OlapDateTimeEntity(date);
        }
        if (value instanceof Short) {
            Short aFloat = (Short)value;
            return new OlapNumericEntity(aFloat.shortValue());
        }
        if (value instanceof Float) {
            Float aFloat = (Float)value;
            return new OlapNumericEntity(aFloat.floatValue());
        }
        if (value instanceof Double) {
            Double aDouble = (Double)value;
            return new OlapNumericEntity(aDouble);
        }
        if (value instanceof Boolean) {
            Boolean aBoolean = (Boolean)value;
            return OlapBooleanEntity.value(aBoolean);
        }
        if (value instanceof CdComparableArray) {
            CdComparableArray arr = (CdComparableArray)value;
            return new OlapStringEntity(arr.toString());
        }
        throw new CdProgrammingException("Unsupported scalar entity conversion [" + value.getClass().getName() + "]");
    }
}

