/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity;

import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import java.util.List;

public class OlapMeasureGroup
extends OlapNonScalarAbstractEntity {
    public static final String FRIENDLY_NAME = "MeasureGroup";
    private final OlapCube cube;
    private final String measureGroup;

    public OlapMeasureGroup(OlapCube cube, String measureGroup) {
        this.cube = cube;
        this.measureGroup = measureGroup;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.MEASURE_GROUP;
    }

    public String getName() {
        return this.measureGroup;
    }

    public OlapCube getCube() {
        return this.cube;
    }

    public List<OlapMeasureMember> getMeasures() {
        return this.cube.getMeasuresMembers(this.measureGroup);
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) {
        return "[" + this.cube.getName(nameContext) + "].[" + this.measureGroup + "]";
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    public String toString() {
        return "[" + ONames.name4Log(this.cube) + "].[" + this.measureGroup + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapMeasureGroup that = (OlapMeasureGroup)o;
        if (this.cube != null ? !this.cube.equals(that.cube) : that.cube != null) {
            return false;
        }
        return !(this.measureGroup != null ? !this.measureGroup.equals(that.measureGroup) : that.measureGroup != null);
    }

    @Override
    public int hashCode() {
        int result = this.cube != null ? this.cube.hashCode() : 0;
        result = 31 * result + (this.measureGroup != null ? this.measureGroup.hashCode() : 0);
        return result;
    }

    @Override
    public String toStringForDebugger() {
        return "[" + this.cube.getName(OlapNameContext.DEFAULT_VALUES) + "].[" + this.measureGroup + "]";
    }
}

