/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity;

import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;

public enum OlapEntityVarType {
    BOOLEAN("boolean"),
    CELL_MEASURE_VECTOR("cellMeasureVector"),
    CUBE("cube"),
    DATE("date"),
    DATE_TIME("date_time"),
    DIMENSION("dimension"),
    ERROR("error"),
    HIERARCHY("hierarchy"),
    LEVEL("level"),
    LIST("list"),
    MEASURE("measure"),
    MEASURE_GROUP("measure_group"),
    MEMBER("member"),
    MIN_MAX("min_max"),
    NUMERIC("numeric"),
    NULL("null"),
    SET("set"),
    STRING("string"),
    SUB_CUBE("sub_cube"),
    TUPLE("tuple"),
    UNKNOWN("unknown");

    private final OlapStringEntity typeNameS;

    private OlapEntityVarType(String typeName) {
        this.typeNameS = new OlapStringEntity(typeName.toLowerCase());
    }

    public static OlapEntityVarType fromInputType(OlapBuilderInputType inputType) {
        switch (inputType) {
            case DB_TYPE_UNSUPPORTED: 
            case DB_TYPE_UNKNOWN: {
                return UNKNOWN;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATE_TIME;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case DOUBLE: 
            case FLOAT: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return NUMERIC;
            }
            case STRING: 
            case UPPERCASE_STRING: {
                return STRING;
            }
            case JAVA_OBJECT: {
                return UNKNOWN;
            }
        }
        return UNKNOWN;
    }

    public OlapScalarEntity asScalarEntity() {
        return this.typeNameS;
    }
}

