/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity;

import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.common.formatter.ExcelPoiFormatter;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.pub.olap.IOlapEmpty;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapEmptyEntity
extends OlapAbstractScalarEntity
implements IOlapEmpty {
    public static final String FRIENDLY_NAME = "empty";
    public static final OlapEmptyEntity INSTANCE = new OlapEmptyEntity();
    private static final Object VALUE = "";
    public static int operatorIndex = OlapScalarOperators.createIndex(OlapEmptyEntity.class);

    private OlapEmptyEntity() {
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.NULL;
    }

    public static OlapScalarEntity asEmpty(boolean isEmpty) {
        return isEmpty ? INSTANCE : new OlapNumericEntity(1L);
    }

    @Override
    public boolean isMdxNull() {
        return true;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public CdXmlaSchemaType getXmlaType(@Nullable CdXmlaOptions options) {
        return CdXmlaSchemaType.DBTYPE_EMPTY;
    }

    @Override
    public String asXmlaString() {
        return this.asString();
    }

    @Override
    public String asString() {
        return "";
    }

    @Override
    public Object asValue() {
        return VALUE;
    }

    @Override
    public Class getUnderlyingJavaNativeValueType() {
        return VALUE.getClass();
    }

    @Override
    public boolean doIsConvertibleToJavaType(Class target) {
        return !target.isPrimitive();
    }

    @Nullable
    public Object doAsJavaNativeValue(Class expectedClazz) {
        return null;
    }

    @Override
    public OlapScalarEntity asInitialValueFor(OlapMember[] members, OlapMember measure, OlapAggregationType aggregationType) {
        switch (aggregationType) {
            case SUM: 
            case SUM_HIGH_PRECISION: 
            case MIN: 
            case MAX: 
            case AVG_LEAVES: 
            case OPEN_NO_EMPTY: 
            case CLOSE_NO_EMPTY: {
                return this;
            }
        }
        return super.asInitialValueFor(members, measure, aggregationType);
    }

    @Override
    public OlapScalarEntity aggregate(OlapMember[] members, OlapMember measure, OlapScalarEntity entity, OlapAggregationType aggregationType) {
        if (entity.isMdxNull()) {
            return entity;
        }
        return entity.asInitialValueFor(members, measure, aggregationType);
    }

    @Override
    public int getOperatorIndex() {
        return operatorIndex;
    }

    @Override
    public String javaFormat(GFCellPropertyEvalContext context, Locale locale, String pattern) {
        return null;
    }

    @Override
    public String excelFormat(GFCellPropertyEvalContext context, Locale locale, String format) {
        String formatted = ExcelPoiFormatter.formatNull(format);
        return formatted;
    }

    @Override
    @Nullable
    public Object toTidyTableValue() {
        return null;
    }

    @Override
    public OlapScalarEntityTidyType toTidyTableValueType() {
        return OlapScalarEntityTidyType.NULL;
    }

    @Override
    public OlapScalarEntity multiplyByZero() {
        return this;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public String toStringForDebugger() {
        return "NULL";
    }

    @Override
    public String toString() {
        return "EMPTY";
    }

    @Override
    public OlapScalarEntity asConstant() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

