/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.cube;

import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.cluster.shared.schema.S_BitSetTupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.select.OlapBaseSubSelectInstr;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectTupleFilter;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapSubSelectCube
extends OlapCube {
    private final OlapBaseSubSelectInstr instr;
    @Nullable
    private final OlapSubSelectTupleFilter subSelectDimensionFilter;
    @Nullable
    private final List<OlapSubCubeEntity> subCubes;
    private final OlapCube underlying;
    private final ConcurrentHashMap<String, S_TupleDimensionality> cache = new ConcurrentHashMap();

    public OlapSubSelectCube(OlapBaseSubSelectInstr instr, @Nullable OlapSubSelectTupleFilter subSelectDimensionFilter, @Nullable List<OlapSubCubeEntity> subCubes, OlapCube underlying) {
        super(underlying.getSchema(), OlapSubSelectCube.setupName(underlying), OlapSubSelectCube.setupDescription(underlying));
        this.instr = instr;
        this.subSelectDimensionFilter = subSelectDimensionFilter;
        this.subCubes = subCubes;
        this.underlying = underlying;
        this.addDimension(underlying.getMeasuresDimension());
    }

    public S_TupleDimensionality getTupleDimensionality() {
        return this.cache.computeIfAbsent("CACHE", key -> {
            S_TupleDimensionality dim = new S_BitSetTupleDimensionality();
            if (this.subCubes != null && !this.subCubes.isEmpty()) {
                dim = this.subCubes.stream().map(s -> s.asClusterCube(null).getTupleDimensionality()).reduce((acc, dim2) -> dim2.union((S_TupleDimensionality)acc)).get();
            }
            if (this.subSelectDimensionFilter != null) {
                return dim.union(this.subSelectDimensionFilter.getTupleDimensionality());
            }
            return dim;
        });
    }

    @Override
    @Nullable
    public OlapPerspective getPerspective() {
        return this.underlying.getPerspective();
    }

    private static String setupName(OlapCube underlying) {
        return "(sub-select) " + ONames.name4Log(underlying);
    }

    private static String setupDescription(OlapCube underlying) {
        return "(sub-select) " + underlying.getDescription();
    }

    public boolean isVisual() {
        return !this.instr.isNonVisual();
    }

    @Override
    public boolean isFactless() {
        return this.underlying.isFactless();
    }

    @Override
    public List<IOlapBuilderBaseFactsDef> getCubeFacts() {
        return this.underlying.getCubeFacts();
    }

    @Override
    public OlapCube getUnderlying() {
        return this.underlying;
    }

    @Override
    public OlapRegularCube getRegularCube() {
        return this.underlying.getRegularCube();
    }

    @Override
    public OlapRegularCube getNonEmptyCube() {
        return this.underlying.getNonEmptyCube();
    }

    @Override
    @Nullable
    public OlapSubSelectTupleFilter getSubSelectTupleFilter() {
        return this.subSelectDimensionFilter;
    }

    @Override
    public OlapCubeCalculatedMemberManager getCalcMemberManager() {
        return this.underlying.getCalcMemberManager();
    }

    @Override
    public List<OlapMember> getCalcMembers() {
        return this.underlying.getCalcMembers();
    }

    @Override
    public OlapFactMeasureGroupBaseManager getFactManager(String measureGroupName) {
        return this.underlying.getFactManager(measureGroupName);
    }

    @Override
    public OlapFactCubeManager getCubeFactManager() {
        return this.underlying.getCubeFactManager();
    }

    @Override
    public OlapFactCubeManager getNullableCubeFactManager() {
        return this.underlying.getNullableCubeFactManager();
    }

    @Override
    public Date getLastDataUpdatedTime() {
        return this.underlying.getLastDataUpdatedTime();
    }

    public boolean isAcceptingMember(OlapMember member) {
        return this.subSelectDimensionFilter == null || this.subSelectDimensionFilter.isAccepting(member);
    }

    @Nullable
    public List<List<OlapTuple>> getDefinition() {
        return this.subSelectDimensionFilter != null ? this.subSelectDimensionFilter.getDefinition() : null;
    }

    @Nullable
    public OlapTupleSet<OlapTuple> getAxisForMdxFunction(int number) {
        return this.subSelectDimensionFilter != null ? this.subSelectDimensionFilter.getAxisForMdxFunction(number) : null;
    }

    @Nullable
    public List<OlapSubCubeEntity> getSubCubes() {
        return this.subCubes;
    }

    @Override
    public OlapNonScalarEntity lookupEntityByMdxIdentifier(OlapNameContext nameContext, IOlapDimensionsPermission permissions, @Nullable List<OlapHierarchy> requestHierarchies, @Nullable List<OlapHierarchy> sessionHierarchies, OlapEntityIdentifier id) {
        OlapMember member;
        OlapNonScalarEntity entity = super.lookupEntityByMdxIdentifier(nameContext, permissions, requestHierarchies, sessionHierarchies, id);
        if (this.subSelectDimensionFilter != null && entity instanceof OlapMember && !(member = (OlapMember)entity).isMeasure() && !this.subSelectDimensionFilter.isAccepting(member)) {
            return OlapMemberFactory.createOlapFilteredOutMember(member);
        }
        return entity;
    }

    public void touchCategories() {
        List<List<OlapTuple>> axes = this.getDefinition();
        if (axes == null) {
            return;
        }
        for (List<OlapTuple> axis : axes) {
            for (OlapTuple tuple : axis) {
                IOlapMembers.touchCategories(tuple);
            }
        }
    }
}

