/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.cube;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectTupleFilter;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.stats.OlapDimensionStats;
import crazydev.iccube.olap.schema.stats.OlapFactsStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapRegularCube
extends OlapCube {
    private final List<IOlapBuilderBaseFactsDef> cubeFacts;
    private final OlapCubeCalculatedMemberManager calcMemberManager;
    private final OlapFactCubeManager cubeFactManager;
    private Date lastDataUpdatedTime = new Date();

    public OlapRegularCube(OlapBuilderContext context, IOlapFactListFactory factColumnListFactory, S_FactBitmapContainerFactory factsBitmapContainerFactory, OlapSchema schema, String name, @Nullable String description, List<IOlapBuilderBaseFactsDef> cubeFacts, OlapMeasuresDimension measureDimension) {
        super(schema, name, description);
        this.cubeFacts = cubeFacts;
        this.calcMemberManager = new OlapCubeCalculatedMemberManager(this.getNameX(), schema.getCalcMemberManager());
        this.addDimension(measureDimension);
        measureDimension.setupCube(this);
        this.cubeFactManager = new OlapFactCubeManager(context, factColumnListFactory, factsBitmapContainerFactory, this);
    }

    @Override
    public void resetForSchema(OlapSchema schema, int nextDimensionIndexOffset, int nextHierarchyIndexOffset, int nextPartitionIndexOffset) {
        super.resetForSchema(schema, nextDimensionIndexOffset, nextHierarchyIndexOffset, nextPartitionIndexOffset);
        this.cubeFactManager.resetForSchema(schema, nextDimensionIndexOffset, nextHierarchyIndexOffset, nextPartitionIndexOffset);
    }

    @Override
    public boolean isFactless() {
        return false;
    }

    public boolean hasMeasureGroup(String measureGroupName) {
        return this.cubeFactManager.getFactManager(measureGroupName) != null;
    }

    @Override
    public List<IOlapBuilderBaseFactsDef> getCubeFacts() {
        return this.cubeFacts;
    }

    public List<OlapFactMeasureGroupBaseManager> getMeasureGroups(Set<IOlapBuilderBaseFactsDef> factsDefs) {
        return this.cubeFactManager.getMeasureGroups(factsDefs);
    }

    @Override
    public OlapCubeCalculatedMemberManager getCalcMemberManager() {
        return this.calcMemberManager;
    }

    @Override
    public List<OlapMember> getCalcMembers() {
        return this.calcMemberManager.getVisibleCalculatedMembers(null);
    }

    @Override
    public OlapCube getUnderlying() {
        return this;
    }

    @Override
    public OlapRegularCube getRegularCube() {
        return this;
    }

    @Override
    public OlapRegularCube getNonEmptyCube() {
        return this;
    }

    @Override
    @Nullable
    public OlapSubSelectTupleFilter getSubSelectTupleFilter() {
        return null;
    }

    @Override
    public OlapFactMeasureGroupBaseManager getFactManager(String measureGroupName) {
        OlapFactMeasureGroupBaseManager mgr = this.cubeFactManager.getFactManager(measureGroupName);
        if (mgr == null) {
            throw new CdShouldNotBeHereProgrammingException(measureGroupName);
        }
        return mgr;
    }

    @Override
    public OlapFactCubeManager getCubeFactManager() {
        return this.cubeFactManager;
    }

    @Override
    public OlapFactCubeManager getNullableCubeFactManager() {
        return this.cubeFactManager;
    }

    @Override
    public Date getLastDataUpdatedTime() {
        return this.lastDataUpdatedTime;
    }

    public void setLastDataUpdatedTime(Date lastUpdate) {
        this.lastDataUpdatedTime = lastUpdate;
    }

    public void deleteCategoryHierarchyBitmaps(OlapHierarchy hierarchy) {
        this.cubeFactManager.deleteCategoryHierarchyBitmaps(hierarchy);
    }

    public List<OlapSchemaPartitionInformation> listPartitions(List<OlapSchemaPartitionInformation> partitions) {
        return this.cubeFactManager.listPartitions(partitions, this.getNameX());
    }

    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info) {
        OlapLoggers.GENERAL.warn((Object)("[###] cube : " + this.getNameX()));
        this.cubeFactManager.getInformationForPerformanceTests(info);
    }

    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies) throws IOException {
        OlapLoggers.GENERAL.info((Object)("[DumpSchemaIndex] cube : " + this.getNameX()));
        this.cubeFactManager.dumpIndex(out, hierarchies);
    }

    public List<OlapFactsStats> createStats(OlapStatsContext context, Map<String, OlapDimensionStats> dimensions) {
        return this.cubeFactManager.createStats(context, dimensions);
    }

    public List<OlapFactsStats> createIncrLoadStats(OlapStatsContext context) {
        return this.cubeFactManager.createIncrLoadStats(context);
    }

    public boolean adoptPartitions(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, OlapRegularCube loadedCube) {
        Set<IOlapBuilderBaseFactsDef> factsDefs;
        boolean adopted;
        Logger schemaLogger = context.getSchemaLogger();
        if (schemaLogger.isInfoEnabled()) {
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " cube update partitions [" + this.getNameX() + "]"));
        }
        if (adopted = this.cubeFactManager.adoptPartitions(context, bContext, loadedCube.cubeFactManager, factsDefs = context.getRequestedFacts(loadedCube))) {
            this.lastDataUpdatedTime = new Date();
        }
        return adopted;
    }

    public boolean unloadPartitions(OlapBuilderUnloadPartitionsContext context, OlapFactMeasureGroupBaseManager measureGroup, List<String> partitionKeys) {
        boolean unloaded = this.cubeFactManager.unloadPartitions(context, measureGroup, partitionKeys);
        if (unloaded) {
            this.lastDataUpdatedTime = new Date();
        }
        return unloaded;
    }

    @Nullable
    public OlapFactMeasureGroupBaseManager lookupMeasureGroup(S_MeasureGroupRef measureGroupRef) {
        OlapFactMeasureGroupBaseManager measureGroup = this.cubeFactManager.lookupMeasureGroup(measureGroupRef);
        return measureGroup;
    }
}

