/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.cube;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectTupleFilter;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapFactlessCube
extends OlapCube {
    private final OlapErrorLocation locationRange;
    private final OlapCubeCalculatedMemberManager calcMemberManager;

    public OlapFactlessCube(OlapErrorLocation locationRange, String prefix, OlapSchema schema) {
        super(schema, prefix + "factless-cube", "A factless cube when no cube is defined in the evaluation context.");
        this.calcMemberManager = new OlapCubeCalculatedMemberManager(this.getNameX(), schema.getCalcMemberManager());
        this.locationRange = locationRange;
    }

    @Override
    public boolean isFactless() {
        return true;
    }

    @Override
    public List<IOlapBuilderBaseFactsDef> getCubeFacts() {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public OlapCubeCalculatedMemberManager getCalcMemberManager() {
        return this.calcMemberManager;
    }

    @Override
    public List<OlapMember> getCalcMembers() {
        return this.calcMemberManager.getVisibleCalculatedMembers(null);
    }

    @Override
    public OlapCube getUnderlying() {
        return this;
    }

    @Override
    public OlapRegularCube getRegularCube() {
        throw new RuntimeException("internal error: inconsistent regular cube usage (factless)");
    }

    @Override
    public OlapRegularCube getNonEmptyCube() {
        throw new RuntimeException("internal error: inconsistent non-empty cube usage (factless)");
    }

    @Override
    @Nullable
    public OlapSubSelectTupleFilter getSubSelectTupleFilter() {
        return null;
    }

    @Override
    public OlapFactMeasureGroupBaseManager getFactManager(String measureGroupName) {
        throw new OlapEvaluationException(this.locationRange, OlapErrorCode.FACTLESS_CUBE_EVAL_TUPLE, new Serializable[0]);
    }

    @Override
    public OlapFactCubeManager getCubeFactManager() {
        throw new OlapEvaluationException(this.locationRange, OlapErrorCode.FACTLESS_CUBE_EVAL_TUPLE, new Serializable[0]);
    }

    @Override
    @Nullable
    public OlapFactCubeManager getNullableCubeFactManager() {
        return null;
    }
}

