/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.schemas;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfoError;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class OlapSchemaFactoryInfoParser {
    private static final AtomicReference<SAXParserFactory> parserFactory = new AtomicReference();
    private static final ConcurrentLinkedQueue<SAXParser> availableParsers = new ConcurrentLinkedQueue();

    public static OlapSchemaFactoryInfo parse(final File file) throws OlapSchemaFactoryInfoError {
        SAXParser parser = OlapSchemaFactoryInfoParser.getOrCreateSAXParser();
        try {
            try {
                parser.parse(file, new DefaultHandler(){
                    private int revNumber = -1;
                    private StringBuilder schemaName;
                    private boolean inSchemaName;
                    private StringBuilder loadOnStartup;
                    private boolean inLoadOnStartup;

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (qName.equals("schemaFactory")) {
                            int revIdx = attributes.getIndex("revisionNumber");
                            String revValue = revIdx == -1 ? "-1" : attributes.getValue(revIdx);
                            this.revNumber = Integer.valueOf(revValue);
                        } else {
                            if (qName.equals("schemaDefinition")) {
                                int nameIdx = attributes.getIndex("name");
                                if (nameIdx == -1) {
                                    throw new SAXException("missing name attribute from <schemaDefinition>");
                                }
                                String nameValue = attributes.getValue(nameIdx);
                                int groupIdx = attributes.getIndex("group");
                                String groupValue = groupIdx != -1 ? attributes.getValue(groupIdx) : null;
                                int descriptionIdx = attributes.getIndex("description");
                                String descriptionValue = descriptionIdx != -1 ? attributes.getValue(descriptionIdx) : null;
                                int loadIdx = attributes.getIndex("loadOnStartup");
                                String loadValue = loadIdx != -1 ? attributes.getValue(loadIdx) : "false";
                                if (CdStringUtils.isNullOrBlank((String)nameValue)) {
                                    throw new InvalidFactory();
                                }
                                boolean loadOnStartup = Boolean.valueOf(loadValue);
                                OlapSchemaFactoryInfo info = new OlapSchemaFactoryInfo(file, this.revNumber, nameValue, groupValue, descriptionValue, loadOnStartup);
                                throw new StopParser(info);
                            }
                            if (qName.equals("schemaName")) {
                                this.inSchemaName = true;
                                this.schemaName = new StringBuilder();
                            } else if (qName.equals("loadOnStartup")) {
                                this.inLoadOnStartup = true;
                                this.loadOnStartup = new StringBuilder();
                            }
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.inSchemaName) {
                            this.schemaName.append(ch, start, length);
                        } else if (this.inLoadOnStartup) {
                            this.loadOnStartup.append(ch, start, length);
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (qName.equals("schemaName")) {
                            this.inSchemaName = false;
                        } else if (qName.equals("loadOnStartup")) {
                            this.inLoadOnStartup = false;
                        } else if (qName.equals("cubeBasedSchemaFactory")) {
                            String nameValue = this.schemaName.toString();
                            String loadValue = this.loadOnStartup.toString();
                            OlapSchemaFactoryInfo info = new OlapSchemaFactoryInfo(file, this.revNumber, nameValue, null, null, Boolean.valueOf(loadValue));
                            throw new StopParser(info);
                        }
                    }
                });
                throw new OlapSchemaFactoryInfoError(null);
            }
            catch (StopParser expected) {
                OlapSchemaFactoryInfo olapSchemaFactoryInfo = expected.info;
                return olapSchemaFactoryInfo;
            }
            catch (InvalidFactory | IOException | SAXException ex) {
                throw new OlapSchemaFactoryInfoError(ex);
            }
        }
        finally {
            availableParsers.offer(parser);
        }
    }

    private static SAXParser getOrCreateSAXParser() {
        SAXParser availableParser = availableParsers.poll();
        if (availableParser != null) {
            return availableParser;
        }
        try {
            SAXParserFactory factory = OlapSchemaFactoryInfoParser.setupSAXParserFactory();
            return factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("internal error : SAX parser creation error");
        }
        catch (SAXException ex) {
            throw new RuntimeException("internal error : SAX parser creation error");
        }
    }

    private static SAXParserFactory setupSAXParserFactory() {
        SAXParserFactory factory = parserFactory.get();
        if (factory != null) {
            return factory;
        }
        return OlapSchemaFactoryInfoParser.createSAXParserFactory();
    }

    private static SAXParserFactory createSAXParserFactory() {
        if (parserFactory.compareAndSet(null, (SAXParserFactory)new SAXParserFactoryImpl())) {
            return parserFactory.get();
        }
        return parserFactory.get();
    }

    private static class StopParser
    extends RuntimeException {
        private static final long serialVersionUID = 8669195645668071750L;
        private final OlapSchemaFactoryInfo info;

        public StopParser(OlapSchemaFactoryInfo info) {
            this.info = info;
        }
    }

    private static class InvalidFactory
    extends RuntimeException {
        private static final long serialVersionUID = -755139391642602077L;
    }
}

