/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.schemas;

import java.io.File;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaFactoryInfo {
    private final File file;
    private final int revNumber;
    private final String name;
    @Nullable
    private final String group;
    @Nullable
    private final String description;
    private final boolean loadOnStartup;
    @Nullable
    private volatile String defContent;
    private volatile long lastModified;

    public OlapSchemaFactoryInfo(File file, int revNumber, String name, @Nullable String group, @Nullable String description, boolean loadOnStartup) {
        this.file = file;
        this.revNumber = revNumber;
        this.name = name;
        this.group = group;
        this.description = description;
        this.loadOnStartup = loadOnStartup;
        this.defContent = null;
        this.lastModified = -1L;
    }

    public File getFile() {
        return this.file;
    }

    public int getRevNumber() {
        return this.revNumber;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public void refreshLastModifiedCache() {
        this.lastModified = this.file.lastModified();
    }

    public long lastModifiedCache() {
        return this.lastModified != -1L ? this.lastModified : this.file.lastModified();
    }

    public String toString() {
        return this.name;
    }

    public void setContentDef(String defContent) {
        this.defContent = defContent;
    }

    @Nullable
    public String getDefContent() {
        return this.defContent;
    }
}

