/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.schemas;

import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.olap.component.schemas.IOlapSchemaFactoryFileAction;
import crazydev.iccube.olap.component.schemas.IOlapSchemaFactoryInfoAction;
import crazydev.iccube.olap.component.schemas.OlapEngineAbstractSchemaDefFactoryHelper;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSnapshotFile;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapEngineInMemorySchemaDefFactoryHelper
extends OlapEngineAbstractSchemaDefFactoryHelper {
    private final IOlapBuilderSchemaDefFactory factory;

    public OlapEngineInMemorySchemaDefFactoryHelper(IOlapBuilderSchemaDefFactory factory) {
        this.factory = factory;
        if (factory.getXmlFile() == null) {
            throw new RuntimeException("internal error : missing schema definition file");
        }
    }

    @Override
    public String getSchemaName(File schemaFactoryFile) {
        return this.factory.getSchemaName();
    }

    @Override
    @Nullable
    public OlapSchemaFactoryInfo getFactoryInfo(File schemaFactoryFile) {
        File file = this.ensureFactoryFileConsistency(schemaFactoryFile);
        OlapSchemaFactoryInfo info = new OlapSchemaFactoryInfo(file, -1, this.factory.getSchemaName(), this.factory.getSchemaGroup(), this.factory.getSchemaDescription(), this.factory.isLoadOnStartup());
        return info;
    }

    @Override
    @Nullable
    public File getFactoryFile(String schema) {
        if (!schema.equals(this.factory.getSchemaName())) {
            throw new RuntimeException("internal error : inconsistent schema name [" + schema + "] [" + this.factory.getSchemaName() + "]");
        }
        File file = this.factory.getXmlFile();
        if (file == null) {
            throw new RuntimeException("internal error : missing schema definition file");
        }
        return file;
    }

    @Override
    public void foreachSchemaFactoryFile(@Nullable FileFilter filter, IOlapSchemaFactoryFileAction action) {
        File file = this.factory.getXmlFile();
        if (file == null) {
            throw new RuntimeException("internal error : missing schema definition file");
        }
        action.onSchemaFactoryFile(file);
    }

    @Override
    public void foreachSchemaFactoryInfo(IOlapSchemaFactoryInfoAction action) {
        File file = this.factory.getXmlFile();
        if (file == null) {
            throw new RuntimeException("internal error : missing schema definition file");
        }
        OlapSchemaFactoryInfo info = new OlapSchemaFactoryInfo(file, -1, this.factory.getSchemaName(), this.factory.getSchemaGroup(), this.factory.getSchemaDescription(), this.factory.isLoadOnStartup());
        action.onSchemaFactoryInfo(info);
    }

    @Override
    public List<String> getNonExistingSchemaFactories(List<String> schemas) {
        ArrayList<String> nonExistings = new ArrayList<String>();
        for (String schema : schemas) {
            if (this.factory.getSchemaName().equals(schema)) continue;
            nonExistings.add(schema);
        }
        return nonExistings;
    }

    @Override
    public List<File> retrieveRelativeSchemaFactoryFiles(int maxCount) {
        throw new RuntimeException("internal error : retrieveRelativeSchemaFactoryFiles inconsistent usage ");
    }

    @Override
    public IOlapBuilderSchemaDefFactory unmarshallXmlFactory(File schemaFactoryFile) throws OlapBuilderErrorException {
        this.ensureFactoryFileConsistency(schemaFactoryFile);
        return this.factory;
    }

    @Override
    public void writeSchemaDefFactoryFileContent(String savedBy, File file, InputStream in, String operation) throws IOException {
        throw new RuntimeException("internal error : writeSchemaDefFactoryFileContent inconsistent usage ");
    }

    @Override
    public boolean deleteSchemaDefFactoryFile(File file) {
        throw new RuntimeException("internal error : deleteSchemaDefFactoryFile inconsistent usage ");
    }

    @Override
    public File getOfflineSnapshotForWrite(@Nullable String specifiedSnapshot, OlapSchema schema) {
        throw new RuntimeException("internal error : getOfflineSnapshotForWrite inconsistent usage ");
    }

    @Override
    public boolean deleteOfflineSnapshot(File file) {
        throw new RuntimeException("internal error : deleteOfflineSnapshot inconsistent usage ");
    }

    @Override
    public List<String> getOfflineSnapshotNames(String schemaFactoryFileName) {
        throw new RuntimeException("internal error : getOfflineSnapshotNames inconsistent usage ");
    }

    @Override
    public List<String> getAllOfflineSnapshotNames() {
        throw new RuntimeException("internal error : getAllOfflineSnapshotNames inconsistent usage ");
    }

    @Override
    public Map<File, List<OlapSnapshotFile>> getAllOfflineSnapshots() {
        throw new RuntimeException("internal error : getAllOfflineSnapshots inconsistent usage ");
    }

    @Override
    @Nullable
    public OlapSnapshotFile getOfflineSnapshot(String name) {
        throw new RuntimeException("internal error : getOfflineSnapshot inconsistent usage ");
    }

    private File ensureFactoryFileConsistency(File schemaFactoryFile) {
        File file = this.factory.getXmlFile();
        if (file != null) {
            if (!file.equals(schemaFactoryFile)) {
                throw new RuntimeException("internal error : schema definition file inconsistency [" + file.getAbsolutePath() + "] [" + schemaFactoryFile.getAbsolutePath() + "]");
            }
            return file;
        }
        throw new RuntimeException("internal error : missing schema definition file");
    }
}

