/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.schemas;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.fs.revision.CdVFileRevActionOperation;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineHelper;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.component.schemas.IOlapSchemaFactoryFileAction;
import crazydev.iccube.olap.component.schemas.IOlapSchemaFactoryInfoAction;
import crazydev.iccube.olap.component.schemas.OlapEngineAbstractSchemaDefFactoryHelper;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfoError;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfoParser;
import crazydev.iccube.olap.component.schemas.OlapSnapshotFile;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import jakarta.xml.bind.DataBindingException;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class OlapEngineFileSystemSchemaDefFactoryHelper
extends OlapEngineAbstractSchemaDefFactoryHelper {
    private final CdVFileRevHelperConf fileVersionManager;
    private final CdVFileSystem vfs;
    private final File cubesDirectory;
    private final File offlineDirectory;
    private final OlapBuilderMetaInformationRepository builderMetaInformationRepository;

    public OlapEngineFileSystemSchemaDefFactoryHelper(CdVFileSystem vfs, CdVFileRevHelperConf fileVersionManager, File cubesDirectory, File offlineDirectory, OlapBuilderMetaInformationRepository builderMetaInformationRepository) {
        this.fileVersionManager = fileVersionManager;
        this.vfs = vfs;
        this.cubesDirectory = cubesDirectory;
        this.offlineDirectory = offlineDirectory;
        this.builderMetaInformationRepository = builderMetaInformationRepository;
    }

    private static void addDirectoryName(Map<File, List<OlapSnapshotFile>> names, File factory, File directoryName) {
        List<OlapSnapshotFile> directories = names.get(factory);
        if (directories == null) {
            directories = new ArrayList<OlapSnapshotFile>();
            names.put(factory, directories);
        }
        directories.add(new OlapSnapshotFile(directoryName.getAbsolutePath(), directoryName.getName()));
    }

    @Override
    @Nullable
    public File getFactoryFile(String schema) {
        File file = this.getFactoryFileFromSchemaName(schema);
        if (file != null) {
            return file;
        }
        AtomicInteger count = new AtomicInteger(0);
        File[] myFile = new File[1];
        this.foreachSchemaFactoryFile(pathName -> {
            String schema_;
            if (count.incrementAndGet() % 10000 == 0) {
                OlapLoggers.GENERAL.debug((Object)("(factory-file) factory files : " + count.get()));
            }
            return (schema_ = this.getSchemaName(pathName)) != null && schema.equals(schema_);
        }, factoryFile -> {
            if (myFile[0] != null) {
                throw new RuntimeException("internal error : multiple schema definition file [" + String.valueOf(myFile[0]) + "] [" + String.valueOf(factoryFile) + "]");
            }
            myFile[0] = factoryFile;
            return false;
        });
        return myFile[0];
    }

    @Nullable
    private File getFactoryFileFromSchemaName(String schema) {
        String fileName = CdVFileSystem.toFileName((String)schema) + ".icc-schema";
        File file = new File(this.cubesDirectory, fileName);
        OlapSchemaFactoryInfo info = this.getFactoryInfo(file);
        if (info != null && schema.equals(info.getName())) {
            return file;
        }
        return null;
    }

    @Override
    public void foreachSchemaFactoryFile(@Nullable FileFilter filter, IOlapSchemaFactoryFileAction action) {
        if (!this.cubesDirectory.exists()) {
            return;
        }
        try {
            this.vfs.forEachFileRecursive(this.cubesDirectory, path -> {
                File file = path.toFile();
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return !CdVFileSystem.isRevFolder((File)file);
                }
                String name = file.getName();
                boolean accept = name.endsWith(".icc-schema");
                if (filter != null) {
                    return accept && filter.accept(file);
                }
                return accept;
            }, vPath -> {
                if (!Files.isDirectory(vPath.path, new LinkOption[0])) {
                    action.onSchemaFactoryFile(vPath.path.toFile());
                }
            });
        }
        catch (IOException ex) {
            LOGGER.warn((Object)"error while retrieving schema factory files", (Throwable)ex);
        }
    }

    @Override
    public void foreachSchemaFactoryInfo(IOlapSchemaFactoryInfoAction action) {
        this.foreachSchemaFactoryFile(null, file -> {
            try {
                OlapSchemaFactoryInfo info = OlapSchemaFactoryInfoParser.parse(file);
                return action.onSchemaFactoryInfo(info);
            }
            catch (OlapSchemaFactoryInfoError olapSchemaFactoryInfoError) {
                return true;
            }
        });
    }

    @Override
    public List<String> getNonExistingSchemaFactories(List<String> schemas) {
        ArrayList<String> nonExistings = new ArrayList<String>();
        for (String schema : schemas) {
            if (this.getFactoryFileFromSchemaName(schema) != null) continue;
            nonExistings.add(schema);
        }
        if (!nonExistings.isEmpty()) {
            this.foreachSchemaFactoryInfo(info -> {
                nonExistings.remove(info.getName());
                return !nonExistings.isEmpty();
            });
        }
        return nonExistings;
    }

    @Override
    public List<File> retrieveRelativeSchemaFactoryFiles(int maxCount) {
        ArrayList<File> relatives = new ArrayList<File>();
        this.foreachSchemaFactoryFile(null, file -> {
            relatives.add(CdVFileSystem.toRelativePath((File)this.cubesDirectory, (File)file));
            return relatives.size() < maxCount;
        });
        return relatives;
    }

    @Nullable
    private File retrieveSchemaFactoryFileForSnapshot(String snapshot) {
        File[] schemaFactoryFiles = new File[1];
        this.foreachSchemaFactoryFile(pathname -> snapshot.startsWith(pathname.getName()), file -> {
            schemaFactoryFiles[0] = file;
            return true;
        });
        return schemaFactoryFiles[0];
    }

    @Override
    public IOlapBuilderSchemaDefFactory unmarshallXmlFactory(File schemaFactoryFile) throws OlapBuilderErrorException {
        try {
            Class[] classes = this.builderMetaInformationRepository.getPersistentClasses();
            return (IOlapBuilderSchemaDefFactory)CdXmlUtils.unmarshall((String)"UTF-8", (File)schemaFactoryFile, (Class[])classes);
        }
        catch (DataBindingException | JAXBException | IOException ex) {
            OlapLoggers.SCHEMA.error((Object)("Failed to unmarshall schema def. factory [" + schemaFactoryFile.getAbsolutePath() + "]"), ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.XML_ERROR, new Serializable[]{ex.getMessage(), schemaFactoryFile.getAbsolutePath()});
        }
    }

    @Override
    public void writeSchemaDefFactoryFileContent(String savedBy, File file, InputStream in, String operation) throws IOException {
        CdVFileRevActionOperation action = new CdVFileRevActionOperation(savedBy, operation);
        this.vfs.saveOrUpdateWithRevision(this.fileVersionManager, file, in, (CdVFileRevAction)action);
    }

    @Override
    public boolean deleteSchemaDefFactoryFile(File file) {
        return file.delete();
    }

    @Override
    public boolean deleteOfflineSnapshot(File offlineSnapshot) {
        File snapshot = new File(this.offlineDirectory, offlineSnapshot.getName());
        if (snapshot.exists()) {
            if (snapshot.isFile()) {
                return snapshot.delete();
            }
            return CdVFileSystemUtils.deleteQuietly((File)snapshot);
        }
        return true;
    }

    @Override
    @Nullable
    public OlapSnapshotFile getOfflineSnapshot(String name) {
        OlapFileSystem fs = OlapFileSystem.createFileSystem(this.vfs, this.offlineDirectory);
        OlapFile file = fs.create(name);
        if (file.exists()) {
            File factory = this.retrieveSchemaFactoryFileForSnapshot(file.getName());
            return new OlapSnapshotFile(factory, file.__getUnderlyingAbsolutePath(), file.getName());
        }
        return null;
    }

    @Override
    public File getOfflineSnapshotForWrite(@Nullable String specifiedSnapshot, OlapSchema schema) {
        if (specifiedSnapshot != null) {
            return new File(this.offlineDirectory, specifiedSnapshot);
        }
        return OlapBuilderOfflineHelper.createNameForWrite(this.offlineDirectory, schema);
    }

    @Override
    public List<String> getOfflineSnapshotNames(String schemaFactoryFileName) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        if (schemaFactoryFileName == null) {
            return names;
        }
        List<File> snapshots = this.listOfflineSnapshots();
        String prefix = new File(schemaFactoryFileName).getName() + ".";
        for (File snapshot : snapshots) {
            String snapshotName = snapshot.getName();
            if (!snapshotName.startsWith(prefix)) continue;
            names.add(snapshotName);
        }
        return names;
    }

    @Override
    public List<String> getAllOfflineSnapshotNames() throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        List<File> snapshots = this.listOfflineSnapshots();
        for (File snapshot : snapshots) {
            String snapshotName = snapshot.getName();
            names.add(snapshotName);
        }
        return names;
    }

    @Override
    public Map<File, List<OlapSnapshotFile>> getAllOfflineSnapshots() throws IOException {
        HashMap<File, List<OlapSnapshotFile>> names = new HashMap<File, List<OlapSnapshotFile>>();
        List<File> snapshots = this.listOfflineSnapshots();
        if (snapshots.isEmpty()) {
            return names;
        }
        Map<String, File> factoriesByNames = this.retrieveSchemaFactoryFilesForSnapshots();
        for (File snapshot : snapshots) {
            String snapshotSchemaFactoryName = OlapBuilderOfflineHelper.schemaFactoryName(snapshot);
            File factory = factoriesByNames.get(snapshotSchemaFactoryName);
            File snapshotFactory = Objects.requireNonNullElseGet(factory, () -> new File(this.cubesDirectory, snapshotSchemaFactoryName));
            OlapEngineFileSystemSchemaDefFactoryHelper.addDirectoryName(names, snapshotFactory, snapshot);
        }
        return names;
    }

    private List<File> listOfflineSnapshots() throws IOException {
        ArrayList<File> snapshots = new ArrayList<File>();
        this.vfs.forEachFile(this.offlineDirectory, f -> true, vPath -> {
            File file = vPath.path.toFile();
            if (!file.isDirectory() && file.getName().toLowerCase().endsWith(".zip")) {
                snapshots.add(file);
            } else if (file.isDirectory() && !file.getName().toLowerCase().endsWith(".zip")) {
                snapshots.add(file);
            }
        });
        return snapshots;
    }

    private Map<String, File> retrieveSchemaFactoryFilesForSnapshots() {
        HashMap<String, File> schemaFactoryFiles = new HashMap<String, File>();
        this.foreachSchemaFactoryFile(null, file -> {
            schemaFactoryFiles.put(file.getName(), file);
            return true;
        });
        return schemaFactoryFiles;
    }

    @Override
    @Nullable
    public String getSchemaName(File schemaFactoryFile) {
        try {
            if (!schemaFactoryFile.exists()) {
                return null;
            }
            OlapSchemaFactoryInfo info = OlapSchemaFactoryInfoParser.parse(schemaFactoryFile);
            return info.getName();
        }
        catch (OlapSchemaFactoryInfoError ignored) {
            LOGGER.warn((Object)("The schema def. file information could not be unmarshalled [" + schemaFactoryFile.getAbsolutePath() + "]"));
            return null;
        }
    }

    @Override
    @Nullable
    public OlapSchemaFactoryInfo getFactoryInfo(File schemaFactoryFile) {
        try {
            if (!schemaFactoryFile.exists()) {
                return null;
            }
            OlapSchemaFactoryInfo info = OlapSchemaFactoryInfoParser.parse(schemaFactoryFile);
            return info;
        }
        catch (OlapSchemaFactoryInfoError ignored) {
            LOGGER.warn((Object)("The schema def. file information could not be unmarshalled [" + schemaFactoryFile.getAbsolutePath() + "]"));
            return null;
        }
    }
}

