/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.schemas;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.olap.component.schemas.IOlapSchemaFactoryFileAction;
import crazydev.iccube.olap.component.schemas.IOlapSchemaFactoryInfoAction;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSnapshotFile;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class OlapEngineAbstractSchemaDefFactoryHelper
extends OlapEngineSchemaDefFactoryHelper {
    @Override
    public OlapCaseInsensitiveNames getAllSchemaNames(int maxCount) {
        ArrayList<String> names = new ArrayList<String>();
        this.foreachSchemaFactoryInfo(info -> {
            names.add(info.getName());
            return names.size() < maxCount;
        });
        return new OlapCaseInsensitiveNames(names);
    }

    @Override
    public OlapCaseInsensitiveNames getAllDimensionNames(String schema) {
        ArrayList<String> names = new ArrayList<String>();
        SchemaDefinitionInfo definition = this.getSchemaDefinition(schema);
        if (definition != null) {
            try {
                List<IOlapBuilderDimensionDef> dimensionDefs = definition.definition.getDimensions();
                if (dimensionDefs != null) {
                    for (IOlapBuilderDimensionDef dimensionDef : dimensionDefs) {
                        String dimensionName = dimensionDef.getName();
                        if (dimensionName == null || dimensionName.isEmpty()) continue;
                        names.add(dimensionName);
                    }
                }
            }
            catch (RuntimeException ignored) {
                LOGGER.warn((Object)("invalid schema def. factory [" + definition.factory.getAbsolutePath() + "]"));
            }
        }
        return new OlapCaseInsensitiveNames(names);
    }

    @Override
    public OlapCaseInsensitiveNames getAllHierarchyNames(String schema, String dimension) {
        ArrayList<String> names = new ArrayList<String>();
        SchemaDefinitionInfo definition = this.getSchemaDefinition(schema);
        if (definition != null) {
            try {
                List<IOlapBuilderDimensionDef> dimensionDefs = definition.definition.getDimensions();
                for (IOlapBuilderDimensionDef dimensionDef : dimensionDefs) {
                    String dimensionName = dimensionDef.getName();
                    if (!dimension.equals(dimensionName)) continue;
                    List<String> hierarchyNames = dimensionDef.getHierarchyNames();
                    if (hierarchyNames != null) {
                        for (String hierarchyName : hierarchyNames) {
                            if (!CdStringUtils.isNotNullAndNotBlank((String)hierarchyName)) continue;
                            names.add(hierarchyName);
                        }
                    }
                    break;
                }
            }
            catch (RuntimeException ignored) {
                LOGGER.warn((Object)("invalid schema def. factory [" + definition.factory.getAbsolutePath() + "]"));
            }
        }
        return new OlapCaseInsensitiveNames(names);
    }

    @Override
    public List<IOlapBuilderCubeDef> getAllCubes(String schema) {
        SchemaDefinitionInfo definition = this.getSchemaDefinition(schema);
        if (definition != null) {
            try {
                List<IOlapBuilderCubeDef> cubeDefs = definition.definition.getCubes();
                if (cubeDefs != null) {
                    return cubeDefs;
                }
            }
            catch (RuntimeException ignored) {
                LOGGER.warn((Object)("invalid schema def. factory [" + definition.factory.getAbsolutePath() + "]"));
            }
        }
        return new ArrayList<IOlapBuilderCubeDef>();
    }

    @Override
    public OlapCaseInsensitiveNames getAllCubeNames(String schema) {
        ArrayList<String> names = new ArrayList<String>();
        SchemaDefinitionInfo definition = this.getSchemaDefinition(schema);
        if (definition != null) {
            try {
                List<IOlapBuilderCubeDef> cubeDefs = definition.definition.getCubes();
                if (cubeDefs != null) {
                    for (IOlapBuilderCubeDef cubeDef : cubeDefs) {
                        String cubeName = cubeDef.getName();
                        if (cubeName == null || cubeName.isEmpty()) continue;
                        names.add(cubeName);
                    }
                }
            }
            catch (RuntimeException ignored) {
                LOGGER.warn((Object)("invalid schema def. factory [" + definition.factory.getAbsolutePath() + "]"));
            }
        }
        return new OlapCaseInsensitiveNames(names);
    }

    @Override
    public OlapCaseInsensitiveNames getAllCubePerspectiveNames(String schema) {
        ArrayList<String> names = new ArrayList<String>();
        SchemaDefinitionInfo definition = this.getSchemaDefinition(schema);
        if (definition != null) {
            try {
                List<IOlapBuilderPerspectiveDef> perspectives = definition.definition.getPerspectives();
                if (perspectives != null) {
                    for (IOlapBuilderPerspectiveDef perspective : perspectives) {
                        String perspectiveName;
                        if (perspective.isDefault() || (perspectiveName = perspective.getName()) == null || perspectiveName.isEmpty()) continue;
                        names.add(perspectiveName);
                    }
                }
            }
            catch (RuntimeException ignored) {
                LOGGER.warn((Object)("invalid schema def. factory [" + definition.factory.getAbsolutePath() + "]"));
            }
        }
        return new OlapCaseInsensitiveNames(names);
    }

    @Override
    @Nullable
    public String getPerspectiveCubeId(String schema, String perspective) {
        SchemaDefinitionInfo definition = this.getSchemaDefinition(schema);
        if (definition != null) {
            try {
                List<IOlapBuilderPerspectiveDef> schemaPerspectives = definition.definition.getPerspectives();
                if (schemaPerspectives != null) {
                    for (IOlapBuilderPerspectiveDef schemaPerspective : schemaPerspectives) {
                        String perspectiveName = schemaPerspective.getName();
                        if (perspectiveName == null || !perspectiveName.equals(perspective)) continue;
                        String cubeId = schemaPerspective.getCubeId();
                        return cubeId;
                    }
                }
            }
            catch (RuntimeException ignored) {
                LOGGER.warn((Object)("invalid schema def. factory [" + definition.factory.getAbsolutePath() + "]"));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getSchemaName(File schemaFactoryFile) {
        return null;
    }

    @Override
    @Nullable
    public OlapSchemaFactoryInfo getFactoryInfo(File schemaFactoryFile) {
        return null;
    }

    @Override
    @Nullable
    public File getFactoryFile(String schema) {
        return null;
    }

    @Override
    public void foreachSchemaFactoryFile(@Nullable FileFilter filter, IOlapSchemaFactoryFileAction action) {
    }

    @Override
    public void foreachSchemaFactoryInfo(IOlapSchemaFactoryInfoAction action) {
    }

    @Override
    public List<String> getNonExistingSchemaFactories(List<String> schemas) {
        return null;
    }

    @Override
    public List<File> retrieveRelativeSchemaFactoryFiles(int maxCount) {
        return null;
    }

    @Override
    public IOlapBuilderSchemaDefFactory unmarshallXmlFactory(File schemaFactoryFile) throws OlapBuilderErrorException {
        return null;
    }

    @Override
    public void writeSchemaDefFactoryFileContent(String savedBy, File file, InputStream in, String operation) throws IOException {
    }

    @Override
    public boolean deleteSchemaDefFactoryFile(File file) {
        return false;
    }

    @Override
    public List<String> getOfflineSnapshotNames(String schemaFactoryFileName) throws IOException {
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllOfflineSnapshotNames() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public Map<File, List<OlapSnapshotFile>> getAllOfflineSnapshots() throws IOException {
        return Collections.emptyMap();
    }

    @Override
    @Nullable
    public OlapSnapshotFile getOfflineSnapshot(String name) {
        return null;
    }

    @Override
    public File getOfflineSnapshotForWrite(@Nullable String specifiedSnapshot, OlapSchema schema) {
        return null;
    }

    @Override
    public boolean deleteOfflineSnapshot(File file) {
        return false;
    }

    @Override
    public OlapCaseInsensitiveNames getAllMeasureGroupNames(String schema, String cube) {
        ArrayList<String> names;
        block6: {
            names = new ArrayList<String>();
            SchemaDefinitionInfo definition = this.getSchemaDefinition(schema);
            if (definition != null) {
                try {
                    List<IOlapBuilderCubeDef> cubeDefs = definition.definition.getCubes();
                    if (cubeDefs == null) break block6;
                    for (IOlapBuilderCubeDef cubeDef : cubeDefs) {
                        String cubeName = cubeDef.getName();
                        if (!cube.equals(cubeName)) continue;
                        List<IOlapBuilderBaseFactsDef> factDefs = cubeDef.getFacts();
                        if (factDefs != null) {
                            for (IOlapBuilderBaseFactsDef factDef : factDefs) {
                                String factName = factDef.getMeasureGroupName();
                                if (factName == null || factName.isEmpty()) continue;
                                names.add(factName);
                            }
                        }
                        break;
                    }
                }
                catch (RuntimeException ignored) {
                    LOGGER.warn((Object)("invalid schema def. factory [" + definition.factory.getAbsolutePath() + "]"));
                }
            }
        }
        return new OlapCaseInsensitiveNames(names);
    }

    @Nullable
    protected SchemaDefinitionInfo getSchemaDefinition(String schema) {
        File file = this.getFactoryFile(schema);
        if (file == null) {
            return null;
        }
        IOlapBuilderSchemaDefFactory factory = this.unmarshallXmlFactory(file);
        if (factory == null) {
            return null;
        }
        IOlapBuilderSchemaDef definition = factory.createSchemaDefinition(null, null);
        return new SchemaDefinitionInfo(file, definition);
    }

    private static class SchemaDefinitionInfo {
        final File factory;
        final IOlapBuilderSchemaDef definition;

        SchemaDefinitionInfo(File factory, IOlapBuilderSchemaDef definition) {
            this.factory = factory;
            this.definition = definition;
        }
    }
}

