/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.naming;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyValues;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveRenames;

public final class OlapPerspectiveNamesContext
extends OlapNameContext {
    private final OlapRequestNamesContext nameContext;
    private final OlapPerspectiveRenames renames;
    private final boolean renamesDimensions;
    private final boolean renamesHierarchies;
    private final boolean renamesLevels;
    private final boolean renamesMembers;

    public OlapPerspectiveNamesContext(OlapRequestNamesContext nameContext, OlapPerspectiveRenames renames) {
        this.nameContext = nameContext;
        this.renames = renames;
        this.renamesDimensions = renames.renamesDimensions();
        this.renamesHierarchies = renames.renamesHierarchies();
        this.renamesLevels = renames.renamesLevels();
        this.renamesMembers = renames.renamesMembers();
    }

    @Override
    public boolean isRenamingMember(OlapLevel level) {
        return this.renames.isRenamingMember(level) || this.nameContext.isRenamingMember(level);
    }

    @Override
    public String getDimensionName(OlapDimension dimension, String name) {
        String newName;
        if (this.renamesDimensions && (newName = this.renames.getName(dimension)) != null) {
            return newName;
        }
        return this.nameContext.getDimensionName(dimension, name);
    }

    @Override
    public boolean hasNewUniqueName(OlapDimension dimension) {
        return this.renamesDimensions && this.renames.getName(dimension) != null;
    }

    @Override
    public String getHierarchyName(OlapHierarchy hierarchy, String name) {
        String newName;
        if (this.renamesHierarchies && (newName = this.renames.getName(hierarchy)) != null) {
            return newName;
        }
        return this.nameContext.getHierarchyName(hierarchy, name);
    }

    @Override
    public boolean hasNewUniqueName(OlapHierarchy hierarchy) {
        return this.renamesHierarchies && this.renames.getName(hierarchy) != null || this.hasNewUniqueName(hierarchy.getDimension());
    }

    @Override
    public String getLevelName(OlapLevel level, String name) {
        String newName;
        if (this.renamesLevels && (newName = this.renames.getName(level)) != null) {
            return newName;
        }
        return this.nameContext.getLevelName(level, name);
    }

    @Override
    public boolean hasNewUniqueName(OlapLevel level) {
        return this.renamesLevels && this.renames.getName(level) != null || this.hasNewUniqueName(level.getHierarchy());
    }

    @Override
    public String getMemberName(OlapMember member, String name) {
        String newName;
        if (this.renamesMembers && (newName = this.renames.getName(member)) != null) {
            return newName;
        }
        return this.nameContext.getMemberName(member, name);
    }

    @Override
    public String getCaption(OlapMemberPropertyValues values) {
        return this.nameContext.getCaption(values);
    }
}

