/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.mdx;

import crazydev.iccube.olap.component.mdx.ICompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptExecutionInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxStatementCompilationInfo;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSetWrapper;
import crazydev.iccube.olap.entity.result.script.OlapResScriptDataSet;
import crazydev.iccube.olap.eval.script.OlapScriptInstr;
import crazydev.iccube.olap.eval.select.IExecuteStatementInstr;
import org.jetbrains.annotations.Nullable;

public class OlapEngineMdxScriptCompilationInfo
implements ICompilationInfo {
    private final OlapEngineMdxHelper helper;
    private final String schema;
    private final String name;
    private final String script;
    @Nullable
    private final OlapResScriptDataSet result;
    @Nullable
    private final OlapScriptInstr scriptInstr;

    public OlapEngineMdxScriptCompilationInfo(OlapEngineMdxHelper helper, String schema, String name, String script, OlapResScriptDataSet result) {
        this.helper = helper;
        this.schema = schema;
        this.name = name;
        this.script = script;
        this.result = result;
        this.scriptInstr = null;
    }

    public OlapEngineMdxScriptCompilationInfo(OlapEngineMdxHelper helper, String schema, String name, String script, OlapScriptInstr scriptInstr) {
        this.helper = helper;
        this.schema = schema;
        this.name = name;
        this.script = script;
        this.result = null;
        this.scriptInstr = scriptInstr;
    }

    @Override
    public OlapEngineMdxHelper getHelper() {
        return this.helper;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public boolean hasResult() {
        return this.result != null;
    }

    @Override
    public OlapResStatementDataSetWrapper getResultX() {
        return new OlapResStatementDataSetWrapper(this.result);
    }

    @Nullable
    public OlapResScriptDataSet getResult() {
        return this.result;
    }

    @Override
    public IExecuteStatementInstr getInstr() {
        return this.scriptInstr;
    }

    @Nullable
    public OlapScriptInstr getScriptInstr() {
        return this.scriptInstr;
    }

    public OlapEngineMdxScriptExecutionInfo asExecutionInfo() {
        if (this.result != null) {
            throw new RuntimeException("internal error : should not execute a script with compilation error");
        }
        if (this.scriptInstr == null) {
            throw new RuntimeException("internal error : missing script compilation information");
        }
        return new OlapEngineMdxScriptExecutionInfo(this.schema, this.name, this.script, this.scriptInstr);
    }

    public OlapEngineMdxStatementCompilationInfo toStatementCompilationInfo() {
        return new OlapEngineMdxStatementCompilationInfo(this.helper, this.schema, this.script, "?", this.scriptInstr.getStatements().getFirst());
    }
}

