/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.mdx;

import com.google.gson.Gson;
import crazydev.common.collection.CdCollections;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.ICdException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.MdxScriptParserHelper;
import crazydev.iccube.mdx.parser.ast.MdxEntity;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCurrent;
import crazydev.iccube.mdx.parser.ast.expression.script.MdxScriptExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCalcMemberProperties;
import crazydev.iccube.mdx.parser.ast.statement.MdxStatementExpression;
import crazydev.iccube.mdx.parser.excel.MdxExcelFixFilterHelperSet;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.select.MdxCreateXyzExpressionPropertiesCompilerHelper;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptExecutionInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxStatementCompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxStatementKind;
import crazydev.iccube.olap.component.mdx.OlapMdxAuditManager;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapFactlessCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.result.OlapResErrorMdxStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptErrorDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptRegularDataSet;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermit;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.instr.OlapAssertInstrVisitor;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.script.OlapScriptInstr;
import crazydev.iccube.olap.eval.select.OlapEmptySelectStatementInstr;
import crazydev.iccube.olap.eval.select.OlapStatementInstr;
import crazydev.iccube.olap.eval.select.OlapTopLevelSelectInstr;
import crazydev.iccube.olap.eval.select.context.OlapExpressionEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapScriptExecutionContext;
import crazydev.iccube.olap.facts.column.aggregator.OlapAggregationSumAlgo;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumDoubleAggregator;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepositorySnapshot;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLock;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapEngineMdxHelper {
    private final OlapEngineRequestContext requestContext;
    @Nullable
    private final OlapSchemaFunctionRepositorySnapshot functionRepository;
    @Nullable
    private final OlapInstrExecListener instrExecListener;
    @Nullable
    private final List<OlapProperty> properties;

    private OlapEngineMdxHelper(OlapEngineRequestContext requestContext, @Nullable OlapSchemaFunctionRepositorySnapshot functionRepository, @Nullable OlapInstrExecListener instrExecListener, @Nullable List<OlapProperty> properties) {
        this.requestContext = requestContext;
        this.functionRepository = functionRepository;
        this.instrExecListener = instrExecListener;
        this.properties = properties;
    }

    public static OlapEngineMdxHelper create(OlapEngineRequestContext requestContext) {
        return new OlapEngineMdxHelper(requestContext, null, null, null);
    }

    public static OlapEngineMdxHelper create(OlapEngineRequestContext requestContext, OlapSchemaFunctionRepositorySnapshot functionRepository) {
        return new OlapEngineMdxHelper(requestContext, functionRepository, null, null);
    }

    public static OlapEngineMdxHelper create(OlapEngineRequestContext requestContext, @Nullable OlapInstrExecListener instrExecListener, @Nullable List<OlapProperty> properties) {
        return new OlapEngineMdxHelper(requestContext, null, instrExecListener, properties);
    }

    @Nullable
    public OlapInstrExecListener getInstrExecListener() {
        return this.instrExecListener;
    }

    @Nullable
    public MdxEntity parseMdxValueExpression(OlapSchema schema, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        if (mdx == null || mdx.trim().isEmpty()) {
            return null;
        }
        OlapCompilationContext ccontext = this.setupCompilationContext(this.properties);
        MdxParsingContext pcontext = this.setupParsingContext(ccontext, schema.getFunctionRepositorySnapshot());
        MdxExpression expr = MdxParser.parseValueExpression(pcontext, mdx, mdxHash);
        return expr;
    }

    public OlapEntity executeMdxValueExpression(OlapSchema schema, @Nullable String cubeName, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return this.executeMdxValueExpression(null, true, schema, cubeName, mdx, mdxHash);
    }

    public OlapEntity executeMdxValueExpression(OlapMdxExecutionPermit permit, OlapSchema schema, @Nullable String cubeName, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return this.executeMdxValueExpression(permit, true, schema, cubeName, mdx, mdxHash);
    }

    public OlapEntity executeMdxValueExpressionWithNoEval(OlapSchema schema, @Nullable String cubeName, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return this.executeMdxValueExpression(null, false, schema, cubeName, mdx, mdxHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OlapEntity executeMdxValueExpression(@Nullable OlapMdxExecutionPermit permitFromCaller, boolean withEval, OlapSchema schema, @Nullable String cubeName, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        OlapEntity olapEntity;
        OlapMdxExecutionPermit permit;
        OlapMdxStatementExecutionContext sContext;
        OlapExpressionEvaluationContext context;
        OlapInstr instr;
        S_MdxStatementRequestContextRef clusterContextRef;
        long startNS;
        long startMS;
        Logger logger;
        block17: {
            Object scontext;
            OlapCube cube;
            block16: {
                logger = this.requestContext.getLoggers().mdxEvaluation();
                startMS = System.currentTimeMillis();
                startNS = System.nanoTime();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"MDX value processing started...");
                    logger.info((Object)("MDX (uuid:" + this.requestContext.getRequestClientUUID() + ") (schema:" + schema.getName() + ")\n" + mdx));
                }
                clusterContextRef = null;
                if (mdx != null && !mdx.trim().isEmpty()) break block16;
                OlapNullEntity olapNullEntity = OlapNullEntity.INSTANCE;
                this.requestContext.deleteMdxStatementContext(clusterContextRef);
                {
                    catch (Throwable throwable) {
                        this.requestContext.deleteMdxStatementContext(clusterContextRef);
                        if (!logger.isInfoEnabled()) throw throwable;
                        logger.info((Object)("MDX (value) statement executed in " + CdTimeUtils.formatNanosEx((long)startNS)));
                        throw throwable;
                    }
                }
                if (!logger.isInfoEnabled()) return olapNullEntity;
                logger.info((Object)("MDX (value) statement executed in " + CdTimeUtils.formatNanosEx((long)startNS)));
                return olapNullEntity;
            }
            OlapCompilationContext ccontext = this.setupCompilationContext(this.properties);
            instr = this.compileMdx(schema.getFunctionRepositorySnapshot(), ccontext, OlapEngineMdxStatementKind.VALUE_EXPRESSION, mdx, mdxHash);
            if (instr instanceof OlapTopLevelSelectInstr) {
                throw new OlapEvaluationException(this.createExpressionEvalExceptionContext(cubeName, mdx, mdxHash), OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"The MDX expression [" + mdx + "] is a SELECT statement"});
            }
            IOlapSchemaPermission schemaPermission = this.requestContext.getSchemaPermissions(schema);
            OlapCube olapCube = cube = cubeName == null ? null : schema.lookupCubeByName(schemaPermission, this.requestContext.getNameContext(), cubeName);
            if (cubeName != null && cube == null) {
                String availableCubeNames = CdCollections.toString(schema.getCubes(schemaPermission), (String)"'");
                throw new OlapEvaluationException(this.createExpressionEvalExceptionContext(cubeName, mdx, mdxHash), OlapErrorCode.CUBE_UNKNOWN, new Serializable[]{cubeName, availableCubeNames});
            }
            if (cube != null) {
                OlapMdxStatementWithCubeSelectExecutionContext scontext2 = this.setupSelectExecutionContext(withEval, schema, this.properties, cube);
                if (withEval && !cube.isFactless()) {
                    clusterContextRef = scontext2.createClusterContext();
                    scontext2.createClusterStaticContext();
                }
                context = this.setupCubeExpressionExecutionContext(scontext2);
            } else {
                OlapInstrLocationRange locationRange = this.createSelectEvalExceptionContext(mdx, mdxHash).getErrorLocation();
                OlapFactlessCube factless = new OlapFactlessCube(locationRange, "", schema);
                scontext = this.setupSelectExecutionContext(withEval, schema, this.properties, factless);
                context = this.setupSchemaExpressionExecutionContext((OlapMdxStatementWithCubeSelectExecutionContext)scontext);
            }
            sContext = context.getStatementExecutionContext();
            permit = permitFromCaller == null ? sContext.acquireMdxExecutionPermit() : sContext.acquireMdxExecutionPermitEx(permitFromCaller);
            if (!permit.isCancelled()) break block17;
            scontext = OlapNullEntity.INSTANCE;
            this.requestContext.deleteMdxStatementContext(clusterContextRef);
            if (!logger.isInfoEnabled()) return scontext;
            logger.info((Object)("MDX (value) statement executed in " + CdTimeUtils.formatNanosEx((long)startNS)));
            return scontext;
        }
        try {
            OlapEntity res = instr.executeWithHousekeeping(context);
            this.auditMdx(startMS, schema.getName(), cubeName, mdx, res);
            olapEntity = res;
            if (permitFromCaller == null) {
                sContext.releaseMdxExecutionPermit(permit);
            } else {
                sContext.releaseMdxExecutionPermitEx(permit);
            }
            this.requestContext.deleteMdxStatementContext(clusterContextRef);
        }
        catch (Throwable throwable) {
            if (permitFromCaller == null) {
                sContext.releaseMdxExecutionPermit(permit);
                throw throwable;
            }
            sContext.releaseMdxExecutionPermitEx(permit);
            throw throwable;
        }
        if (!logger.isInfoEnabled()) return olapEntity;
        logger.info((Object)("MDX (value) statement executed in " + CdTimeUtils.formatNanosEx((long)startNS)));
        return olapEntity;
    }

    public OlapEntity executeFlatAuthorizationExpression(OlapSchema schema, @Nullable OlapCube cube, Map<String, OlapTupleSet> sets, Map<String, OlapDeclaredFunction> functions, @Nullable MdxAuthorizationCurrent current, MdxExpression mdxExpression) {
        return this.executeFlatAuthorizationExpression(schema, cube, sets, functions, current, mdxExpression, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapEntity executeFlatAuthorizationExpression(OlapSchema schema, @Nullable OlapCube cube, Map<String, OlapTupleSet> sets, Map<String, OlapDeclaredFunction> functions, @Nullable MdxAuthorizationCurrent current, MdxExpression mdxExpression, @Nullable OlapMdxStatementWithCubeSelectExecutionContext[] sContextCache) {
        OlapCompilationContext cContext = this.setupCompilationContext(this.properties);
        Object instr = cContext.compile(mdxExpression);
        ((OlapInstr)instr).accept(new OlapAssertInstrVisitor((OlapInstr)instr));
        S_MdxStatementRequestContextRef clusterContextRef = null;
        try {
            OlapEntity res;
            OlapMdxStatementWithCubeSelectExecutionContext sContext;
            if (cube != null) {
                if (sContextCache == null || sContextCache[0] == null) {
                    sContext = this.setupSelectExecutionContext(true, schema, this.properties, cube);
                    clusterContextRef = sContext.createClusterContext();
                    sContext.createClusterStaticContext();
                    if (sContextCache != null) {
                        sContextCache[0] = sContext;
                    }
                } else {
                    sContext = sContextCache[0];
                }
            } else {
                OlapFactlessCube factless = new OlapFactlessCube(((OlapInstr)instr).getLocationRange(), "", schema);
                sContext = this.setupSelectExecutionContext(false, schema, this.properties, factless);
            }
            OlapExpressionEvaluationContext context = this.setupFlatAuthorizationExpressionExecutionContext(sContext, sets, functions, current);
            OlapEntity olapEntity = res = ((OlapInstr)instr).executeWithHousekeeping((OlapExpressionEvaluationContext)context);
            if (clusterContextRef != null && sContextCache == null) {
                this.requestContext.deleteMdxStatementContext(clusterContextRef);
            }
            return olapEntity;
        }
        catch (Throwable throwable) {
            if (clusterContextRef != null && sContextCache == null) {
                this.requestContext.deleteMdxStatementContext(clusterContextRef);
            }
            throw throwable;
        }
    }

    @Nullable
    public OlapNonScalarAbstractEntity executePerspectiveExpression(OlapSchema schema, OlapCube cube, IOlapBuilderPerspectiveDef perspective, MdxExpression mdxExpression) {
        OlapCompilationContext ccontext = this.setupCompilationContext(this.properties);
        Object instr = ccontext.compile(mdxExpression);
        ((OlapInstr)instr).accept(new OlapAssertInstrVisitor((OlapInstr)instr));
        OlapMdxStatementWithCubeSelectExecutionContext scontext = this.setupSelectExecutionContext(true, schema, this.properties, cube);
        OlapExpressionEvaluationContext context = this.setupPerspectiveExpressionExecutionContext(scontext, perspective);
        OlapEntity res = ((OlapInstr)instr).executeWithHousekeeping((OlapExpressionEvaluationContext)context);
        if (!(res instanceof OlapNonScalarAbstractEntity)) {
            IOlapEvaluationExceptionContext evalExceptionContext = this.createSelectEvalExceptionContext(mdxExpression.asMdx(), UUID.randomUUID().toString());
            throw new OlapEvaluationException(evalExceptionContext, OlapErrorCode.PERSPECTIVE_EVAL_UNEXPECTED_RESULT, new Serializable[]{res.getFriendlyTypeName()});
        }
        return (OlapNonScalarAbstractEntity)res;
    }

    public OlapCellProperties createMeasureCellPropertiesForBuilder(OlapSchema schema, String name, String cellProperties) throws CdMdxScannerException, MdxParserException {
        OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot = schema.getFunctionRepositorySnapshot();
        MdxParsingContext pcontext = this.setupParsingContext(schemaFunctionRepositorySnapshot, this.properties);
        String mdx = cellProperties;
        String mdxHash = UUID.randomUUID().toString();
        MdxSelectCalcMemberProperties mdxProperties = MdxParser.parseCalcMemberProperties(pcontext, mdx, mdxHash);
        OlapCompilationContext ccontext = this.setupCompilationContext(this.properties);
        OlapEntityIdentifier anchorId = new OlapEntityIdentifier("Measures", name);
        OlapCellProperties properties = MdxCreateXyzExpressionPropertiesCompilerHelper.compileProperties(ccontext, anchorId.asString(), mdxProperties);
        return properties;
    }

    private OlapInstr compileMdx(OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot, OlapCompilationContext ccontext, OlapEngineMdxStatementKind what, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        MdxParsingContext pcontext = this.setupParsingContext(ccontext, schemaFunctionRepositorySnapshot);
        Object mdxInstr = ccontext.compile(switch (what) {
            case OlapEngineMdxStatementKind.MDX_STATEMENT -> MdxParser.parseMdxStatement(pcontext, mdx, mdxHash);
            case OlapEngineMdxStatementKind.VALUE_EXPRESSION -> MdxParser.parseValueExpression(pcontext, mdx, mdxHash);
            default -> throw new CdProgrammingException("Unknown MDX statement type [" + String.valueOf((Object)what) + "]");
        });
        ((OlapInstr)mdxInstr).accept(new OlapAssertInstrVisitor((OlapInstr)mdxInstr));
        return mdxInstr;
    }

    private MdxParsingContext setupParsingContext(OlapCompilationContext ccontext, OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot) {
        MdxParsingContext pcontext = new MdxParsingContext(ccontext.getProperties(), ccontext.getFunctionRepository(), schemaFunctionRepositorySnapshot);
        return pcontext;
    }

    private MdxParsingContext setupParsingContext(OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot, @Nullable List<OlapProperty> requestProperties) {
        MdxParsingContext pcontext = new MdxParsingContext(this.requestContext.getOlapEngineProperties().override(requestProperties), this.requestContext.getOlapEngineComponent().getFunctionRepository(), schemaFunctionRepositorySnapshot);
        return pcontext;
    }

    private OlapCompilationContext setupCompilationContext(@Nullable List<OlapProperty> requestProperties) {
        OlapEngineApplicationContext applicationContext = this.requestContext.getApplicationContext();
        OlapEngineComponent olapEngine = applicationContext.getOlapEngineComponent();
        OlapCompilationContext ccontext = new OlapCompilationContext(this.requestContext.getXmlaCaller(), this.requestContext.getMdxDefaultRequestedCellProperties(), olapEngine.getProperties().override(requestProperties), olapEngine.getFunctionRepository(), this.requestContext.getOlapEngineComponent().getModuleMethodsRepository());
        return ccontext;
    }

    private OlapExpressionEvaluationContext setupFlatAuthorizationExpressionExecutionContext(OlapMdxStatementWithCubeSelectExecutionContext scontext, Map<String, OlapTupleSet> sets, Map<String, OlapDeclaredFunction> functions, @Nullable MdxAuthorizationCurrent current) {
        return this.requestContext.setupFlatAuthorizationExpressionExecutionContext(scontext, sets, functions, current);
    }

    private OlapExpressionEvaluationContext setupPerspectiveExpressionExecutionContext(OlapMdxStatementWithCubeSelectExecutionContext scontext, IOlapBuilderPerspectiveDef perspective) {
        return this.requestContext.setupPerspectiveExpressionExecutionContext(scontext, perspective);
    }

    private OlapExpressionEvaluationContext setupCubeExpressionExecutionContext(OlapMdxStatementWithCubeSelectExecutionContext scontext) {
        return this.requestContext.setupCubeExpressionExecutionContext(scontext);
    }

    private OlapExpressionEvaluationContext setupSchemaExpressionExecutionContext(OlapMdxStatementWithCubeSelectExecutionContext scontext) {
        return this.requestContext.setupSchemaExpressionExecutionContext(scontext);
    }

    private OlapMdxStatementWithCubeSelectExecutionContext setupSelectExecutionContext(boolean withEval, OlapSchema schema, @Nullable List<OlapProperty> properties, OlapCube cube) {
        return new OlapMdxStatementWithCubeSelectExecutionContext(this.requestContext, this.requestContext.getOlapEngineProperties().override(properties), null, this.instrExecListener, schema, cube, withEval);
    }

    private IOlapEvaluationExceptionContext createSelectEvalExceptionContext(final String mdx, final String mdxHash) {
        return new IOlapEvaluationExceptionContext(){
            final /* synthetic */ OlapEngineMdxHelper this$0;
            {
                OlapEngineMdxHelper olapEngineMdxHelper = this$0;
                Objects.requireNonNull(olapEngineMdxHelper);
                this.this$0 = olapEngineMdxHelper;
            }

            @Override
            public Locale getLocale() {
                return this.this$0.requestContext.getLocale();
            }

            @Override
            public OlapNameContext getNameContext() {
                return this.this$0.requestContext.getNameContext();
            }

            @Override
            @Nullable
            public OlapInstrLocationRange getErrorLocation() {
                return new OlapInstrLocationRange(mdx, mdxHash, 0, mdx.length() - 1, 1);
            }

            @Override
            public IOlapEvaluationExceptionContext snapshotForError() {
                return this;
            }

            @Override
            public boolean isDimensionalityCheck() {
                return true;
            }
        };
    }

    private IOlapEvaluationExceptionContext createExpressionEvalExceptionContext(final @Nullable String cubeName, final String mdx, final String mdxHash) {
        return new IOlapEvaluationExceptionContext(){
            final /* synthetic */ OlapEngineMdxHelper this$0;
            {
                OlapEngineMdxHelper olapEngineMdxHelper = this$0;
                Objects.requireNonNull(olapEngineMdxHelper);
                this.this$0 = olapEngineMdxHelper;
            }

            @Override
            public Locale getLocale() {
                return this.this$0.requestContext.getLocale();
            }

            @Override
            public OlapNameContext getNameContext() {
                return this.this$0.requestContext.getNameContext();
            }

            @Override
            @Nullable
            public OlapInstrLocationRange getErrorLocation() {
                String info = (cubeName == null ? "<null>" : cubeName) + " : " + mdx;
                return new OlapInstrLocationRange(info, mdxHash, 0, info.length() - 1, 1);
            }

            @Override
            public IOlapEvaluationExceptionContext snapshotForError() {
                return this;
            }

            @Override
            public boolean isDimensionalityCheck() {
                return true;
            }
        };
    }

    private boolean isExcelFixFilterHelperSet() {
        if (this.properties == null) {
            return false;
        }
        return this.requestContext.getOlapEngineProperties().override(this.properties).isExcelFixFilterHelperSet();
    }

    public OlapInstr __compileMdxSelectQuery(OlapSchema schema, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        if (schema == null) {
            throw new CdProgrammingException("missing schema!");
        }
        return this.compileMdx(schema.getFunctionRepositorySnapshot(), this.setupCompilationContext(this.properties), OlapEngineMdxStatementKind.MDX_STATEMENT, mdx, mdxHash);
    }

    public OlapInstr __compileMdxValueExpression(OlapSchema schema, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        if (schema == null) {
            throw new CdProgrammingException("missing schema!");
        }
        return this.compileMdx(schema.getFunctionRepositorySnapshot(), this.setupCompilationContext(this.properties), OlapEngineMdxStatementKind.VALUE_EXPRESSION, mdx, mdxHash);
    }

    public OlapResStatementDataSet __executeMdxStatement(OlapSchema schema, String mdx, String mdxHash) {
        return this.__executeMdxStatement(schema, mdx, mdxHash, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapResStatementDataSet __executeMdxStatement(OlapSchema schema, String mdx, String mdxHash, @Nullable String[] initialSelection) {
        OlapEngineMdxStatementCompilationInfo compilationInfo = this.compileMdxStatement(schema.getName(), mdx, mdxHash, initialSelection);
        OlapResStatementDataSet compilationResult = compilationInfo.getResult();
        if (compilationResult != null) {
            return compilationResult;
        }
        OlapStatementInstr instr = compilationInfo.getStatementInstr();
        if (instr == null) {
            throw new RuntimeException("internal error : missing MDX execution information");
        }
        IcCubeSchemaAccessLock lock = IcCubeSchemaAccessLock.create(schema.getName(), instr.getSchemaAccessLockMode());
        this.requestContext.setSchemaAccessLock(lock);
        try {
            OlapResStatementDataSet result;
            OlapResStatementDataSet olapResStatementDataSet = result = this.executeMdxStatement(compilationInfo, schema);
            return olapResStatementDataSet;
        }
        finally {
            this.requestContext.clearAccessReadWriteLock(lock);
        }
    }

    public OlapEngineMdxStatementCompilationInfo compileMdxStatement(String schema, String mdx, String mdxHash) {
        return this.compileMdxStatement(schema, mdx, mdxHash, null);
    }

    public OlapEngineMdxStatementCompilationInfo compileMdxStatement(String schema, String mdx, String mdxHash, @Nullable String[] initialSelection) {
        try {
            OlapEngineMdxStatementCompilationInfo info = this.unsafeCompileMdxStatement(schema, mdx, mdxHash, initialSelection);
            return info;
        }
        catch (CdMdxException ex) {
            OlapResErrorMdxStatementDataSet error = new OlapResErrorMdxStatementDataSet(schema, mdx, (ICdException)ex);
            OlapEngineMdxStatementCompilationInfo info = new OlapEngineMdxStatementCompilationInfo(this, schema, mdx, mdxHash, error);
            return info;
        }
        catch (OlapException ex) {
            OlapResErrorMdxStatementDataSet error = new OlapResErrorMdxStatementDataSet(schema, mdx, (ICdException)ex);
            OlapEngineMdxStatementCompilationInfo info = new OlapEngineMdxStatementCompilationInfo(this, schema, mdx, mdxHash, error);
            return info;
        }
    }

    private OlapEngineMdxStatementCompilationInfo unsafeCompileMdxStatement(String schema, String mdx, String mdxHash, @Nullable String[] initialSelection) throws CdMdxScannerException, MdxParserException {
        OlapStatementInstr statementInstr;
        if (mdx == null || mdx.trim().isEmpty()) {
            OlapInstrLocationRange range = new OlapInstrLocationRange(mdx == null ? "" : mdx, mdxHash, 0, 0, 1);
            statementInstr = new OlapEmptySelectStatementInstr(range);
        } else {
            OlapCompilationContext ccontext = this.setupCompilationContext(this.properties);
            OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot = this.getSchemaFunctionRepository(schema);
            OlapInstr instr = this.compileMdx(schemaFunctionRepositorySnapshot, ccontext, OlapEngineMdxStatementKind.MDX_STATEMENT, mdx, mdxHash);
            if (!(instr instanceof OlapStatementInstr)) {
                throw new OlapEvaluationException(this.createSelectEvalExceptionContext(mdx, mdxHash), OlapErrorCode.MDX_STATEMENT_TYPE_MISMATCH, new Serializable[]{instr.typeForError()});
            }
            statementInstr = (OlapStatementInstr)instr;
            if (statementInstr instanceof OlapTopLevelSelectInstr) {
                ((OlapTopLevelSelectInstr)statementInstr).setInitialSelection(initialSelection);
            }
        }
        return new OlapEngineMdxStatementCompilationInfo(this, schema, mdx == null ? "" : mdx, mdxHash, statementInstr);
    }

    public OlapResStatementDataSet executeMdxStatement(OlapEngineMdxStatementCompilationInfo compilationInfo, OlapSchema schema) {
        return this.executeMdxStatement(compilationInfo, null, schema, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapResStatementDataSet executeMdxStatement(OlapEngineMdxStatementCompilationInfo compilationInfo, @Nullable String cachedMdxHash, OlapSchema schema, @Nullable String reportPath) {
        OlapRequestId requestId = this.requestContext.getRequestId();
        Logger logger = this.requestContext.getLoggers().mdxEvaluation();
        long startMS = System.currentTimeMillis();
        long startNS = System.nanoTime();
        String mdx = compilationInfo.getMdx();
        if (logger.isInfoEnabled()) {
            String principal = this.requestContext.getUser().logInfo();
            logger.info((Object)("MDX " + requestId.getId() + " statement started " + principal + " [" + schema.getName() + "] [uuid:" + requestId.getClientUUID() + "] \n" + mdx));
        }
        OlapResStatementDataSet result = null;
        try {
            result = this.unsafeExecuteMdxStatementWithExcel2007(compilationInfo, schema);
            result.log(logger, requestId.getId());
            this.auditMdx(startMS, schema.getName(), reportPath, compilationInfo, result);
            OlapResStatementDataSet olapResStatementDataSet = result;
            return olapResStatementDataSet;
        }
        catch (OlapException ex) {
            OlapResErrorMdxStatementDataSet olapResErrorMdxStatementDataSet = new OlapResErrorMdxStatementDataSet(schema.getName(), mdx, (ICdException)ex);
            return olapResErrorMdxStatementDataSet;
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("MDX " + requestId.getId() + "   timing : statement executed in " + CdTimeUtils.formatNanosEx((long)startNS)));
            }
        }
    }

    private OlapResStatementDataSet unsafeExecuteMdxStatementWithExcel2007(OlapEngineMdxStatementCompilationInfo compilationInfo, OlapSchema schema) {
        OlapResStatementDataSet result = this.unsafeExecuteMdxStatement(compilationInfo, schema);
        ICdException error = result.getException();
        if (error == null) {
            return result;
        }
        if (error.isCausedBy((CdErrorCode)CdMdxErrorCode.PARSE_EXCEL_FILTER_HELPER_SET) && this.isExcelFixFilterHelperSet()) {
            return this.unsafeExecuteMdxStatementFixedForExcel2007(result, compilationInfo, schema);
        }
        return result;
    }

    private OlapResStatementDataSet unsafeExecuteMdxStatementFixedForExcel2007(OlapResStatementDataSet resultOnError, OlapEngineMdxStatementCompilationInfo compilationInfo, OlapSchema schema) {
        Logger logger = this.requestContext.getLoggers().mdxEvaluation();
        try {
            String mdx = compilationInfo.getMdx();
            String mdxHash = compilationInfo.getMdxHash();
            String fixedMdx = MdxExcelFixFilterHelperSet.fixMdxStatement(this.setupParsingContext(this.getSchemaFunctionRepository(schema.getName()), this.properties), mdx, mdxHash);
            if (fixedMdx == null) {
                return resultOnError;
            }
            OlapEngineMdxStatementCompilationInfo fixedCompilationInfo = this.compileMdxStatement(schema.getName(), fixedMdx, mdxHash);
            logger.warn((Object)("EXCEL MDX .FilterHelperSet fix (original) : " + mdx));
            logger.warn((Object)("EXCEL MDX .FilterHelperSet fix (fixed)    : " + fixedMdx));
            OlapResStatementDataSet fixedRes = this.unsafeExecuteMdxStatement(fixedCompilationInfo, schema);
            if (fixedRes.isError()) {
                return resultOnError;
            }
            return fixedRes;
        }
        catch (CdMdxException | IOException | RuntimeException ex) {
            return resultOnError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapResStatementDataSet unsafeExecuteMdxStatement(OlapEngineMdxStatementCompilationInfo compilationInfo, OlapSchema schema) {
        OlapResStatementDataSet compilationResult = compilationInfo.getResult();
        if (compilationResult != null) {
            return compilationResult;
        }
        OlapStatementInstr statementInstr = compilationInfo.getStatementInstr();
        if (statementInstr == null) {
            throw new RuntimeException("internal error: missing MDX statement compilation information");
        }
        OlapAggregationSumAlgo engineALGO = this.requestContext.getOlapEngineProperties().getMdxSumAlgo();
        try {
            OlapResStatementDataSet result;
            OlapMdxStatementExecutionContext mdxContext;
            OlapProperties props;
            OlapAggregationSumAlgo execALGO;
            Object sContext = statementInstr.setupExecutionContext(this.requestContext, this.properties, this.instrExecListener, schema, false);
            if (sContext instanceof OlapMdxStatementExecutionContext && (execALGO = (props = (mdxContext = (OlapMdxStatementExecutionContext)sContext).getRequestProperties()).getMdxSumAlgo()) != null) {
                OlapFactColumnSumDoubleAggregator.SUM_ALGO = execALGO;
            }
            OlapEntity resultEntity = statementInstr.executeWithHousekeeping(sContext);
            OlapResStatementDataSet olapResStatementDataSet = result = (OlapResStatementDataSet)resultEntity;
            return olapResStatementDataSet;
        }
        finally {
            OlapFactColumnSumDoubleAggregator.SUM_ALGO = engineALGO;
        }
    }

    public OlapEngineMdxScriptCompilationInfo compileMdxScript(String schema, String name, String mdx, String mdxHash) {
        try {
            OlapEngineMdxScriptCompilationInfo info = this.unsafeCompileMdxScript(schema, name, mdx, mdxHash);
            return info;
        }
        catch (CdMdxException ex) {
            OlapResScriptErrorDataSet error = new OlapResScriptErrorDataSet(name, schema, (ICdException)ex);
            return new OlapEngineMdxScriptCompilationInfo(this, schema, name, mdx, error);
        }
        catch (OlapException ex) {
            OlapResScriptErrorDataSet error = new OlapResScriptErrorDataSet(name, schema, (ICdException)ex);
            return new OlapEngineMdxScriptCompilationInfo(this, schema, name, mdx, error);
        }
    }

    private OlapEngineMdxScriptCompilationInfo unsafeCompileMdxScript(String schema, String name, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        OlapScriptInstr scriptInstr;
        if (mdx == null || mdx.trim().isEmpty()) {
            OlapInstrLocationRange range = new OlapInstrLocationRange(mdx, name, 0, 0, 1);
            scriptInstr = new OlapScriptInstr(range, name);
        } else {
            OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot = this.getSchemaFunctionRepository(schema);
            MdxParsingContext pcontext = this.setupParsingContext(schemaFunctionRepositorySnapshot, this.properties);
            MdxScriptExpression scriptExpression = MdxScriptParserHelper.parse(pcontext, name, new StringReader(mdx), mdxHash);
            if (scriptExpression.isEmpty()) {
                OlapInstrLocationRange range = new OlapInstrLocationRange(mdx, name, 0, 0, 1);
                scriptInstr = new OlapScriptInstr(range, name);
            } else {
                OlapCompilationContext ccontext = this.setupCompilationContext(this.properties);
                Object instr = ccontext.compile(scriptExpression);
                if (!(instr instanceof OlapScriptInstr)) {
                    throw new OlapEvaluationException(this.createSelectEvalExceptionContext(mdx, name), OlapErrorCode.MDX_SCRIPT_TYPE_MISMATCH, new Serializable[]{((OlapInstr)instr).typeForError()});
                }
                scriptInstr = (OlapScriptInstr)instr;
                this.setupInitialSelection(scriptInstr, mdx);
            }
        }
        return new OlapEngineMdxScriptCompilationInfo(this, schema, name, mdx, scriptInstr);
    }

    private void setupInitialSelection(OlapScriptInstr scriptInstr, String mdx) {
        try {
            OlapStatementInstr statement;
            List<OlapStatementInstr> statements;
            if (mdx.contains("//initialSelection=") && (statements = scriptInstr.getStatements()) != null && statements.size() == 1 && (statement = statements.getFirst()) instanceof OlapTopLevelSelectInstr) {
                OlapTopLevelSelectInstr statementTL = (OlapTopLevelSelectInstr)statement;
                String[] parts = mdx.split("//initialSelection=");
                if (parts.length == 2) {
                    String initialSelection = parts[1];
                    Map json = (Map)new Gson().fromJson("{arr:" + initialSelection + "}", Map.class);
                    Object arr = json.get("arr");
                    if (arr instanceof List) {
                        List arrL = (List)arr;
                        String[] values = new String[arrL.size()];
                        for (int ii = 0; ii < values.length; ++ii) {
                            Object element = arrL.get(ii);
                            if (element instanceof String) {
                                String elementS;
                                values[ii] = elementS = (String)element;
                                continue;
                            }
                            OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] could not extract the initialSelection : not an array of strings >> " + initialSelection));
                        }
                        if (values.length > 0) {
                            statementTL.setInitialSelection(values);
                        }
                    } else {
                        OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] could not extract the initialSelection : not an array >> " + initialSelection));
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] could not extract the initialSelection", (Throwable)ex);
        }
    }

    private OlapSchemaFunctionRepositorySnapshot getSchemaFunctionRepository(String schema) {
        if (this.functionRepository != null) {
            return this.functionRepository;
        }
        return this.requestContext.getAuthorizedSchemaFunctionRepositorySnapshot(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapResScriptDataSet __executeMdxScript(OlapSchema schema, String name, String mdx) {
        OlapEngineMdxScriptCompilationInfo compilationInfo = this.compileMdxScript(schema.getName(), name, mdx, "?");
        OlapResScriptDataSet compilationResult = compilationInfo.getResult();
        if (compilationResult != null) {
            return compilationResult;
        }
        OlapScriptInstr instr = compilationInfo.getScriptInstr();
        IcCubeSchemaAccessLock lock = IcCubeSchemaAccessLock.create(schema.getName(), instr.getSchemaAccessLockMode());
        this.requestContext.setSchemaAccessLock(lock);
        try {
            OlapResScriptDataSet result;
            OlapResScriptDataSet olapResScriptDataSet = result = this.executeMdxScript(compilationInfo.asExecutionInfo(), schema);
            return olapResScriptDataSet;
        }
        finally {
            this.requestContext.clearAccessReadWriteLock(lock);
        }
    }

    public OlapResScriptDataSet executeMdxScript(OlapEngineMdxScriptExecutionInfo compilationInfo, OlapSchema schema) {
        return this.executeMdxScript(compilationInfo, schema, false, false, false);
    }

    public OlapResScriptDataSet executeMdxScriptUX(OlapEngineMdxScriptExecutionInfo compilationInfo, OlapSchema schema) {
        return this.executeMdxScript(compilationInfo, schema, true, false, false);
    }

    public OlapResScriptDataSet executeMdxScriptForBuilder(OlapEngineMdxScriptExecutionInfo compilationInfo, OlapSchema schema, boolean forPhaseI) {
        return this.executeMdxScript(compilationInfo, schema, false, true, forPhaseI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapResScriptDataSet executeMdxScript(OlapEngineMdxScriptExecutionInfo compilationInfo, OlapSchema schema, boolean forUX, boolean forBuilder, boolean forPhaseI) {
        OlapRequestId requestId = this.requestContext.getRequestId();
        Logger logger = this.requestContext.getLoggers().mdxEvaluation();
        String name = compilationInfo.getName();
        String mdx = compilationInfo.getScript();
        long startMS = System.currentTimeMillis();
        long startNS = System.nanoTime();
        if (logger.isInfoEnabled()) {
            String principal = this.requestContext.getUser().logInfo();
            logger.info((Object)("MDX " + requestId.getId() + " script started " + principal + " [" + schema.getName() + " : " + name + "] [uuid:" + this.requestContext.getRequestClientUUID() + "]\n" + mdx));
        }
        OlapResScriptDataSet result = null;
        try {
            result = this.unsafeExecuteMdxScript(compilationInfo, schema, forUX, forBuilder, forPhaseI);
            this.auditMdx(startMS, schema.getName(), null, compilationInfo, result);
            OlapResScriptDataSet olapResScriptDataSet = result;
            return olapResScriptDataSet;
        }
        catch (OlapException ex) {
            OlapResScriptErrorDataSet olapResScriptErrorDataSet = new OlapResScriptErrorDataSet(name, schema.getName(), (ICdException)ex);
            return olapResScriptErrorDataSet;
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("MDX " + requestId.getId() + " script executed in " + CdTimeUtils.formatNanosEx((long)startNS)));
            }
        }
    }

    private OlapResScriptDataSet unsafeExecuteMdxScript(OlapEngineMdxScriptExecutionInfo compilationInfo, OlapSchema schema, boolean forUX, boolean forBuilder, boolean forPhaseI) {
        OlapScriptInstr statementInstr = compilationInfo.getScriptInstr();
        OlapScriptExecutionContext scontext = statementInstr.setupExecutionContext(this.requestContext, this.properties, this.instrExecListener, schema, forUX, forBuilder, forPhaseI);
        OlapEntity resultEntity = statementInstr.executeWithHousekeeping(scontext);
        OlapResScriptDataSet result = (OlapResScriptDataSet)resultEntity;
        return result;
    }

    private void auditMdx(long startMS, String schemaName, @Nullable String reportPath, OlapEngineMdxScriptExecutionInfo compilationInfo, OlapResScriptDataSet result) {
        if (result instanceof OlapResScriptRegularDataSet) {
            OlapResScriptRegularDataSet sResult = (OlapResScriptRegularDataSet)result;
            List<OlapResStatementDataSet> results = sResult.getStatementResults();
            if (!results.isEmpty()) {
                for (OlapResStatementDataSet res : results) {
                    if (!res.isMdxAudit()) continue;
                    String cubeName = res.getCubeNameForMdxAudit();
                    String statement = res.getMdx();
                    this.auditMdx(startMS, reportPath, schemaName, cubeName, statement);
                }
            }
        } else if (!(result instanceof OlapResScriptErrorDataSet) && result != null) {
            OlapLoggers.MDX_EVALUATION.warn((Object)("[audit] could not audit result [" + result.getClass().getName() + "]"));
        }
    }

    private void auditMdx(long startMS, String schemaName, @Nullable String reportPath, OlapEngineMdxStatementCompilationInfo compilationInfo, OlapResStatementDataSet result) {
        String cubeName = result.getCubeNameForMdxAudit();
        String statement = result.getMdx();
        this.auditMdx(startMS, reportPath, schemaName, cubeName, statement);
    }

    private void auditMdx(long startMS, String schemaName, @Nullable String cubeName, String statement, OlapEntity result) {
        this.auditMdx(startMS, null, schemaName, cubeName, statement);
    }

    private void auditMdx(long startMS, @Nullable String reportPath, String schemaName, String cubeName, String statement) {
        OlapMdxAuditManager audit = this.requestContext.getApplicationContext().getMdxAuditManager();
        if (audit != null && audit.hasListeners()) {
            OlapPrincipal principal = this.requestContext.getUser();
            String tenant = principal.getTenantName();
            String user = principal.getName();
            long elapsedMS = System.currentTimeMillis() - startMS;
            audit.onMdxExecuted(false, reportPath, tenant, user, schemaName, cubeName, statement, startMS, elapsedMS);
        }
    }

    @Nullable
    public MdxStatementExpression extractSelectStatement(String schema, String mdx) throws CdMdxScannerException, MdxParserException {
        String mdxHash = "meta-info";
        OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot = this.getSchemaFunctionRepository(schema);
        MdxParsingContext pContext = this.setupParsingContext(schemaFunctionRepositorySnapshot, this.properties);
        MdxStatementExpression expression = MdxParser.extractMdxStatement(pContext, mdx, "meta-info");
        return expression;
    }
}

