/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.common.exception.ICdException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.cluster.shared.backup.S_RestoreMode;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadMeasureGroupParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadPartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineRestoreSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineUnloadPartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapLoadMeasureGroupsHelper;
import crazydev.iccube.olap.component.command.builtin.OlapLoadPartitionsHelper;
import crazydev.iccube.olap.component.command.builtin.OlapLoadSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.command.builtin.OlapUnloadPartitionsHelper;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptDataSet;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepositorySnapshot;
import crazydev.iccube.request.task.IcCubeSchemaAccessLock;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class OlapRestoreSchemaHelper
extends OlapSchemaHelper {
    public OlapRestoreSchemaHelper(OlapEngineRequestContext olapEngineRequestContext) {
        super(olapEngineRequestContext);
    }

    public OlapSchemaLifeCycleStatus restoreSchema(OlapEngineRestoreSchemaParams params) {
        String restoreTimestamp;
        OlapSchema schema;
        if (params.getRestoringMode() == S_RestoreMode.INITIAL_LOAD) {
            String schemaName = params.getRestoringSchemaName();
            String timestamp = params.getRestoreTimestamp();
            M_BackupManager backupManager = this.olapEngineRequestContext.getOrCreateBackupManager();
            if (!backupManager.isBackupWithPartitionHistory(schemaName, timestamp)) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"backup with no history cannot be restored in INITIAL_LOAD mode"});
            }
        }
        OlapLoadSchemaHelper helper = new OlapLoadSchemaHelper(this.olapEngineRequestContext);
        OlapSchemaLifeCycleStatus status = helper.loadSchema(params);
        int phase = this.olapEngineRequestContext.getLoadSchemaTask();
        if (phase == 0 && OlapSchemaLoadStatus.LOADED == status.getLoadStatus()) {
            boolean success;
            M_BackupManager backupManager;
            File[] activities;
            schema = this.olapEngineRequestContext.getLoadedSchemaPhaseI();
            restoreTimestamp = params.getRestoreTimestamp();
            if (restoreTimestamp != null) {
                schema.setLastDataUpdatedTime(S_BackupHelper.getTimestamp(restoreTimestamp));
            }
            if (params.getRestoringMode() == S_RestoreMode.FULL && (activities = (backupManager = this.olapEngineRequestContext.getOrCreateBackupManager()).restoreActivities(schema)) != null && activities.length > 0 && !(success = this.restoreActivities(params, schema, activities))) {
                this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(new OlapSchemaLifeCycleStatus(schema.getName(), OlapSchemaLoadStatus.LOAD_ERROR));
            }
        }
        if (phase == 1 && status.getLoadStatus() == OlapSchemaLoadStatus.LOADED) {
            schema = this.olapEngineRequestContext.getLoadedSchemaPhaseI();
            OlapLoggers.BACKUP.info((Object)("[backup] restored schema [" + schema.getName() + "] switching to backup mode"));
            schema.setRestoring(false, params.isBackupOff());
            restoreTimestamp = params.getRestoreTimestamp();
            if (restoreTimestamp != null) {
                schema.setRestoreTimestamp(restoreTimestamp);
            }
        }
        return status;
    }

    private boolean restoreActivities(OlapEngineRestoreSchemaParams params, OlapSchema schema, File[] activities) {
        OlapLoggers.BACKUP.info((Object)("[backup] restoring activities for schema [" + schema.getName() + "] started [" + activities.length + "]"));
        boolean status = true;
        for (int ii = 0; ii < activities.length; ++ii) {
            File activity = activities[ii];
            OlapEngineRequestContext requestContext = this.olapEngineRequestContext.createForRestoringActivity();
            if (this.restoreActivity(requestContext, params, schema, activity)) continue;
            status = false;
            break;
        }
        if (status) {
            Logger logger = this.olapEngineRequestContext.getLoggers().builder();
            OlapLoadSchemaHelper.setupSchemaLocalization(logger, schema);
            OlapLoggers.BACKUP.info((Object)("[backup] restoring activities for schema [" + schema.getName() + "] completed"));
        } else {
            OlapLoggers.BACKUP.error((Object)("[backup] restoring on-error activities for schema [" + schema.getName() + "] completed"));
        }
        return status;
    }

    private boolean restoreActivity(OlapEngineRequestContext requestContext, OlapEngineRestoreSchemaParams params, OlapSchema schema, File dir) {
        try {
            boolean status = OlapRestoreSchemaHelper.unsafeRestoreActivity(requestContext, params, schema, dir);
            return status;
        }
        catch (IOException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] restoring activity [" + dir.getName() + "] for schema [" + schema.getName() + "] error"), (Throwable)ex);
            requestContext.getRequestStatusManager().onRequestError(this.getRequestUuid(), new OlapBuilderError(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage()}));
            return false;
        }
        catch (OlapBuilderErrorException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] restoring activity [" + dir.getName() + "] for schema [" + schema.getName() + "] error"), (Throwable)((Object)ex));
            this.olapEngineRequestContext.getRequestStatusManager().onRequestError(this.getRequestUuid(), ex.getError());
            return false;
        }
        catch (RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] restoring activity [" + dir.getName() + "] for schema [" + schema.getName() + "] error"), (Throwable)ex);
            this.olapEngineRequestContext.getRequestStatusManager().onRequestError(this.getRequestUuid(), new OlapBuilderError(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex.getMessage()}));
            return false;
        }
    }

    private static boolean unsafeRestoreActivity(OlapEngineRequestContext requestContext, OlapEngineRestoreSchemaParams params, OlapSchema schema, File dir) throws IOException {
        boolean status;
        OlapLoggers.BACKUP.info((Object)("[backup] restoring activity [" + dir.getName() + "] for schema [" + schema.getName() + "] started"));
        if (!new File(dir, "valid.icc-marker").exists()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"invalid backup activity directory [" + String.valueOf(schema) + "] [" + dir.getName() + "]"});
        }
        File file = new File(dir, "meta-info.txt");
        List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        String command = lines.remove(0);
        if ("EXECUTE_SCRIPT".equals(command)) {
            status = OlapRestoreSchemaHelper.unsafeRestoreExecuteScript(requestContext, schema, dir.getName(), lines);
        } else if ("LOAD_SCHEMA".equals(command)) {
            status = OlapRestoreSchemaHelper.unsafeRestoreIncrLoad(requestContext, schema, dir.getName(), command, lines);
        } else if ("UNLOAD_PARTITIONS".equals(command)) {
            status = OlapRestoreSchemaHelper.unsafeRestoreUnloadPartitions(requestContext, schema, dir.getName(), command, lines);
        } else if ("LOAD_PARTITIONS".equals(command)) {
            status = OlapRestoreSchemaHelper.unsafeRestoreLoadPartitions(requestContext, schema, dir.getName(), command, lines);
        } else if ("LOAD_MEASURE_GROUP".equals(command)) {
            status = OlapRestoreSchemaHelper.unsafeRestoreLoadMeasureGroup(requestContext, schema, dir.getName(), command, lines);
        } else {
            throw new RuntimeException("internal error: unexpected command [" + command + "]");
        }
        OlapLoggers.BACKUP.info((Object)("[backup] restoring activity [" + dir.getName() + "] for schema [" + schema.getName() + "] completed [" + status + "]"));
        return status;
    }

    private static boolean unsafeRestoreExecuteScript(OlapEngineRequestContext requestContext, OlapSchema schema, String timestamp, List<String> lines) throws IOException {
        boolean status;
        String script = StringUtils.join(lines, (String)"\n");
        if (CdStringUtils.isNullOrBlank((String)script)) {
            return true;
        }
        OlapLoggers.BACKUP.info((Object)("[backup] restoring script [" + timestamp + "] for schema [" + schema.getName() + "] \n" + script));
        OlapSchemaFunctionRepositorySnapshot functionRepository = schema.getFunctionRepositorySnapshot();
        OlapEngineMdxHelper mdxHelper = OlapEngineMdxHelper.create(requestContext, functionRepository);
        OlapEngineMdxScriptCompilationInfo compilationInfo = mdxHelper.compileMdxScript(schema.getName(), "restore-script", script, UUID.randomUUID().toString());
        OlapResScriptDataSet compilationResult = compilationInfo.getResult();
        if (compilationResult != null) {
            status = OlapRestoreSchemaHelper.unsafeRestoreExecuteScriptOnCompilationResult(schema, timestamp, compilationResult);
        } else {
            requestContext.deactivateScriptStatementApplied();
            OlapResScriptDataSet result = mdxHelper.executeMdxScriptForBuilder(compilationInfo.asExecutionInfo(), schema, false);
            status = OlapRestoreSchemaHelper.unsafeRestoreExecuteScriptOnExecutionResult(schema, timestamp, result);
        }
        if (status) {
            OlapLoggers.BACKUP.info((Object)("[backup] restoring script completed [" + timestamp + "] for schema [" + schema.getName() + "]"));
        } else {
            OlapLoggers.BACKUP.error((Object)("[backup] restoring on-error script completed [" + timestamp + "] for schema [" + schema.getName() + "]"));
        }
        return status;
    }

    private static boolean unsafeRestoreExecuteScriptOnExecutionResult(OlapSchema schema, String timestamp, OlapResScriptDataSet compilationResult) {
        boolean status;
        ICdException err = compilationResult.getError();
        if (err != null) {
            OlapLoggers.BACKUP.error((Object)("[backup] execution error restoring script [" + timestamp + "] for schema [" + schema.getName() + "]"), err.asThrowable());
            status = false;
        } else if (compilationResult.isEmpty()) {
            status = true;
        } else {
            List<OlapResStatementDataSet> results = compilationResult.getStatementResults();
            boolean rStatus = true;
            int ii = 0;
            for (OlapResStatementDataSet result : results) {
                if (result.isError()) {
                    ICdException rErr = result.getException();
                    Throwable rThrowable = rErr != null ? rErr.asThrowable() : null;
                    OlapLoggers.BACKUP.error((Object)("[backup] execution error (" + ii + ") restoring script [" + timestamp + "] for schema [" + schema.getName() + "]"), rThrowable);
                    rStatus = false;
                }
                ++ii;
            }
            status = rStatus;
        }
        return status;
    }

    private static boolean unsafeRestoreExecuteScriptOnCompilationResult(OlapSchema schema, String timestamp, OlapResScriptDataSet compilationResult) {
        ICdException err = compilationResult.getError();
        if (err != null) {
            OlapLoggers.BACKUP.error((Object)("[backup] compilation error restoring script [" + timestamp + "] for schema [" + schema.getName() + "]"), err.asThrowable());
        } else if (compilationResult.isEmpty()) {
            OlapLoggers.BACKUP.error((Object)("[backup] compilation error (empty) restoring script [" + timestamp + "] for schema [" + schema.getName() + "]"));
        } else {
            List<OlapResStatementDataSet> results = compilationResult.getStatementResults();
            OlapLoggers.BACKUP.error((Object)("[backup] compilation error (" + results.size() + ") restoring script [" + timestamp + "] for schema [" + schema.getName() + "]"));
            int ii = 0;
            for (OlapResStatementDataSet result : results) {
                if (result.isError()) {
                    ICdException rErr = result.getException();
                    Throwable rThrowable = rErr != null ? rErr.asThrowable() : null;
                    OlapLoggers.BACKUP.error((Object)("[backup] compilation error (" + ii + ") (error) restoring script [" + timestamp + "] for schema [" + schema.getName() + "]"), rThrowable);
                } else if (result.isBlank()) {
                    OlapLoggers.BACKUP.error((Object)("[backup] compilation error (" + ii + ") (blank) restoring script [" + timestamp + "] for schema [" + schema.getName() + "]"));
                } else if (result.isCommand()) {
                    OlapLoggers.BACKUP.error((Object)("[backup] compilation error (" + ii + ") (command) restoring script [" + timestamp + "] for schema [" + schema.getName() + "]"));
                } else {
                    OlapLoggers.BACKUP.error((Object)("[backup] compilation error (" + ii + ") (dataset) restoring script [" + timestamp + "] for schema [" + schema.getName() + "] " + String.valueOf(result)));
                }
                ++ii;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unsafeRestoreIncrLoad(OlapEngineRequestContext requestContext, OlapSchema schema, String timestamp, String command, List<String> lines) throws IOException {
        IOlapEngineLoadSchemaParams rParams = IOlapEngineLoadSchemaParams.restore(command, lines);
        OlapEngineLoadSchemaParams eParams = (OlapEngineLoadSchemaParams)rParams;
        eParams.setSchemaFactoryFile(new File(schema.getBackupDir(), "definition.icc-schema"));
        eParams.setRestoreTimestamp(timestamp);
        eParams.setRestoringSchema(schema);
        requestContext.setLoadSchemaTask(0);
        OlapLoadSchemaHelper helper = new OlapLoadSchemaHelper(requestContext);
        OlapSchemaLifeCycleStatus status = helper.loadSchema(eParams);
        OlapSchemaLoadStatus err = status.getLoadStatus();
        if (!err.isRestoreActivitySuccess()) {
            return false;
        }
        IcCubeSchemaAccessLock lockWRITE = IcCubeSchemaAccessLock.create(schema.getName(), IcCubeSchemaAccessLockMode.WRITE);
        requestContext.setSchemaAccessLock(lockWRITE);
        try {
            requestContext.setLoadSchemaTask(1);
            OlapLoadSchemaHelper helper2 = new OlapLoadSchemaHelper(requestContext);
            OlapSchemaLifeCycleStatus status2 = helper2.loadSchema(eParams);
            OlapSchemaLoadStatus err2 = status2.getLoadStatus();
            if (!err2.isRestoreActivitySuccess()) {
                boolean bl = false;
                return bl;
            }
            schema.setLastDataUpdatedTime(S_BackupHelper.getTimestamp(timestamp));
        }
        finally {
            requestContext.clearAccessReadWriteLock(lockWRITE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unsafeRestoreUnloadPartitions(OlapEngineRequestContext requestContext, OlapSchema schema, String timestamp, String command, List<String> lines) throws IOException {
        IOlapEngineLoadSchemaParams rParams = IOlapEngineLoadSchemaParams.restore(command, lines);
        OlapEngineUnloadPartitionsParams eParams = (OlapEngineUnloadPartitionsParams)rParams;
        eParams.setRestoreTimestamp(timestamp);
        eParams.setRestoringSchema(schema);
        requestContext.getOrCreateUnloadEntityContext(OlapBuilderContextMode.UNLOAD_PARTITIONS).setCurrentTask(1);
        OlapUnloadPartitionsHelper helper = new OlapUnloadPartitionsHelper(requestContext);
        OlapSchemaLifeCycleStatus status = helper.unloadPartitions(eParams);
        OlapSchemaLoadStatus err = status.getLoadStatus();
        if (!err.isRestoreActivitySuccess()) {
            return false;
        }
        IcCubeSchemaAccessLock lockWRITE = IcCubeSchemaAccessLock.create(schema.getName(), IcCubeSchemaAccessLockMode.WRITE);
        requestContext.setSchemaAccessLock(lockWRITE);
        try {
            requestContext.getOrCreateUnloadEntityContext(OlapBuilderContextMode.UNLOAD_PARTITIONS).setCurrentTask(2);
            OlapUnloadPartitionsHelper helper2 = new OlapUnloadPartitionsHelper(requestContext);
            OlapSchemaLifeCycleStatus status2 = helper2.unloadPartitions(eParams);
            OlapSchemaLoadStatus err2 = status2.getLoadStatus();
            if (!err2.isRestoreActivitySuccess()) {
                boolean bl = false;
                return bl;
            }
            schema.setLastDataUpdatedTime(S_BackupHelper.getTimestamp(timestamp));
        }
        finally {
            requestContext.clearAccessReadWriteLock(lockWRITE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unsafeRestoreLoadPartitions(OlapEngineRequestContext requestContext, OlapSchema schema, String timestamp, String command, List<String> lines) throws IOException {
        IOlapEngineLoadSchemaParams rParams = IOlapEngineLoadSchemaParams.restore(command, lines);
        OlapEngineLoadPartitionsParams eParams = (OlapEngineLoadPartitionsParams)rParams;
        eParams.setRestoreTimestamp(timestamp);
        eParams.setRestoringSchema(schema);
        requestContext.getOrCreateLoadEntityContext(OlapBuilderContextMode.LOAD_PARTITIONS).setCurrentTask(1);
        OlapLoadPartitionsHelper helper = new OlapLoadPartitionsHelper(requestContext);
        OlapSchemaLifeCycleStatus status = helper.loadPartitions(eParams);
        OlapSchemaLoadStatus err = status.getLoadStatus();
        if (!err.isRestoreActivitySuccess()) {
            return false;
        }
        IcCubeSchemaAccessLock lockWRITE = IcCubeSchemaAccessLock.create(schema.getName(), IcCubeSchemaAccessLockMode.WRITE);
        requestContext.setSchemaAccessLock(lockWRITE);
        try {
            requestContext.getOrCreateLoadEntityContext(OlapBuilderContextMode.LOAD_PARTITIONS).setCurrentTask(2);
            OlapLoadPartitionsHelper helper2 = new OlapLoadPartitionsHelper(requestContext);
            OlapSchemaLifeCycleStatus status2 = helper2.loadPartitions(eParams);
            OlapSchemaLoadStatus err2 = status2.getLoadStatus();
            if (!err2.isRestoreActivitySuccess()) {
                boolean bl = false;
                return bl;
            }
            schema.setLastDataUpdatedTime(S_BackupHelper.getTimestamp(timestamp));
        }
        finally {
            requestContext.clearAccessReadWriteLock(lockWRITE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unsafeRestoreLoadMeasureGroup(OlapEngineRequestContext requestContext, OlapSchema schema, String timestamp, String command, List<String> lines) throws IOException {
        IOlapEngineLoadSchemaParams rParams = IOlapEngineLoadSchemaParams.restore(command, lines);
        OlapEngineLoadMeasureGroupParams eParams = (OlapEngineLoadMeasureGroupParams)rParams;
        eParams.setRestoreTimestamp(timestamp);
        eParams.setRestoringSchema(schema);
        requestContext.getOrCreateLoadEntityContext(OlapBuilderContextMode.LOAD_MEASURE_GROUPS).setCurrentTask(1);
        OlapLoadMeasureGroupsHelper helper = new OlapLoadMeasureGroupsHelper(requestContext);
        OlapSchemaLifeCycleStatus status = helper.loadMeasureGroup(eParams);
        OlapSchemaLoadStatus err = status.getLoadStatus();
        if (!err.isRestoreActivitySuccess()) {
            return false;
        }
        IcCubeSchemaAccessLock lockWRITE = IcCubeSchemaAccessLock.create(schema.getName(), IcCubeSchemaAccessLockMode.WRITE);
        requestContext.setSchemaAccessLock(lockWRITE);
        try {
            requestContext.getOrCreateLoadEntityContext(OlapBuilderContextMode.LOAD_MEASURE_GROUPS).setCurrentTask(2);
            OlapLoadMeasureGroupsHelper helper2 = new OlapLoadMeasureGroupsHelper(requestContext);
            OlapSchemaLifeCycleStatus status2 = helper2.loadMeasureGroup(eParams);
            OlapSchemaLoadStatus err2 = status2.getLoadStatus();
            if (!err2.isRestoreActivitySuccess()) {
                boolean bl = false;
                return bl;
            }
            schema.setLastDataUpdatedTime(S_BackupHelper.getTimestamp(timestamp));
        }
        finally {
            requestContext.clearAccessReadWriteLock(lockWRITE);
        }
        return true;
    }
}

