/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.common.collection.CdAction;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasFullControlPermissions;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.index.bitmap.OlapOneBitmap;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import org.apache.log4j.Logger;

public class OlapLoadSchemaMembersPostProcessingHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OlapEngineRequestContext engineRequestContext, String schemaName) {
        Logger logger = engineRequestContext.getLoggers().builder();
        long start = System.currentTimeMillis();
        try {
            OlapRoleSchemasFullControlPermissions permissions;
            OlapEngineComponent olapEngine;
            OlapSchema schema;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema] schema [" + schemaName + "] members post-processing started"));
            }
            if ((schema = (olapEngine = engineRequestContext.getOlapEngineComponent()).getAuthorizedSchema(engineRequestContext, permissions = new OlapRoleSchemasFullControlPermissions(), IcCubeSchemaAccessLockMode.READ, schemaName)) != null) {
                if (schema.requiresLoadSchemaMembersPostProcessing()) {
                    this.postProcessMembers(logger, schema);
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("[schema] schema [" + schemaName + "] members post-processing not performed : not required"));
                }
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema] schema [" + schemaName + "] members post-processing not performed : missing schema"));
            }
        }
        catch (RuntimeException ex) {
            logger.warn((Object)("[schema] schema [" + schemaName + "] : members post-processing unexpected post-processing error"), (Throwable)ex);
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema] schema [" + schemaName + "] members post-processing done [" + CdTimeUtils.formatMillisEx((long)start) + "]"));
            }
        }
    }

    private void postProcessMembers(Logger logger, OlapSchema schema) {
        try {
            schema.getDimensions().forEach(dimension -> dimension.getHierarchies().forEach(hierarchy -> {
                if (!hierarchy.isBase() && !hierarchy.isCategory()) {
                    hierarchy.getLevels().forEach(level -> level.forEachMemberWithoutAll((CdAction<OlapMember>)((CdAction)member -> {
                        OlapBitmap memberBitmap = member.getBaseMemberBitmap();
                        if (memberBitmap != null && memberBitmap != OlapOneBitmap.INSTANCE) {
                            memberBitmap.cardinality();
                        }
                    })));
                }
            }));
        }
        catch (RuntimeException ex) {
            logger.error((Object)("[schema] schema [" + schema.getName() + "] post-processing unexpected error"), (Throwable)ex);
            throw ex;
        }
        finally {
            schema.onLoadSchemaMembersPostProcessingDone();
        }
    }
}

