/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdSetList;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderLoadPartitionsContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderTableProcessingHelper;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadPartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapLoadEntityHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;

public class OlapLoadPartitionsHelper
extends OlapLoadEntityHelper<OlapBuilderLoadPartitionsContext, OlapEngineLoadPartitionsParams> {
    public OlapLoadPartitionsHelper(OlapEngineRequestContext olapEngineRequestContext) {
        super(olapEngineRequestContext);
    }

    public OlapSchemaLifeCycleStatus loadPartitions(OlapEngineLoadPartitionsParams params) {
        OlapSchemaLifeCycleStatus status = this.loadEntity(params);
        return status;
    }

    @Override
    protected OlapBuilderContext createBuilderContext(OlapEngineLoadPartitionsParams params, OlapSchema loadedSchema) {
        return new OlapBuilderContext(this.olapEngineRequestContext, params, OlapBuilderContextMode.LOAD_PARTITIONS, null, loadedSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsafeLoadPhaseI(OlapBuilderLoadPartitionsContext eContext, OlapEngineLoadPartitionsParams params, OlapBuilderContext context, OlapSchema loadedSchema) {
        if (!loadedSchema.useFactsPartitioning()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_SCHEMA_NO_PARTITION, new Serializable[]{loadedSchema.getName()});
        }
        OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
        IOlapBuilderSchemaDefFactory schemaDefFactory = loadedSchema.getDefinitionFactory();
        IOlapBuilderSchemaDef schemaDef = schemaDefFactory.createSchemaDefinition(connectionPool, errorManager);
        OlapBuilderReferenceSolver referenceSolver = OlapBuilderSchemaMain.createReferenceSolver(errorManager, schemaDef);
        OlapBuilderSchemaMain.solveReferences(errorManager, schemaDef, referenceSolver);
        Map<String, IOlapBuilderDataTableDef> requestedPartitionsTables = OlapLoadPartitionsHelper.setupRequestedPartitionTableDefs(schemaDef, params.getDataSourceName(), params.getDataTableNames());
        if (this.schemaLogger.isInfoEnabled()) {
            this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " requested partitions table(s) [" + String.join((CharSequence)",", requestedPartitionsTables.keySet()) + "]"));
        }
        Set<IOlapBuilderBaseFactsDef> requestedFactsDefs = OlapLoadPartitionsHelper.setupRequestFactsDefs(this.schemaLogger, eContext.commandForLogsAndErrors(), schemaDef, params.getDataSourceName(), requestedPartitionsTables);
        if (this.schemaLogger.isInfoEnabled()) {
            for (IOlapBuilderBaseFactsDef requestedFactsDef : requestedFactsDefs) {
                this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " requested facts [" + requestedFactsDef.getName() + "]"));
            }
        }
        context.createClusterContext(null, null);
        OlapBuilderSchemaMain.removeAllListeners(schemaDef);
        IOlapFactListFactory dimensionsColumnFactory = OlapBuilderSchemaMain.setupDimensionsColumnListFactory(this.olapEngineRequestContext, loadedSchema);
        IOlapFactListFactory factsColumnFactory = OlapBuilderSchemaMain.setupFactsColumnListFactory(this.olapEngineRequestContext, loadedSchema);
        S_FactBitmapContainerFactory factsBitmapContainerFactory = OlapBuilderSchemaMain.setupFactsBitmapContainerFactory(this.olapEngineRequestContext, loadedSchema);
        List<OlapRegularCube> requestedCubes = this.setupRequestedCubes(eContext, context, schemaDef, requestedFactsDefs, dimensionsColumnFactory, factsColumnFactory, factsBitmapContainerFactory, loadedSchema);
        if (this.schemaLogger.isInfoEnabled()) {
            for (OlapBuilderLoadEntityContext.RequestedCube regularCube : eContext.getRequestedCubes()) {
                this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " requested cube [" + regularCube.getNameX() + "]"));
            }
        }
        try {
            Collection<IOlapBuilderDataTableDef> tables = requestedPartitionsTables.values();
            if (!context.isRestoring()) {
                this.processRequestedFactsTables(eContext, context, connectionPool, params, tables);
                OlapLoadPartitionsHelper.onRequestedFactsTableProcessed(context, requestedCubes);
            } else {
                context.restoreFacts(requestedCubes);
                context.restoreFactsContent();
                OlapLoadPartitionsHelper.onRequestedFactsTableProcessed(context, requestedCubes);
                context.restoreCubesUnresolvedRows(tables);
                context.restoreIncrLoadSavePoints(OlapBuilderSchemaMain.allDataTables(schemaDef));
            }
        }
        finally {
            connectionPool.close();
        }
    }

    static Map<String, IOlapBuilderDataTableDef> setupRequestedPartitionTableDefs(IOlapBuilderSchemaDef schemaDef, String requestedDataSourceName, Set<String> requestedTableNames) {
        HashMap<String, IOlapBuilderDataTableDef> tables = new HashMap<String, IOlapBuilderDataTableDef>();
        OlapBuilderSchemaMain.onAllDataTables(schemaDef, (CdAction<IOlapBuilderDataTableDef>)((CdAction)table -> {
            IOlapBuilderDataSource dataSource;
            if (requestedTableNames.contains(table.getName()) && requestedDataSourceName.equals((dataSource = table.getDataSource()).getName())) {
                if (!table.hasTablePartitioning()) {
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_TABLE_NO_PARTITION, new Serializable[]{"[" + requestedDataSourceName + "].[" + table.getName() + "]"});
                }
                tables.put(table.getName(), (IOlapBuilderDataTableDef)table);
            }
        }));
        for (String requestedTableName : requestedTableNames) {
            if (tables.containsKey(requestedTableName)) continue;
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_UNKNOWN_TABLE, new Serializable[]{"[" + requestedDataSourceName + "].[" + requestedTableName + "]"});
        }
        return tables;
    }

    static IOlapBuilderDataTableDef setupRequestedPartitionTableDef(String requestedDataSourceName, String requestedDataTableName, IOlapBuilderSchemaDef schemaDef) {
        IOlapBuilderDataTableDef[] requestedPartitionsTable = new IOlapBuilderDataTableDef[1];
        OlapBuilderSchemaMain.onAllDataTables(schemaDef, (CdAction<IOlapBuilderDataTableDef>)((CdAction)dataTable -> {
            IOlapBuilderDataSource dataSource;
            if (requestedDataTableName.equals(dataTable.getName()) && requestedDataSourceName.equals((dataSource = dataTable.getDataSource()).getName())) {
                if (requestedPartitionsTable[0] != null) {
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_UNKNOWN_TABLE, new Serializable[]{"[" + requestedDataSourceName + "].[" + requestedDataTableName + "]"});
                }
                requestedPartitionsTable[0] = dataTable;
            }
        }));
        if (requestedPartitionsTable[0] == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_UNKNOWN_TABLE, new Serializable[]{"[" + requestedDataSourceName + "].[" + requestedDataTableName + "]"});
        }
        IOlapBuilderDataTableDef table = requestedPartitionsTable[0];
        if (!table.hasTablePartitioning()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_TABLE_NO_PARTITION, new Serializable[]{"[" + requestedDataSourceName + "].[" + requestedDataTableName + "]"});
        }
        return table;
    }

    static Set<IOlapBuilderBaseFactsDef> setupRequestFactsDefs(Logger schemaLogger, String commandForLogsAndErrors, IOlapBuilderSchemaDef schemaDef, String requestedDataSourceName, Map<String, IOlapBuilderDataTableDef> requestedPartitionsTables) {
        HashSet requestedPartitionsTablesWithFacts = new HashSet();
        HashSet<IOlapBuilderBaseFactsDef> requestedFactsDefs = new HashSet<IOlapBuilderBaseFactsDef>();
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, (cubeDef, factsDef) -> {
            IOlapBuilderDataTableDef requestedPartitionsTable;
            OlapPartitioningType factsPartitionType = factsDef.getPartitioningType();
            if (factsPartitionType != OlapPartitioningType.DATA_TABLE_DEFINED) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as not table partitioned : [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "]"));
                }
                return;
            }
            CdSetList<IOlapBuilderDataTableDef> factsTables = factsDef.getDataView().getUnderlyingTables();
            if (factsTables.isEmpty()) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as no table : [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "]"));
                }
                return;
            }
            if (factsTables.size() > 1) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as view with N tables : [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "] [tables:" + factsTables.size() + "]"));
                }
                return;
            }
            IOlapBuilderDataTableDef factsDataTable = (IOlapBuilderDataTableDef)factsTables.get(0);
            if (!factsDataTable.equals(requestedPartitionsTable = (IOlapBuilderDataTableDef)requestedPartitionsTables.get(factsDataTable.getName()))) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as not attached to requested table [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "] [table:" + factsDataTable.getName() + "]"));
                }
                return;
            }
            OlapIncrementalLoadStrategy incrLoadStrategy = factsDataTable.getIncrementalLoadStrategy();
            if (incrLoadStrategy != null && incrLoadStrategy != OlapIncrementalLoadStrategy.NO_UPDATE) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as incr. load strategy not supported [" + incrLoadStrategy.name() + "] [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "] [table:" + factsDataTable.getName() + "]"));
                }
                return;
            }
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : OK [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "] [table:" + factsDataTable.getName() + "]"));
            }
            requestedFactsDefs.add(factsDef);
            requestedPartitionsTablesWithFacts.add(requestedPartitionsTable.getName());
        });
        for (String requestedDataTableName : requestedPartitionsTables.keySet()) {
            if (requestedPartitionsTablesWithFacts.contains(requestedDataTableName)) continue;
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_FACTS_NO_PARTITION, new Serializable[]{"[" + requestedDataSourceName + "].[" + requestedDataTableName + "]"});
        }
        return requestedFactsDefs;
    }

    static Set<IOlapBuilderBaseFactsDef> setupRequestFactsDefs(Logger schemaLogger, String commandForLogsAndErrors, String requestedDataSourceName, String requestedDataTableName, IOlapBuilderSchemaDef schemaDef, IOlapBuilderDataTableDef requestedPartitionsTable) {
        HashSet<IOlapBuilderBaseFactsDef> requestedFactsDefs = new HashSet<IOlapBuilderBaseFactsDef>();
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, (cubeDef, factsDef) -> {
            OlapPartitioningType factsPartitionType = factsDef.getPartitioningType();
            if (factsPartitionType != OlapPartitioningType.DATA_TABLE_DEFINED) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as not table partitioned : [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "]"));
                }
                return;
            }
            CdSetList<IOlapBuilderDataTableDef> factsTables = factsDef.getDataView().getUnderlyingTables();
            if (factsTables.isEmpty()) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as no table : [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "]"));
                }
                return;
            }
            if (factsTables.size() > 1) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as view with N tables : [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "] [tables:" + factsTables.size() + "]"));
                }
                return;
            }
            IOlapBuilderDataTableDef factsDataTable = (IOlapBuilderDataTableDef)factsTables.get(0);
            if (!factsDataTable.equals(requestedPartitionsTable)) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as not attached to requested table [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "] [table:" + factsDataTable.getName() + "]"));
                }
                return;
            }
            OlapIncrementalLoadStrategy incrLoadStrategy = factsDataTable.getIncrementalLoadStrategy();
            if (incrLoadStrategy != null && incrLoadStrategy != OlapIncrementalLoadStrategy.NO_UPDATE) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : ignored as incr. load strategy not supported [" + incrLoadStrategy.name() + "] [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "] [table:" + factsDataTable.getName() + "]"));
                }
                return;
            }
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[schema] " + commandForLogsAndErrors + " facts : OK [facts:" + factsDef.getName() + "] [partition-type:" + String.valueOf((Object)factsPartitionType) + "] [cube:" + cubeDef.getName() + "] [table:" + factsDataTable.getName() + "]"));
            }
            requestedFactsDefs.add(factsDef);
        });
        if (requestedFactsDefs.isEmpty()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_FACTS_NO_PARTITION, new Serializable[]{"[" + requestedDataSourceName + "].[" + requestedDataTableName + "]"});
        }
        return requestedFactsDefs;
    }

    private List<OlapRegularCube> setupRequestedCubes(final OlapBuilderLoadPartitionsContext eContext, final OlapBuilderContext context, IOlapBuilderSchemaDef schemaDef, final Set<IOlapBuilderBaseFactsDef> requestedFactsDefs, final IOlapFactListFactory dimensionsColumnFactory, final IOlapFactListFactory factsColumnFactory, final S_FactBitmapContainerFactory factsBitmapContainerFactory, final OlapSchema loadedSchema) {
        OlapBuilderSchemaMain.onAllFactsExcludingM2M(schemaDef, new OlapBuilderSchemaMain.FactProcessor(){
            final /* synthetic */ OlapLoadPartitionsHelper this$0;
            {
                OlapLoadPartitionsHelper olapLoadPartitionsHelper = this$0;
                Objects.requireNonNull(olapLoadPartitionsHelper);
                this.this$0 = olapLoadPartitionsHelper;
            }

            @Override
            public void onFact(IOlapBuilderCubeDef cubeDef, IOlapBuilderBaseFactsDef factsDef) {
                if (this.this$0.schemaLogger.isInfoEnabled()) {
                    this.this$0.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " cube checking [cube:" + cubeDef.getName() + "] [facts:" + factsDef.getName() + "]"));
                }
                if (!requestedFactsDefs.contains(factsDef)) {
                    return;
                }
                OlapRegularCube cube = eContext.getRequestedCube(cubeDef);
                if (cube == null) {
                    List<IOlapBuilderBaseFactsDef> cubeFacts = cubeDef.getFacts();
                    OlapMeasuresDimension measureDimension = OlapLoadEntityHelper.setupMeasuresDimension(loadedSchema, dimensionsColumnFactory, cubeDef, cubeFacts);
                    cube = new OlapRegularCube(context, factsColumnFactory, factsBitmapContainerFactory, loadedSchema, cubeDef.getName(), cubeDef.getDescription(), cubeFacts, measureDimension);
                    eContext.registerRequestedCube(cubeDef, cube);
                    if (this.this$0.schemaLogger.isInfoEnabled()) {
                        this.this$0.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " cube setup    [cube:" + cubeDef.getName() + "] [facts:" + factsDef.getName() + "]"));
                    }
                }
                if (this.this$0.schemaLogger.isInfoEnabled()) {
                    this.this$0.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " cube checked  [cube:" + cubeDef.getName() + "] [facts:" + factsDef.getName() + "]"));
                }
                OlapFactCubeManager manager = cube.getCubeFactManager();
                manager.setupClusterInformation();
                IOlapBuilderTableListener factBuilder = factsDef.createFactBuilder(context, cube);
                IOlapBuilderTabularDataDef dataView = factsDef.getDataView();
                dataView.addListener(factBuilder);
                eContext.registerRequestedFacts(cubeDef, factsDef);
                eContext.registerFactBuilder(factBuilder, dataView);
            }
        });
        return eContext.getRequestedCubesX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequestedFactsTables(OlapBuilderLoadPartitionsContext eContext, OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapEngineLoadPartitionsParams params, Collection<IOlapBuilderDataTableDef> requestedPartitionsTables) {
        context.setForFactProcessing(true);
        context.onProgressPhase("factProcessingStarted", new Serializable[0]);
        context.onProgressEvent("factProcessingStarted", new Serializable[0]);
        try {
            if (this.schemaLogger.isInfoEnabled()) {
                for (IOlapBuilderDataTableDef requestedPartitionsTable : requestedPartitionsTables) {
                    this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " partitions table processing started [table:" + requestedPartitionsTable.getName() + "] [active:" + requestedPartitionsTable.hasListeners() + "]"));
                }
            }
            OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION;
            OlapBuilderTableProcessingHelper.processTableForLoadPartitions(context, connectionPool, schedulingPolicy, requestedPartitionsTables, params);
            Map<IOlapBuilderTabularDataDef, List<IOlapBuilderTablePartitionKey>> allRequestedKeys = context.getRequestedTablePartitionKeys();
            for (Map.Entry<IOlapBuilderTabularDataDef, List<IOlapBuilderTablePartitionKey>> entry : allRequestedKeys.entrySet()) {
                IOlapBuilderTabularDataDef requestedPartitionsTable = entry.getKey();
                List<IOlapBuilderTablePartitionKey> rKeys = entry.getValue();
                if (rKeys == null) continue;
                List<IOlapBuilderTableListener> builders = eContext.getFactBuilders(requestedPartitionsTable);
                for (IOlapBuilderTableListener builder : builders) {
                    if (!(builder instanceof OlapBuilderFactBuilder)) continue;
                    OlapBuilderFactBuilder fBuilder = (OlapBuilderFactBuilder)builder;
                    for (IOlapBuilderTablePartitionKey rKey : rKeys) {
                        if (fBuilder.hasData(rKey)) continue;
                        this.schemaLogger.info((Object)"[schema] %s create an empty partition for [table:%s] [%s]".formatted(eContext.commandForLogsAndErrors(), requestedPartitionsTable.getName(), rKey));
                        fBuilder.onNewEmptyRow(context, rKey);
                    }
                }
            }
        }
        finally {
            context.setForFactProcessing(false);
            context.onProgressPhase("factProcessingDone", new Serializable[0]);
            context.onProgressEvent("factProcessingDone", new Serializable[0]);
        }
    }
}

