/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.entityfactory.OlapMeasuresDimensionFactory;
import crazydev.iccube.builder.type.SchemaGarbageCollectorType;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.olap.component.command.builtin.OlapEngineAbstractLoadParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadEntityParams;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.stats.OlapSchemaStatsHolder;
import crazydev.iccube.olap.util.OlapOOM;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class OlapLoadEntityHelper<ENTITY_CTXT extends OlapBuilderLoadEntityContext, ENTITY_PARAMS extends OlapEngineLoadEntityParams>
extends OlapSchemaHelper {
    protected final Logger schemaLogger;

    public OlapLoadEntityHelper(OlapEngineRequestContext olapEngineRequestContext) {
        super(olapEngineRequestContext);
        this.schemaLogger = olapEngineRequestContext.getLoggers().schema();
    }

    protected static void onRequestedFactsTableProcessed(OlapBuilderContext context, List<OlapRegularCube> requestedCubes) {
        for (OlapRegularCube cube : requestedCubes) {
            OlapFactCubeManager cubeFactManager = cube.getCubeFactManager();
            for (OlapFactMeasureGroupBaseManager factBaseManager : cubeFactManager.getFactManagers()) {
                context.onFactsProcessingCompleted(factBaseManager);
            }
        }
    }

    protected static OlapMeasuresDimension setupMeasuresDimension(OlapSchema loadedSchema, IOlapFactListFactory dimensionsColumnFactory, IOlapBuilderCubeDef cubeDef, List<IOlapBuilderBaseFactsDef> cubeFacts) {
        String schemaName = loadedSchema.getName();
        String cubeName = cubeDef.getName();
        OlapRegularCube loadedCube = loadedSchema.lookupCubeByName(OlapNameContext.DEFAULT_VALUES, cubeName);
        if (loadedCube == null) {
            throw new RuntimeException("internal error: missing cube [" + cubeName + "] from schema [" + schemaName + "]");
        }
        OlapMeasuresDimension loadedMeasures = loadedCube.getMeasuresDimension();
        int dimensionIndex = loadedMeasures.getDimensionalityIndex();
        int tupleDimensionalityIndex = loadedMeasures.getTupleDimensionalityIndex();
        OlapMeasuresDimension measureDimension = new OlapMeasuresDimension(loadedSchema, dimensionsColumnFactory, dimensionIndex, tupleDimensionalityIndex);
        OlapMeasuresDimensionFactory.createMeasureMembers(measureDimension, cubeFacts);
        return measureDimension;
    }

    public static void setupSchemaStatistics(OlapSchema loadedSchema) {
        try {
            OlapSchemaStatsHolder stats = loadedSchema.getStatsHolder();
            stats.onLoadEntityCompleted(loadedSchema);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapSchemaLifeCycleStatus loadEntity(ENTITY_PARAMS params) {
        boolean restoring = ((OlapEngineLoadEntityParams)params).isRestoreActivated();
        String schemaName = ((OlapEngineLoadEntityParams)params).getSchemaName();
        try {
            OlapSchemaLifeCycleStatus status;
            OlapSchema loadedSchema;
            if (!restoring) {
                this.olapEngineRequestContext.setupBuilderLoadExecutors(false);
            }
            if (!restoring) {
                loadedSchema = this.getExistingSchemaForRead(schemaName);
            } else {
                OlapSchema restoringSchema = ((OlapEngineLoadEntityParams)params).getRestoringSchema();
                if (restoringSchema == null) {
                    throw new RuntimeException("internal error: missing restoring schema");
                }
                loadedSchema = restoringSchema;
            }
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = status = this.loadMultiPhase(params, loadedSchema);
            return olapSchemaLifeCycleStatus;
        }
        finally {
            if (!restoring) {
                this.olapEngineRequestContext.releaseBuilderLoadExecutors(false);
            }
        }
    }

    private OlapSchemaLifeCycleStatus loadMultiPhase(ENTITY_PARAMS params, OlapSchema loadedSchema) {
        OlapBuilderLoadEntityContext eContext = this.olapEngineRequestContext.getOrCreateLoadEntityContext(((OlapEngineLoadEntityParams)params).getMode());
        if (OlapOOM.oom) {
            throw new RuntimeException(eContext.commandForLogsAndErrors() + " disabled on out-of-memory error");
        }
        if (eContext.getCurrentTask() == 1) {
            OlapSchemaLifeCycleStatus status = this.loadPhaseI(eContext, params, loadedSchema);
            this.olapEngineRequestContext.setLoadedSchemaStatusPhaseI(status);
            this.olapEngineRequestContext.freezeTaskExecutorForSchema(loadedSchema.getName(), ((OlapEngineAbstractLoadParams)params).getWaitS(), ((OlapEngineAbstractLoadParams)params).getCancelS());
            return status;
        }
        if (eContext.getCurrentTask() == 2) {
            OlapSchemaLifeCycleStatus statusPhaseI = this.olapEngineRequestContext.getLoadedSchemaStatusPhaseI();
            if (statusPhaseI == null) {
                throw new RuntimeException("internal error: missing " + eContext.commandForLogsAndErrors() + " [" + ((OlapEngineLoadEntityParams)params).getSchemaName() + "] PHASE-I status");
            }
            OlapSchemaLifeCycleStatus status = this.loadPhaseII_(params, loadedSchema, eContext, statusPhaseI);
            return status;
        }
        throw new RuntimeException("internal error: inconsistent " + eContext.commandForLogsAndErrors() + " processing");
    }

    private OlapSchemaLifeCycleStatus loadPhaseII_(ENTITY_PARAMS params, OlapSchema loadedSchema, ENTITY_CTXT eContext, OlapSchemaLifeCycleStatus statusPhaseI) {
        OlapSchemaLoadStatus loadStatusPhaseI = statusPhaseI.getLoadStatus();
        OlapSchemaLifeCycleStatus status = loadStatusPhaseI == OlapSchemaLoadStatus.PARTITIONS_LOADED ? this.loadPhaseII(eContext, params, loadedSchema) : statusPhaseI;
        OlapBuilderContext context = this.olapEngineRequestContext.getBuilderContext_();
        if (context != null) {
            OlapSchemaLoadStatus loadStatus = status.getLoadStatus();
            boolean succeeded = loadStatus == OlapSchemaLoadStatus.PARTITIONS_LOADED;
            context.onSchemaCompletedPhaseII(succeeded);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapSchemaLifeCycleStatus loadPhaseI(ENTITY_CTXT eContext, ENTITY_PARAMS params, OlapSchema loadedSchema) {
        String schemaName = loadedSchema.getName();
        OlapBuilderContext context = null;
        boolean succeeded = false;
        try {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] " + ((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE I) started " + String.valueOf(params)));
            }
            if (loadedSchema.getCallGC() == SchemaGarbageCollectorType.ACTIVE) {
                long ms = 500L;
                CdSystemUtils.callGC((long)500L);
                M_LocalCluster cluster = this.getCluster();
                N_OlapEngine engine = cluster.getEngine();
                engine.callGC(500L);
            }
            context = this.createBuilderContext(params, loadedSchema);
            this.olapEngineRequestContext.setBuilderContext(context);
            this.olapEngineRequestContext.onLoadSchemaStartedPhaseI(((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors(), loadedSchema);
            this.unsafeLoadPhaseI(eContext, params, context, loadedSchema);
            context.onSchemaProcessingCompleted();
            succeeded = true;
            OlapSchemaLifeCycleStatus ms = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.PARTITIONS_LOADED);
            return ms;
        }
        catch (RuntimeException ex) {
            Object error = ex instanceof CdRuntimeException ? ((CdRuntimeException)((Object)ex)).getError() : new OlapBuilderError(OlapBuilderErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{ex.getMessage()});
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = this.reportError(OlapSchemaLoadStatus.PARTITIONS_LOAD_FAILED, loadedSchema, ((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE I) error [" + schemaName + "]", ex, (CdError)error);
            return olapSchemaLifeCycleStatus;
        }
        finally {
            if (context != null) {
                context.onSchemaProcessingDone(succeeded);
            }
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] " + ((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE I) done [" + schemaName + "]"));
            }
        }
    }

    protected abstract OlapBuilderContext createBuilderContext(ENTITY_PARAMS var1, OlapSchema var2);

    protected abstract void unsafeLoadPhaseI(ENTITY_CTXT var1, ENTITY_PARAMS var2, OlapBuilderContext var3, OlapSchema var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapSchemaLifeCycleStatus loadPhaseII(ENTITY_CTXT eContext, ENTITY_PARAMS params, OlapSchema loadedSchema) {
        String schemaName = loadedSchema.getName();
        try {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)("[schema] " + ((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE II) started [" + schemaName + "]"));
            }
            this.olapEngineRequestContext.onLoadSchemaStartedPhaseII(((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors(), loadedSchema);
            this.unsafeLoadPhaseII(eContext, params, loadedSchema);
            this.olapEngine.loadPartitions(this.olapEngineRequestContext, loadedSchema, ((OlapBuilderLoadEntityContext)eContext).getLoadPartitionsInfo(loadedSchema));
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = new OlapSchemaLifeCycleStatus(schemaName, OlapSchemaLoadStatus.PARTITIONS_LOADED);
            return olapSchemaLifeCycleStatus;
        }
        catch (RuntimeException ex) {
            Object error = ex instanceof CdRuntimeException ? ((CdRuntimeException)((Object)ex)).getError() : new OlapBuilderError(OlapBuilderErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{ex.getMessage()});
            OlapSchemaLifeCycleStatus olapSchemaLifeCycleStatus = this.reportError(OlapSchemaLoadStatus.PARTITIONS_LOAD_ERROR, loadedSchema, ((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE II) error [" + schemaName + "]", ex, (CdError)error);
            return olapSchemaLifeCycleStatus;
        }
        finally {
            if (this.schemaLogger.isInfoEnabled()) {
                this.schemaLogger.info((Object)(((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors() + " (PHASE II) done [" + schemaName + "]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsafeLoadPhaseII(ENTITY_CTXT eContext, ENTITY_PARAMS params, OlapSchema existingSchema) {
        try {
            OlapBuilderContext context = this.olapEngineRequestContext.getBuilderContext_();
            if (context == null) {
                throw new RuntimeException("internal error: missing builder context from PHASE I [" + existingSchema.getName() + "]");
            }
            OlapUnresolvedRowsManager loadedUnresolvedRows = context.getUnresolvedRows();
            if (loadedUnresolvedRows == null) {
                throw new RuntimeException("internal error: missing unresolved rows from PHASE I [" + existingSchema.getName() + "]");
            }
            OlapUnresolvedRowsManager existingUnresolvedRows = existingSchema.getUnresolvedRowsManager();
            ((OlapBuilderLoadEntityContext)eContext).setUnresolvedRows(loadedUnresolvedRows, existingUnresolvedRows);
            List<OlapRegularCube> existingCubes = existingSchema.getCubes();
            List<OlapRegularCube> loadedCubes = ((OlapBuilderLoadEntityContext)eContext).getRequestedCubesX();
            for (OlapRegularCube loadedCube : loadedCubes) {
                if (this.schemaLogger.isInfoEnabled()) {
                    this.schemaLogger.info((Object)("[schema] " + ((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors() + " cube update [" + loadedCube.getNameX() + "]"));
                }
                boolean done = false;
                for (OlapRegularCube existingCube : existingCubes) {
                    if (!existingCube.getNameX().equals(loadedCube.getNameX())) continue;
                    if (existingCube.adoptPartitions((OlapBuilderLoadEntityContext)eContext, context, loadedCube)) {
                        existingSchema.setLastDataUpdatedTime(existingCube.getLastDataUpdatedTime());
                    }
                    done = true;
                }
                if (done || !this.schemaLogger.isInfoEnabled()) continue;
                throw new RuntimeException("internal error: " + ((OlapBuilderLoadEntityContext)eContext).commandForLogsAndErrors() + " cannot update cube - missing existing cube [" + loadedCube.getNameX() + "] from schema [" + existingSchema.getName() + "]");
            }
            ((OlapBuilderLoadEntityContext)eContext).adoptUnresolvedRows2(context);
            context.onLoadPartitionAdopted();
        }
        finally {
            OlapLoadEntityHelper.setupSchemaStatistics(existingSchema);
        }
    }

    protected OlapSchemaLifeCycleStatus reportError(OlapSchemaLoadStatus status, OlapSchema schema, String logMessage, @Nullable Throwable logMessageThrowable, CdError errorToReport) {
        OlapLoggers.COMMAND.warn((Object)logMessage, logMessageThrowable);
        IcCubeRequestStatusManager statusManager = this.olapEngineRequestContext.getRequestStatusManager();
        statusManager.onRequestError(this.getRequestUuid(), errorToReport);
        if (status == OlapSchemaLoadStatus.PARTITIONS_LOAD_ERROR) {
            this.olapEngine.loadPartitionsError(this.olapEngineRequestContext, schema);
        }
        return new OlapSchemaLifeCycleStatus(schema.getName(), status);
    }
}

