/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.olap.component.command.builtin.OlapEngineAbstractLoadParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapEngineUnloadEntityParams
extends OlapEngineAbstractLoadParams {
    protected String schemaName;
    @Nullable
    private String restoreTimestamp;
    @Nullable
    private OlapSchema restoringSchema;

    protected OlapEngineUnloadEntityParams() {
        super(null, false, -1, -1);
    }

    public OlapEngineUnloadEntityParams(String xmlaStatement, String schemaName, int waitS, int cancelS) {
        super(xmlaStatement, false, waitS, cancelS);
        this.schemaName = schemaName;
    }

    @Override
    @Nullable
    public File getSchemaFactoryFile() {
        return null;
    }

    @Override
    public boolean isExplicitFullLoad() {
        return false;
    }

    public abstract OlapBuilderContextMode getMode();

    @Override
    public OlapEngineOfflineMode getOfflineMode() {
        return OlapEngineOfflineMode.OFF;
    }

    @Override
    @Nullable
    public String getOfflineSnapshot() {
        return null;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public boolean isRestoreActivated() {
        return this.restoreTimestamp != null;
    }

    @Override
    @Nullable
    public String getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    public void setRestoreTimestamp(String restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    @Override
    @Nullable
    public OlapSchema getRestoringSchema() {
        return this.restoringSchema;
    }

    public void setRestoringSchema(OlapSchema restoringSchema) {
        this.restoringSchema = restoringSchema;
    }

    @Override
    protected void doSave(File file) throws IOException {
        S_BackupHelper.appendToFile(file, "s:" + this.schemaName + "\n");
    }

    @Override
    protected void doRestore(List<String> lines) throws IOException {
        this.schemaName = lines.remove(0);
    }
}

