/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.cluster.shared.backup.S_RestoreMode;
import crazydev.iccube.olap.component.command.builtin.OlapEngineAbstractLoadParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapEngineRestoreSchemaParams
extends OlapEngineAbstractLoadParams {
    public static final String COMMAND_NAME = "RESTORE_SCHEMA";
    private final File schemaFactoryFile;
    private final String schema;
    private final String timestamp;
    private final S_RestoreMode mode;
    private final boolean backupOff;

    public OlapEngineRestoreSchemaParams(boolean isInCluster, String xmlaStatement, File schemaFactoryFile, String schema, String timestamp, @Nullable String mode, boolean backupOff, int waitS, int cancelS) {
        super(xmlaStatement, false, waitS, cancelS);
        this.schemaFactoryFile = schemaFactoryFile;
        this.schema = schema;
        this.timestamp = timestamp;
        S_RestoreMode s_RestoreMode = this.mode = mode != null ? S_RestoreMode.valueOf(mode.toUpperCase()) : S_RestoreMode.defaultMode();
        if (isInCluster && !backupOff) {
            OlapLoggers.BACKUP.warn((Object)("[backup] backup disabled (from restore params.) for schema [" + schema + "] due to cluster mode"));
            this.backupOff = true;
        } else {
            this.backupOff = backupOff;
        }
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public File getSchemaFactoryFile() {
        return this.schemaFactoryFile;
    }

    @Override
    public boolean isExplicitFullLoad() {
        return true;
    }

    @Override
    public boolean isRestoreActivated() {
        return true;
    }

    @Override
    public S_RestoreMode getRestoringMode() {
        return this.mode;
    }

    public boolean isBackupOff() {
        return this.backupOff;
    }

    @Override
    public String getRestoreTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nullable
    public OlapSchema getRestoringSchema() {
        return null;
    }

    public String getRestoringSchemaName() {
        return this.schema;
    }

    @Override
    public OlapEngineOfflineMode getOfflineMode() {
        return OlapEngineOfflineMode.OFF;
    }

    @Override
    @Nullable
    public String getOfflineSnapshot() {
        return null;
    }

    @Override
    protected void doSave(File file) throws IOException {
        throw new RuntimeException("internal error: inconsistent usage of loading parameters");
    }

    @Override
    protected void doRestore(List<String> lines) throws IOException {
        throw new RuntimeException("internal error: inconsistent usage of loading parameters");
    }
}

