/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.olap.component.command.builtin.OlapEngineAbstractLoadParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapEngineLoadSchemaParams
extends OlapEngineAbstractLoadParams {
    public static final String COMMAND_NAME = "LOAD_SCHEMA";
    private File schemaFactoryFile;
    private boolean explicitFullLoad;
    private OlapEngineOfflineMode offlineMode;
    @Nullable
    private String offlineSnapshot;
    @Nullable
    private String restoreTimestamp;
    @Nullable
    private OlapSchema restoringSchema;
    private boolean keepMdxResultCache;

    protected OlapEngineLoadSchemaParams() {
        super(null, false, -1, -1);
    }

    public OlapEngineLoadSchemaParams(File schemaFactoryFile, boolean explicitFullLoad, int waitS, int cancelS, OlapEngineOfflineMode offlineMode, @Nullable String offlineSnapshot, boolean forceBackupOn) {
        this(schemaFactoryFile, explicitFullLoad, waitS, cancelS, offlineMode, offlineSnapshot, forceBackupOn, false);
    }

    public OlapEngineLoadSchemaParams(File schemaFactoryFile, boolean explicitFullLoad, int waitS, int cancelS, OlapEngineOfflineMode offlineMode, @Nullable String offlineSnapshot, boolean forceBackupOn, boolean keepMdxResultCache) {
        super(null, forceBackupOn, waitS, cancelS);
        this.schemaFactoryFile = schemaFactoryFile;
        this.explicitFullLoad = !offlineMode.isActive() ? explicitFullLoad : true;
        this.offlineMode = offlineMode;
        this.offlineSnapshot = offlineSnapshot;
        this.keepMdxResultCache = keepMdxResultCache;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean isRestoreActivated() {
        return this.restoreTimestamp != null;
    }

    @Override
    public File getSchemaFactoryFile() {
        return this.schemaFactoryFile;
    }

    public void setSchemaFactoryFile(File schemaFactoryFile) {
        this.schemaFactoryFile = schemaFactoryFile;
    }

    @Override
    public boolean isExplicitFullLoad() {
        return this.explicitFullLoad;
    }

    @Override
    public OlapEngineOfflineMode getOfflineMode() {
        return this.offlineMode;
    }

    @Override
    @Nullable
    public String getOfflineSnapshot() {
        return this.offlineSnapshot;
    }

    @Override
    @Nullable
    public String getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    public void setRestoreTimestamp(String restoreTimestamp) {
        this.restoreTimestamp = restoreTimestamp;
    }

    @Override
    @Nullable
    public OlapSchema getRestoringSchema() {
        return this.restoringSchema;
    }

    public void setRestoringSchema(OlapSchema restoringSchema) {
        this.restoringSchema = restoringSchema;
    }

    @Override
    public boolean isKeepMdxResultCache() {
        return this.keepMdxResultCache;
    }

    @Override
    protected void doSave(File file) throws IOException {
        if (this.explicitFullLoad) {
            throw new RuntimeException("internal error: inconsistent usage of loading parameters (explicit full load)");
        }
    }

    @Override
    protected void doRestore(List<String> lines) throws IOException {
        this.explicitFullLoad = false;
    }
}

