/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineRequestedPartitions;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadEntityParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadTablePartitionsParams;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapEngineLoadPartitionsParams
extends OlapEngineLoadEntityParams
implements IOlapEngineRequestedPartitions {
    public static final String COMMAND_NAME = "LOAD_PARTITIONS";
    private String dataSourceName;
    private List<OlapEngineLoadTablePartitionsParams> partitions;
    private boolean continueBackupOnError;

    protected OlapEngineLoadPartitionsParams() {
    }

    public OlapEngineLoadPartitionsParams(String xmlaStatement, String schemaName, String dataSourceName, String dataTableName, boolean partitionsAsRange, List<String> partitions, int waitS, int cancelS, boolean continueBackupOnError) {
        this(xmlaStatement, schemaName, dataSourceName, Collections.singletonList(new OlapEngineLoadTablePartitionsParams(dataTableName, partitionsAsRange, partitions)), waitS, cancelS, continueBackupOnError);
    }

    public OlapEngineLoadPartitionsParams(String xmlaStatement, String schemaName, String dataSourceName, List<OlapEngineLoadTablePartitionsParams> partitions, int waitS, int cancelS, boolean continueBackupOnError) {
        super(xmlaStatement, schemaName, waitS, cancelS);
        this.dataSourceName = dataSourceName;
        this.partitions = partitions;
        this.continueBackupOnError = continueBackupOnError;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public OlapBuilderContextMode getMode() {
        return OlapBuilderContextMode.LOAD_PARTITIONS;
    }

    @Override
    public boolean isContinueBackupOnError() {
        return this.continueBackupOnError;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Set<String> getDataTableNames() {
        HashSet<String> names = new HashSet<String>();
        for (OlapEngineLoadTablePartitionsParams partition : this.partitions) {
            names.add(partition.tableName);
        }
        return names;
    }

    @Override
    @Nullable
    public OlapBuilderTableRequestedPartitionKeys getPartitions(String table) {
        for (OlapEngineLoadTablePartitionsParams partition : this.partitions) {
            if (!partition.tableName.equals(table)) continue;
            return new OlapBuilderTableRequestedPartitionKeys(partition.partitionsAsRange, partition.partitions);
        }
        return null;
    }

    @Override
    public void doSave(File file) throws IOException {
        super.doSave(file);
        S_BackupHelper.appendToFile(file, "ds:" + this.dataSourceName + "\n");
        if (this.partitions.size() > 1) {
            S_BackupHelper.appendToFile(file, "tc:" + this.partitions.size() + "\n");
        }
        for (OlapEngineLoadTablePartitionsParams partition : this.partitions) {
            String dataTableName = partition.tableName;
            boolean partitionsAsRange = partition.partitionsAsRange;
            List<String> partitionNames = partition.partitions;
            S_BackupHelper.appendToFile(file, "dt:" + dataTableName + "\n");
            S_BackupHelper.appendToFile(file, "pr:" + partitionsAsRange + "\n");
            S_BackupHelper.appendToFile(file, "pc:" + partitionNames.size() + "\n");
            for (String partitionName : partitionNames) {
                S_BackupHelper.appendToFile(file, "p:" + partitionName + "\n");
            }
        }
    }

    @Override
    protected void doRestore(List<String> lines) throws IOException {
        super.doRestore(lines);
        this.dataSourceName = lines.remove(0).substring(3);
        String dataTableNameOrTableCount = lines.get(0);
        int tc = dataTableNameOrTableCount.startsWith("tc:") ? Integer.valueOf(lines.remove(0).substring(3)) : 1;
        this.partitions = new ArrayList<OlapEngineLoadTablePartitionsParams>();
        for (int tt = 0; tt < tc; ++tt) {
            String dataTableName = lines.remove(0).substring(3);
            boolean partitionsAsRange = Boolean.valueOf(lines.remove(0).substring(3));
            int pc = Integer.valueOf(lines.remove(0).substring(3));
            ArrayList<String> partitionNames = new ArrayList<String>();
            for (int pp = 0; pp < pc; ++pp) {
                partitionNames.add(lines.remove(0).substring(2));
            }
            this.partitions.add(new OlapEngineLoadTablePartitionsParams(dataTableName, partitionsAsRange, partitionNames));
        }
    }

    public String asString() {
        return "[schema:" + this.schemaName + "] [datasource:" + this.dataSourceName + "] " + OlapEngineLoadTablePartitionsParams.asString(this.partitions);
    }

    public String toString() {
        return this.asString();
    }
}

