/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadEntityParams;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapEngineLoadMeasureGroupParams
extends OlapEngineLoadEntityParams {
    public static final String COMMAND_NAME = "LOAD_MEASURE_GROUP";
    private String cubeName;
    @Nullable
    private String measureGroupName;

    protected OlapEngineLoadMeasureGroupParams() {
    }

    public OlapEngineLoadMeasureGroupParams(String xmlaStatement, String schemaName, String cubeName, @Nullable String measureGroupName, int waitS, int cancelS) {
        super(xmlaStatement, schemaName, waitS, cancelS);
        this.cubeName = cubeName;
        this.measureGroupName = measureGroupName;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public OlapBuilderContextMode getMode() {
        return OlapBuilderContextMode.LOAD_MEASURE_GROUPS;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    @Nullable
    public String getMeasureGroupName() {
        return this.measureGroupName;
    }

    @Override
    protected void doSave(File file) throws IOException {
        super.doSave(file);
        S_BackupHelper.appendToFile(file, "c:" + this.cubeName + "\n");
        S_BackupHelper.appendToFile(file, "mg:" + (this.measureGroupName != null ? this.measureGroupName : "") + "\n");
    }

    @Override
    protected void doRestore(List<String> lines) throws IOException {
        super.doRestore(lines);
        this.cubeName = lines.remove(0).substring(2);
        this.measureGroupName = lines.remove(0).substring(3);
        if (CdStringUtils.isNullOrBlank((String)this.measureGroupName)) {
            this.measureGroupName = null;
        }
    }

    public String asString() {
        String info = "[schema:" + this.schemaName + "] [cube:" + this.cubeName + "]";
        if (this.measureGroupName != null) {
            return info + " [measureGroup:" + this.measureGroupName + "]";
        }
        return info;
    }

    public String toString() {
        return this.asString();
    }
}

