/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.cluster.shared.backup.S_RestoreMode;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapEngineAbstractLoadParams
implements IOlapEngineLoadSchemaParams {
    @Nullable
    private final String xmlaStatement;
    private final boolean forceBackupOn;
    private final int waitS;
    private final int cancelS;

    public OlapEngineAbstractLoadParams(@Nullable String xmlaStatement, boolean forceBackupOn, int waitS, int cancelS) {
        this.xmlaStatement = xmlaStatement;
        this.forceBackupOn = forceBackupOn;
        this.waitS = waitS;
        this.cancelS = cancelS;
    }

    @Override
    @Nullable
    public String getXmlaStatement() {
        return this.xmlaStatement;
    }

    @Override
    public int getWaitS() {
        return this.waitS;
    }

    @Override
    public int getCancelS() {
        return this.cancelS;
    }

    @Override
    public boolean isForceBackupOn() {
        return this.forceBackupOn;
    }

    @Override
    public boolean isKeepMdxResultCache() {
        return false;
    }

    @Override
    public boolean isContinueBackupOnError() {
        return false;
    }

    @Override
    @Nullable
    public S_RestoreMode getRestoringMode() {
        return null;
    }

    @Override
    public void save(File file) throws IOException {
        S_BackupHelper.writeFile(file, this.getCommandName() + "\n");
        this.doSave(file);
    }

    protected abstract void doSave(File var1) throws IOException;

    protected abstract void doRestore(List<String> var1) throws IOException;
}

