/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component;

import crazydev.common.collection.CdTruncatedList;
import crazydev.common.exception.CdError;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.common.locale.CdLanguageIdentifierHelper;
import crazydev.iccube.authentication.OlapAuthenticationServiceClasses;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.executor.pool.OlapBuilderTableExecutorPool;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cleaner.OlapNopFileCleaner;
import crazydev.iccube.cleaner.OlapWindowsFileCleaner;
import crazydev.iccube.common.OlapListenerList;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.configuration.component.plugins.OlapConfPluginContainer;
import crazydev.iccube.configuration.component.plugins.builder.OlapConfBuilderPlugin;
import crazydev.iccube.configuration.component.plugins.function.OlapConfFunctionPlugin;
import crazydev.iccube.configuration.component.plugins.function.OlapConfJavaTableAgrregatorPlugin;
import crazydev.iccube.configuration.component.plugins.intializer.OlapConfAuthenticationServicePlugin;
import crazydev.iccube.configuration.component.plugins.method.OlapConfMethodsPlugin;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.directories.OlapEngineDirectories;
import crazydev.iccube.directories.OlapEngineDirectoriesResolved;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.olap.component.OlapMissingSchemaException;
import crazydev.iccube.olap.component.bigbrother.IOlapBigBrotherMgr;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.component.plugins.OlapEngineAllPluginsInfo;
import crazydev.iccube.olap.component.plugins.OlapEnginePluginInfo;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaDataUpdatedListener;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaLifeCycleListener;
import crazydev.iccube.olap.component.schemas.IOlapSchemaFactoryFileAction;
import crazydev.iccube.olap.component.schemas.IOlapSchemaFactoryInfoAction;
import crazydev.iccube.olap.component.schemas.OlapEngineFileSystemSchemaDefFactoryHelper;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaManager;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingLock;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingToken;
import crazydev.iccube.olap.component.schemas.OlapSnapshotFile;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.eval.facts.aggregation.table.OlapTableAggregatorRepository;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.eval.method.OlapModuleMethodCallInstrFactory;
import crazydev.iccube.olap.eval.method.OlapModuleMethodsRepository;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaDataUpdate;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepositorySnapshot;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaInfo;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.olap.schema.OlapSchemaInformationEx;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestTracker;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.runtime.OlapRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.Nullable;

public class OlapEngineComponent {
    private final OlapLixContent lixContent;
    private final OlapRuntime runtime;
    private final OlapEngineComponentConfiguration configuration;
    private final OlapEngineDirectories directories;
    private final Locale locale;
    @Nullable
    private final IOlapBigBrotherMgr bigBrotherMgr;
    private final OlapBuilderMetaInformationRepository builderMetaInformationRepository;
    private final OlapAuthenticationServiceClasses authenticationServiceClasses;
    private final OlapFunctionRepository functionRepository;
    private final OlapTableAggregatorRepository tableAggregatorRepository;
    private final OlapModuleMethodsRepository moduleMethodsRepository;
    private final OlapEngineAllPluginsInfo allPluginsInfo;
    private final Map<String, OlapEngineSchemaManager> schemas = new ConcurrentHashMap<String, OlapEngineSchemaManager>();
    private final OlapListenerList globalSchemasListeners = new OlapListenerList();
    private final OlapFileCleaner cleaner;
    @Nullable
    private final Semaphore activeSchemaLoadCountSemaphore;
    private final OlapBuilderTableExecutorPool builderTableExecutorPool;

    public OlapEngineComponent(Object lix, OlapEngineComponentConfiguration configuration, @Nullable IOlapBigBrotherMgr bigBrotherMgr, OlapRuntime runtime, OlapDirectories directories, OlapFunctionRepository functionRepository, OlapBuilderTableExecutorPool builderTableExecutorPool, boolean withMultiTenant) {
        this(lix, configuration, bigBrotherMgr, runtime, directories.asOlapEngineDirectories(), new OlapBuilderMetaInformationRepository(configuration.isJavaViewsActivated()), functionRepository, builderTableExecutorPool, withMultiTenant);
    }

    public OlapEngineComponent(Object lix, OlapEngineComponentConfiguration configuration, @Nullable IOlapBigBrotherMgr bigBrotherMgr, OlapRuntime runtime, OlapEngineDirectories directories, OlapBuilderMetaInformationRepository builderMetaInformationRepository, OlapFunctionRepository functionRepository, OlapBuilderTableExecutorPool builderTableExecutorPool, boolean withMultiTenant) {
        this.cleaner = OlapRuntime.isWindows() ? OlapWindowsFileCleaner.create(configuration) : OlapNopFileCleaner.INSTANCE;
        this.schemas.put("$IC3_NO_TENANT_KEY$", new OlapEngineSchemaManager(null, null, this.cleaner));
        this.lixContent = (OlapLixContent)lix;
        this.runtime = runtime;
        this.configuration = configuration;
        this.bigBrotherMgr = bigBrotherMgr;
        this.directories = directories;
        this.locale = OlapEngineComponent.setupLocale(configuration.getProperties());
        this.authenticationServiceClasses = new OlapAuthenticationServiceClasses();
        this.builderMetaInformationRepository = builderMetaInformationRepository;
        this.functionRepository = functionRepository;
        this.moduleMethodsRepository = new OlapModuleMethodsRepository();
        this.tableAggregatorRepository = new OlapTableAggregatorRepository();
        this.allPluginsInfo = new OlapEngineAllPluginsInfo(directories.getPluginsDirectory__());
        int maxActiveSchemaLoadCount = configuration.getProperties().getActiveLoadCount();
        this.activeSchemaLoadCountSemaphore = maxActiveSchemaLoadCount > 0 ? new Semaphore(maxActiveSchemaLoadCount, true) : null;
        this.builderTableExecutorPool = builderTableExecutorPool;
    }

    private static Locale setupLocale(OlapProperties properties) {
        CdLanguageIdentifier localeIdentifier = properties.getLocaleIdentifier();
        Locale locale = null;
        if (localeIdentifier == CdLanguageIdentifier.Neutral) {
            locale = Locale.getDefault();
        } else if (localeIdentifier == CdLanguageIdentifier.UserDefault) {
            locale = Locale.getDefault();
        } else if (localeIdentifier == CdLanguageIdentifier.SystemDefault) {
            locale = Locale.getDefault();
        } else {
            locale = CdLanguageIdentifierHelper.getJavaLocale((CdLanguageIdentifier)localeIdentifier);
            if (locale == null) {
                OlapLoggers.GENERAL.warn((Object)("Could not convert the LocaleIdentifier [" + String.valueOf(localeIdentifier) + "] to JAVA locale - reverting to JAVA default locale."));
                locale = Locale.getDefault();
            }
        }
        OlapLoggers.GENERAL.info((Object)("MDX engine locale [LocaleIdentifier:" + String.valueOf(localeIdentifier) + "] [JAVA:" + locale.toString() + "]"));
        return locale;
    }

    public void shutdownNow(boolean withAllocator) {
        OlapLoggers.GENERAL.info((Object)"olap-engine shutdown requested");
        this.builderTableExecutorPool.shutdownNow();
        this.cleaner.shutdownNow();
        OlapLoggers.GENERAL.info((Object)"olap-engine shutdown bye");
    }

    public CdVFileSystem getVfs() {
        return this.runtime.getVfs();
    }

    public Class<?> getAuthenticationServiceClass(String className) throws ClassNotFoundException {
        Class<?> service = this.authenticationServiceClasses.get(className);
        if (service != null) {
            return service;
        }
        return Class.forName(className);
    }

    @Nullable
    public IOlapBigBrotherMgr getBigBrotherMgr() {
        return this.bigBrotherMgr;
    }

    public OlapBuilderTableExecutorPool getBuilderTableExecutorPool() {
        return this.builderTableExecutorPool;
    }

    public OlapFileCleaner getCleaner() {
        return this.cleaner;
    }

    public OlapLixContent getLixContent() {
        return this.lixContent;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public OlapEngineComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    public File getTmpDirectory() {
        return this.directories.getTmpDirectory__();
    }

    public OlapEngineSchemaDefFactoryHelper getDeployedSchemaDefFactoryHelper(OlapRuntimeContext context) {
        return this.deployedSchemaDefFactoryHelper(context);
    }

    private OlapEngineSchemaDefFactoryHelper deployedSchemaDefFactoryHelper(OlapRuntimeContext context) {
        OlapEngineDirectoriesResolved directoriesR = context.getEngineDirectoriesResolved();
        return new OlapEngineFileSystemSchemaDefFactoryHelper(directoriesR.getVfs(), new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_CUBES, directoriesR.getTmpDirectory(), directoriesR.getCubesDirectory()), directoriesR.getCubesDirectory(), directoriesR.getOfflineDirectory(), this.builderMetaInformationRepository);
    }

    public OlapProperties getProperties() {
        return this.configuration.getProperties();
    }

    public OlapBuilderMetaInformationRepository getBuilderMetaInformationRepository() {
        return this.builderMetaInformationRepository;
    }

    public OlapFunctionRepository getFunctionRepository() {
        return this.functionRepository;
    }

    public OlapModuleMethodsRepository getModuleMethodsRepository() {
        return this.moduleMethodsRepository;
    }

    public OlapTableAggregatorRepository getTableAggregationRepository() {
        return this.tableAggregatorRepository;
    }

    public void onAllPluginsLoaded() {
        this.builderMetaInformationRepository.onAllPluginsLoaded();
    }

    public File getPluginsDirectory() {
        return this.allPluginsInfo.getPluginsDirectory();
    }

    public OlapEngineAllPluginsInfo getAllPluginsInfo() {
        return this.allPluginsInfo;
    }

    public void clearAllPlugins(String uuid) {
        this.allPluginsInfo.clear(uuid);
        this.builderMetaInformationRepository.reset();
        this.functionRepository.reset();
        this.moduleMethodsRepository.reset();
    }

    public void addAllPluginsLocations(List<File> pluginLocations) {
        this.allPluginsInfo.addAllPluginsLocations(pluginLocations);
    }

    public void addPluginContainer(String name, File pluginLocation, OlapConfPluginContainer pluginContainer) {
        this.allPluginsInfo.allPluginContainer(name, pluginLocation, pluginContainer);
    }

    public void addPluginDependency(File pluginLocation) {
        this.allPluginsInfo.addPluginDependency(pluginLocation);
    }

    public void addPluginInfo(OlapEnginePluginInfo plugin) {
        this.allPluginsInfo.addPlugin(plugin);
    }

    public void addPluginLocationErrors(File pluginLocation, List<? extends CdError> errors) {
        this.allPluginsInfo.addPluginLocationErrors(pluginLocation, errors);
    }

    @Nullable
    public Class<?> registerUserDefinedAuthenticationService(OlapConfAuthenticationServicePlugin service) {
        return service.register(this.authenticationServiceClasses);
    }

    public List<OlapFunction> registerUserDefinedFunction(OlapConfFunctionPlugin function) throws OlapConfigurationException {
        return function.register(this.functionRepository);
    }

    public void registerDataAggregator(OlapConfJavaTableAgrregatorPlugin aggregator) throws OlapConfigurationException {
        aggregator.register(this.tableAggregatorRepository);
    }

    public OlapModuleMethodCallInstrFactory registerModuleMethods(OlapConfMethodsPlugin methods) throws OlapConfigurationException {
        return methods.register(this.moduleMethodsRepository);
    }

    public Class registerUserDefinedBuilderClass(OlapConfBuilderPlugin builder) {
        return builder.register(this.builderMetaInformationRepository);
    }

    public Collection<OlapFunction> getAllFunctions() {
        return this.functionRepository.getAllFunctions();
    }

    public void foreachSchemaFactoryFile(OlapRuntimeContext context, IOlapSchemaFactoryFileAction action) {
        this.deployedSchemaDefFactoryHelper(context).foreachSchemaFactoryFile(null, action);
    }

    public void foreachSchemaFactoryInfo(OlapRuntimeContext context, IOlapSchemaFactoryInfoAction action) {
        this.deployedSchemaDefFactoryHelper(context).foreachSchemaFactoryInfo(action);
    }

    public List<File> retrieveRelativeSchemaFactoryFiles(OlapRuntimeContext context, int maxCount) {
        return this.deployedSchemaDefFactoryHelper(context).retrieveRelativeSchemaFactoryFiles(maxCount);
    }

    @Nullable
    public OlapSchemaFactoryInfo getSchemaFactoryInfo(OlapRuntimeContext context, File schemaFactoryFile) {
        if (schemaFactoryFile == null) {
            return null;
        }
        return this.deployedSchemaDefFactoryHelper(context).getFactoryInfo(schemaFactoryFile);
    }

    @Nullable
    public File getSchemaFactoryFile(OlapRuntimeContext context, String schema) {
        return this.deployedSchemaDefFactoryHelper(context).getFactoryFile(schema);
    }

    public IOlapBuilderSchemaDefFactory unmarshallXmlFactory(OlapRuntimeContext context, File schemaFactoryFile) throws OlapBuilderErrorException {
        return this.deployedSchemaDefFactoryHelper(context).unmarshallXmlFactory(schemaFactoryFile);
    }

    public File getOfflineSnapshotForWrite(OlapRuntimeContext context, @Nullable String snapshot, OlapSchema schema) {
        return this.deployedSchemaDefFactoryHelper(context).getOfflineSnapshotForWrite(snapshot, schema);
    }

    public List<String> getOfflineSnapshotNames(OlapRuntimeContext context, String schemaFactoryFileName) throws IOException {
        return this.deployedSchemaDefFactoryHelper(context).getOfflineSnapshotNames(schemaFactoryFileName);
    }

    public List<String> getAllOfflineSnapshotNames(OlapRuntimeContext context) throws IOException {
        return this.deployedSchemaDefFactoryHelper(context).getAllOfflineSnapshotNames();
    }

    public Map<File, List<OlapSnapshotFile>> getAllOfflineSnapshots(OlapRuntimeContext context) throws IOException {
        return this.deployedSchemaDefFactoryHelper(context).getAllOfflineSnapshots();
    }

    @Nullable
    public OlapSnapshotFile getOfflineSnapshot(OlapRuntimeContext context, String name) {
        return this.deployedSchemaDefFactoryHelper(context).getOfflineSnapshot(name);
    }

    @Nullable
    public String getSchemaName(OlapRuntimeContext context, File schemaFactoryFile) {
        return this.deployedSchemaDefFactoryHelper(context).getSchemaName(schemaFactoryFile);
    }

    public boolean isSchemaDeployed(OlapRuntimeContext context, String schemaName) {
        boolean[] deployed = new boolean[1];
        this.deployedSchemaDefFactoryHelper(context).foreachSchemaFactoryInfo(info -> {
            if (info.getName().equals(schemaName)) {
                deployed[0] = true;
                return false;
            }
            return true;
        });
        return deployed[0];
    }

    private OlapEngineSchemaManager getOrCreateSchemaManager(OlapRuntimeContext context) {
        return this.getOrCreateSchemaManager(context.getTenant());
    }

    private OlapEngineSchemaManager getOrCreateSchemaManager(@Nullable OlapTenant tenant) {
        if (tenant == null) {
            OlapEngineSchemaManager manager = this.schemas.get("$IC3_NO_TENANT_KEY$");
            if (manager == null) {
                throw new RuntimeException("internal error: missing schema manager.");
            }
            return manager;
        }
        OlapEngineSchemaManager manager = this.schemas.computeIfAbsent(tenant.getName(), tenantName -> new OlapEngineSchemaManager(tenant, this.globalSchemasListeners, this.cleaner));
        return manager;
    }

    public long getSchemasUuid(OlapRuntimeContext context) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getUuid();
    }

    public OlapSchemaFunctionRepositorySnapshot getAuthorizedSchemaFunctionRepositorySnapshot(OlapRuntimeContext context, OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        OlapSchemaFunctionRepositorySnapshot snapshot = schemas.getAuthorizedSchemaFunctionRepositorySnapshot(applicationPermissions, permissions, schema);
        if (snapshot != null) {
            return snapshot;
        }
        OlapSchemaFunctionRepository underlying = new OlapSchemaFunctionRepository(this.getFunctionRepository());
        return new OlapSchemaFunctionRepositorySnapshot(underlying);
    }

    public boolean hasAuthorizedSchema(OlapRuntimeContext context, OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.hasAuthorizedSchema(applicationPermissions, permissions, schema);
    }

    public boolean hasAuthorizedSchemaWithIncrementalActive(OlapRuntimeContext context, OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.hasAuthorizedSchemaWithIncrementalActive(applicationPermissions, permissions, schema);
    }

    @Nullable
    public OlapSchemaInfo getAuthorizedSchemaInfo(OlapEngineRequestContext context, OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, String schemaName) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context.asRuntimeContext());
        return schemas.getAuthorizedSchemaInfo(context, applicationPermissions, permissions, schemaName);
    }

    public List<OlapSchemaInfo> getAuthorizedSchemaInfos(Locale locale, OlapNameContext nameContext, OlapEngineRequestContext context, OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context.asRuntimeContext());
        return schemas.getAuthorizedSchemaInfos(locale, nameContext, context, applicationPermissions, permissions);
    }

    public List<String> getAllAuthorizedSchemaNames(OlapRuntimeContext context, OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getAllAuthorizedSchemaNames(applicationPermissions, permissions);
    }

    public CdTruncatedList<String> getAllAuthorizedSchemaNames(OlapRuntimeContext context, OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, int limit, @Nullable String query) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getAllAuthorizedSchemaNames(applicationPermissions, permissions, limit, query);
    }

    @Nullable
    public String getLoadedSchemaName(OlapRuntimeContext context, File schemaFactoryFile) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadedSchemaName(schemaFactoryFile);
    }

    @Nullable
    public IOlapBuilderSchemaDefFactory getLoadedSchemaFactory(OlapRuntimeContext context, String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadedSchemaFactory(schema);
    }

    public boolean isSchemaLoaded(OlapRuntimeContext context, String schemaName) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.isSchemaLoaded(schemaName);
    }

    public boolean isSchemaLoaded(OlapRuntimeContext context, File factory) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.isSchemaLoaded(factory);
    }

    public int getLoadedSchemaCount(OlapRuntimeContext context) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadedSchemaCount();
    }

    public double getLoadedSchemaMemory(OlapRuntimeContext context) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadedSchemaMemory();
    }

    @Nullable
    public OlapSchemaStats getLoadedSchemaStatistics(OlapRuntimeContext context, String schemaName) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadedSchemaStatistics(schemaName);
    }

    public List<OlapSchemaPartitionInformation> listSchemaPartitions(OlapEngineRequestContext requestContext, String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        return schemas.listSchemaPartitions(requestContext, schema);
    }

    public List<OlapSchemaInformationEx> listSchemaEx(OlapRuntimeContext context) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.listSchemaEx();
    }

    public List<OlapSchemaInformationEx> listSchema(OlapRuntimeContext context, @Nullable String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.listSchema(schema);
    }

    public List<OlapSchemaInformation> getAllSchemaInformation(OlapRuntimeContext context) {
        return this.getAllSchemaInformation(context, null);
    }

    public List<OlapSchemaInformation> getAllSchemaInformation(OlapRuntimeContext context, @Nullable String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getAllLoadedSchemaInformation(schema);
    }

    public List<OlapSchemaInformation> getAllLoadingSchemaInformation(OlapRuntimeContext context, boolean ignoredRestoring) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getAllLoadingSchemaInformation(ignoredRestoring);
    }

    @Nullable
    public OlapSchemaInformation getLoadedSchemaInformation(OlapRuntimeContext context, String schemaName) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadedSchemaInformation(schemaName);
    }

    @Nullable
    public OlapSchemaInformation getLoadingSchemaInformation(OlapRuntimeContext context, String schemaName) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadingSchemaInformation(schemaName);
    }

    @Nullable
    public OlapSchemaInformation getLoadingSchemaInformation(OlapRuntimeContext context, File schemaFactoryFile) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadingSchemaInformation(schemaFactoryFile);
    }

    @Nullable
    public OlapSchemaInformation getLoadedSchemaInformation(OlapRuntimeContext context, File schemaFactoryFile) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadedSchemaInformation(schemaFactoryFile);
    }

    public OlapSchemaInformationForTests getLoadedSchemaInformationForTests(OlapRuntimeContext context, String schemaName) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadingSchemaInformationForTests(schemaName);
    }

    public Map<String, List<? extends CdError>> getLoadedSchemaPermsErrors(OlapRuntimeContext context, String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getLoadedSchemaPermsErrors(schema);
    }

    @Nullable
    public String getOfflineSnapshot(OlapRuntimeContext context, File schemaFactoryFile) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getOfflineSnapshot(schemaFactoryFile);
    }

    public boolean isSchemaLoading(OlapRuntimeContext context, String schemaName) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.isSchemaLoading(schemaName);
    }

    public boolean isSchemaLoading(OlapRuntimeContext context, File factory) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.isSchemaLoading(factory);
    }

    @Nullable
    public String getSchemaLoadRequestUuid(OlapRuntimeContext context, String schemaName) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getSchemaLoadRequestUuid(schemaName);
    }

    @Nullable
    public String getSchemaLoadingRequestUuid(OlapRuntimeContext context, String schemaName) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(context);
        return schemas.getSchemaLoadingRequestUuid(schemaName);
    }

    public void addStructuralSchemaLifeCycleListener(IOlapEngineSchemaLifeCycleListener listener) {
        for (OlapEngineSchemaManager manager : this.schemas.values()) {
            manager.addSchemaLifeCycleListener(listener);
        }
        this.globalSchemasListeners.add(IOlapEngineSchemaLifeCycleListener.class, listener);
    }

    public void addSchemaLifeCycleListener(@Nullable OlapTenant tenant, IOlapEngineSchemaLifeCycleListener listener) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(tenant);
        schemas.addSchemaLifeCycleListener(listener);
    }

    public void addSchemaDataUpdatedListener(@Nullable OlapTenant tenant, IOlapEngineSchemaDataUpdatedListener listener) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(tenant);
        schemas.addSchemaDataUpdatedListener(listener);
    }

    public void removeSchemaDataUpdatedListener(@Nullable OlapTenant tenant, IOlapEngineSchemaDataUpdatedListener listener) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(tenant);
        schemas.removeSchemaDataUpdatedListener(listener);
    }

    public OlapSchemaLoadingToken getSchemaLoadToken(OlapEngineRequestContext requestContext, OlapRequestInfo requestInfo, String schema) throws InterruptedException {
        IcCubeRequestStatusManager requestStatusManager = requestContext.getRequestStatusManager();
        int timeoutS = requestContext.getLoadTimeoutS();
        if (requestStatusManager.setRequestTimeout(requestContext.getRequestClientUUID(), timeoutS)) {
            OlapRequestTracker.onRequestWithTimeout(requestContext, timeoutS);
        }
        if (this.activeSchemaLoadCountSemaphore == null) {
            return new OlapSchemaLoadingToken(schema);
        }
        OlapRequestTracker.onLoadSchemaAcquireTokenStarted(requestInfo, this.activeSchemaLoadCountSemaphore, schema);
        while (true) {
            try {
                this.activeSchemaLoadCountSemaphore.acquire();
                OlapSchemaLoadingToken olapSchemaLoadingToken = new OlapSchemaLoadingToken(schema);
                return olapSchemaLoadingToken;
            }
            catch (InterruptedException interruptedException) {
                if (!requestContext.isCancelling()) continue;
                throw new InterruptedException("interrupted-waiting-load");
            }
            break;
        }
        finally {
            OlapRequestTracker.onLoadSchemaAcquireTokenDone(requestInfo, this.activeSchemaLoadCountSemaphore, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSchemaLoadToken(OlapEngineRequestContext requestContext, OlapRequestInfo requestInfo, OlapSchemaLoadingToken token) {
        if (this.activeSchemaLoadCountSemaphore == null) {
            return;
        }
        OlapRequestTracker.onLoadSchemaReleaseTokenStarted(requestInfo, this.activeSchemaLoadCountSemaphore, token.getSchema());
        try {
            if (token.released()) {
                OlapLoggers.BUILDER.warn((Object)("schema load token inconsistency for schema [" + token.getSchema() + "] : multiple release"));
                return;
            }
            this.activeSchemaLoadCountSemaphore.release();
            token.release();
        }
        finally {
            OlapRequestTracker.onLoadSchemaReleaseTokenDone(requestInfo, this.activeSchemaLoadCountSemaphore, token.getSchema());
        }
    }

    public OlapSchemaLoadingLock onSchemaLoadingStarted(OlapEngineRequestContext requestContext, OlapSchemaInformation schemaInformation) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        OlapSchemaLoadingLock res = schemas.onSchemaLoadingStarted(requestContext, schemaInformation);
        return res;
    }

    public boolean onSchemaLoadingDone(OlapEngineRequestContext requestContext, OlapSchemaLoadingLock lock) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        boolean res = schemas.onSchemaLoadingDone(requestContext, lock);
        return res;
    }

    public void loadSchemaStartedPhaseI(OlapEngineRequestContext requestContext, OlapSchema schema, String command) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.loadSchemaStartedPhaseI(requestContext, schema, command);
    }

    public void loadSchemaStartedPhaseII(OlapEngineRequestContext requestContext, OlapSchema schema, String command) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.loadSchemaStartedPhaseII(requestContext, schema, command);
    }

    public void addSchema(OlapEngineRequestContext requestContext, OlapSchema schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.addSchema(requestContext, schema);
    }

    public void incrLoadSchema(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.incrLoadSchema(requestContext, schema, incrLoadInfo);
    }

    public void loadSchemaOnError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.loadSchemaOnError(requestContext, schema);
    }

    public void loadSchemaOnErrorCleanup(OlapEngineRequestContext requestContext, OlapSchema schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.loadSchemaOnErrorCleanup(requestContext, schema);
    }

    public void loadSchemaDone(OlapEngineRequestContext requestContext, OlapSchema schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.loadSchemaDone(requestContext, schema);
    }

    public void incrLoadSchemaOnError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.incrLoadSchemaOnError(requestContext, schema);
    }

    public void scriptStatementApplied(OlapEngineRequestContext requestContext, OlapSchema schema, OlapScriptInformation information) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.scriptStatementApplied(requestContext, schema, information);
    }

    public boolean unloadSchema(OlapEngineRequestContext requestContext, String name) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        return schemas.unloadSchema(requestContext, name);
    }

    public void unloadPartitions(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.unloadPartitions(requestContext, schema, unloadPartitionsInfo);
    }

    public void loadPartitions(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.loadPartitions(requestContext, schema, loadPartitionsInfo);
    }

    public void loadPartitionsError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        schemas.loadPartitionsError(requestContext, schema);
    }

    public String dumpSchemaIndex(OlapEngineRequestContext requestContext, String name) throws IOException {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        return schemas.dumpSchemaIndex(requestContext, name);
    }

    @Nullable
    public OlapSchemaStats refreshSchemaStatistics(OlapEngineRequestContext requestContext, String name) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        return schemas.refreshSchemaStatistics(requestContext, name);
    }

    @Nullable
    public OlapSchemaDataUpdate getSchemaNullableLastDataUpdate(OlapEngineRequestContext requestContext, String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        return schemas.getSchemaNullableLastDataUpdate(requestContext, schema);
    }

    public long getSchemaLastDataUpdatedTime(OlapEngineRequestContext requestContext, String schema) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        return schemas.getSchemaLastDataUpdatedTime(requestContext, schema);
    }

    public List<OlapSchema> getAllAuthorizedSchemas(OlapEngineRequestContext requestContext, IcCubeSchemaAccessLockMode mode) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        return schemas.getAllAuthorizedSchemas(requestContext, mode);
    }

    @Nullable
    public OlapSchema getAuthorizedSchema(OlapEngineRequestContext requestContext, IcCubeSchemaAccessLockMode mode, String name) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        return schemas.getAuthorizedSchema(requestContext, null, mode, name);
    }

    @Nullable
    public OlapSchema getAuthorizedSchema(OlapEngineRequestContext requestContext, @Nullable IOlapSchemasPermission permissions, IcCubeSchemaAccessLockMode mode, String name) {
        OlapEngineSchemaManager schemas = this.getOrCreateSchemaManager(requestContext.asRuntimeContext());
        return schemas.getAuthorizedSchema(requestContext, permissions, mode, name);
    }

    @Nullable
    public List<OlapBuilderBaseDataSource<?>> getAuthorizedDataSources(OlapEngineRequestContext requestContext, IcCubeSchemaAccessLockMode mode, String schemaName) throws OlapMissingSchemaException {
        OlapSchema schema = this.getAuthorizedSchema(requestContext, mode, schemaName);
        if (schema == null) {
            throw new OlapMissingSchemaException(schemaName);
        }
        IOlapSchemasPermission schemasPermissions = requestContext.getSchemasPermissions();
        IOlapSchemaPermission permissions = schemasPermissions.getSchemaPermissions(requestContext, schema, true);
        return schema.getReportingDataSources(permissions);
    }

    @Nullable
    public List<OlapCube> getAuthorizedCubes(OlapEngineRequestContext requestContext, IcCubeSchemaAccessLockMode mode, String schemaName) throws OlapMissingSchemaException {
        OlapSchema schema = this.getAuthorizedSchema(requestContext, mode, schemaName);
        if (schema == null) {
            throw new OlapMissingSchemaException(schemaName);
        }
        IOlapSchemasPermission schemasPermissions = requestContext.getSchemasPermissions();
        IOlapSchemaPermission permissions = schemasPermissions.getSchemaPermissions(requestContext, schema, true);
        return schema.getCubes(permissions);
    }

    @Nullable
    public OlapCube getAuthorizedCube(OlapEngineRequestContext requestContext, IcCubeSchemaAccessLockMode mode, String schemaName, @Nullable String cubeName) throws OlapMissingSchemaException {
        OlapSchema schema = this.getAuthorizedSchema(requestContext, mode, schemaName);
        OlapRequestNamesContext nameContext = requestContext.getNameContext();
        if (schema == null) {
            throw new OlapMissingSchemaException(schemaName);
        }
        IOlapSchemasPermission schemasPermissions = requestContext.getSchemasPermissions();
        IOlapSchemaPermission permissions = schemasPermissions.getSchemaPermissions(requestContext, schema, true);
        return schema.lookupCubeByName(permissions, nameContext, cubeName);
    }

    public void upgradeToRealTime() {
        for (OlapEngineSchemaManager schema : this.schemas.values()) {
            schema.upgradeToRealTime();
        }
    }

    public boolean isJavaViewActivated() {
        return this.configuration.isJavaViewsActivated();
    }

    public boolean isJavaMdxNativesActivated() {
        return this.configuration.isJavaMdxNativesActivated();
    }

    public void onSchemasPermissionsDeleted(List<IOlapSchemasPermission> schemasPermissions) {
        for (OlapEngineSchemaManager manager : this.schemas.values()) {
            manager.onSchemasPermissionsDeleted(schemasPermissions);
        }
    }
}

