/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler.ast.select;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.token.CdMdxStringToken;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectAxisName;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCalcMember;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryHierarchy;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryMember;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCellPropertyListClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectDimensionPropertyListClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectExtraAxisClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectExtraAxisClauses;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFilterByClauses;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMeasure;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectNamedSet;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectQueryAxisClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectQueryInfo;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectSlicerAxisClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectStatementExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectTidyPostProcessorClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectTidyPostProcessorClauses;
import crazydev.iccube.mdx.parser.ast.statement.MdxStatementExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.ast.select.MdxCreateCalcMemberExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.select.MdxCreateCategoryExpressionCompilerHelper;
import crazydev.iccube.olap.compiler.ast.select.MdxCreateFunctionExpressionCompiler;
import crazydev.iccube.olap.compiler.ast.select.MdxCreateMeasureExpressionCompiler;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.entity.catmember.OlapCategoryHierarchyProperties;
import crazydev.iccube.olap.entity.catmember.OlapCategoryMemberProperties;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierNamePart;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyManager;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.result.OlapResAxisName;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapSingleArgFunctionCallInstr;
import crazydev.iccube.olap.eval.id.OlapIdentifierInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.OlapBaseSubSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateCalcMemberSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateCategoryHierarchySelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateCategoryMemberSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateFunctionSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateMeasureSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateSetSelectInstr;
import crazydev.iccube.olap.eval.select.OlapSlicerInstr;
import crazydev.iccube.olap.eval.select.OlapSubSelectInstr;
import crazydev.iccube.olap.eval.select.OlapSubSubSelectInstr;
import crazydev.iccube.olap.eval.select.OlapTopLevelSelectInstr;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessor;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessorInstr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxSelectQueryCompiler
extends MdxEntityCompiler<MdxSelectStatementExpression> {
    private static OlapAxisInstr[] compileAxes(OlapCompilationContext context, MdxSelectStatementExpression mdx, boolean inSubSelect) {
        List<MdxSelectQueryAxisClause> exprs = MdxSelectQueryCompiler.fixQueryAxisClauses(mdx);
        OlapAxisInstr[] instrs = new OlapAxisInstr[exprs.size()];
        for (int idx = 0; idx < exprs.size(); ++idx) {
            OlapAxisInstr instr;
            MdxSelectQueryAxisClause expr = exprs.get(idx);
            instrs[idx] = instr = MdxSelectQueryCompiler.compileAxis(context, expr, inSubSelect);
        }
        MdxSelectQueryCompiler.assertAxisSequence(context, instrs);
        return instrs;
    }

    private static void assertAxisSequence(OlapCompilationContext context, OlapAxisInstr[] axes) {
        int idx;
        if (axes.length == 0) {
            return;
        }
        ArrayList<OlapAxisInstr> sorted = new ArrayList<OlapAxisInstr>();
        boolean hasAxes = false;
        for (int idx2 = 0; idx2 < axes.length; ++idx2) {
            OlapAxisInstr axisInstr = axes[idx2];
            OlapResAxisName axisName = axisInstr.getName();
            if (axisName.isAxes()) {
                hasAxes = true;
            }
            sorted.add(axisInstr);
        }
        if (hasAxes) {
            if (axes.length > 1) {
                throw new OlapCompilationException(context, OlapErrorCode.AXES_USAGE_ERROR, new Serializable[0]);
            }
            return;
        }
        Collections.sort(sorted, new Comparator<OlapAxisInstr>(){

            @Override
            public int compare(OlapAxisInstr o1, OlapAxisInstr o2) {
                long anotherVal;
                long thisVal = o1.getName().getNumber();
                return thisVal < (anotherVal = o2.getName().getNumber()) ? -1 : (thisVal == anotherVal ? 0 : 1);
            }
        });
        OlapAxisInstr firstAxis = (OlapAxisInstr)sorted.get(0);
        long prev = firstAxis.getName().getNumber();
        if (prev != 0L) {
            context.pushCurrentMdxEntity(firstAxis.getMdxEntity().getAxisName());
            throw new OlapCompilationException(context, OlapErrorCode.AXIS_SELECT_SEQUENCE_ERROR, new Serializable[]{firstAxis.getName().toString(), "Columns(0)"});
        }
        for (idx = 1; idx < sorted.size(); ++idx) {
            long expectedNumber;
            OlapAxisInstr axis = (OlapAxisInstr)sorted.get(idx);
            long actualNumber = axis.getName().getNumber();
            if (actualNumber != (expectedNumber = prev + 1L)) {
                context.pushCurrentMdxEntity(axis.getMdxEntity().getAxisName());
                throw new OlapCompilationException(context, OlapErrorCode.AXIS_SELECT_SEQUENCE_ERROR, new Serializable[]{axis.getName().toString(), new OlapResAxisName(expectedNumber).toString()});
            }
            prev = actualNumber;
        }
        for (idx = 0; idx < sorted.size(); ++idx) {
            axes[idx] = (OlapAxisInstr)sorted.get(idx);
        }
    }

    private static OlapAxisInstr compileAxis(OlapCompilationContext context, MdxSelectQueryAxisClause expr, boolean inSubSelect) {
        OlapResAxisName name = MdxSelectQueryCompiler.compileAxisName(context, expr.getAxisName());
        OlapInstr instr = MdxSelectQueryCompiler.compileAxisExpression(context, name, expr.getExpression(), inSubSelect);
        MdxSelectDimensionPropertyListClause dp = expr.getDimensionPropertyListClause();
        if (dp != null && dp.isAllMemberProperties()) {
            return new OlapAxisInstr(expr, MdxSelectQueryCompiler.createRange(expr), name, expr.isNonEmpty(), instr, true);
        }
        List<OlapEntityIdentifier> dimProperties = MdxSelectQueryCompiler.compileDimensionProperties(context, dp);
        return new OlapAxisInstr(expr, MdxSelectQueryCompiler.createRange(expr), name, expr.isNonEmpty(), instr, dimProperties);
    }

    private static OlapInstr compileAxisExpression(OlapCompilationContext context, OlapResAxisName name, MdxExpression expression, boolean inSubSelect) {
        OlapFunction compactSet;
        Object exprInstr = context.compile(expression);
        if (inSubSelect && context.isCompactSetInSubSelect() && !((OlapInstr)exprInstr).isSubCubeXyz() && (compactSet = context.lookupRegularFunction("CompactSet")) != null) {
            exprInstr = new OlapSingleArgFunctionCallInstr(((OlapInstr)exprInstr).getLocationRange(), OlapFunctionCallInstr.Notation.FUNCTION_REGULAR, compactSet, (OlapInstr)exprInstr);
        }
        if (context.isVisualTotals()) {
            OlapFunction visualTotals = context.lookupExistingRegularFunction("VisualTotals");
            exprInstr = new OlapSingleArgFunctionCallInstr(((OlapInstr)exprInstr).getLocationRange(), OlapFunctionCallInstr.Notation.FUNCTION_REGULAR, visualTotals, (OlapInstr)exprInstr);
        }
        return exprInstr;
    }

    private static List<OlapEntityIdentifier> compileDimensionProperties(OlapCompilationContext context, @Nullable MdxSelectDimensionPropertyListClause expr) {
        ArrayList<OlapEntityIdentifier> dimProperties = new ArrayList<OlapEntityIdentifier>();
        if (expr != null) {
            List<MdxIdentifierExpression> ids = expr.getProperties();
            for (MdxIdentifierExpression id : ids) {
                OlapEntityIdentifier property = MdxSelectQueryCompiler.createOlapIdentifier(id);
                dimProperties.add(property);
            }
        }
        return dimProperties;
    }

    private static OlapResAxisName compileAxisName(OlapCompilationContext context, MdxSelectAxisName name) {
        String role = name.getRole();
        if (role != null) {
            return new OlapResAxisName(role, name.getNumber());
        }
        CdMdxToken builtin = name.getBuiltin();
        if (builtin == null) {
            return new OlapResAxisName(name.getNumber());
        }
        switch (builtin.getKind()) {
            case AXES: {
                return new OlapResAxisName(OlapResAxisName.Builtin.Axes);
            }
            case COLUMNS: {
                return new OlapResAxisName(OlapResAxisName.Builtin.Columns);
            }
            case ROWS: {
                return new OlapResAxisName(OlapResAxisName.Builtin.Rows);
            }
            case PAGES: {
                return new OlapResAxisName(OlapResAxisName.Builtin.Pages);
            }
            case CHAPTERS: {
                return new OlapResAxisName(OlapResAxisName.Builtin.Chapters);
            }
            case SECTIONS: {
                return new OlapResAxisName(OlapResAxisName.Builtin.Sections);
            }
        }
        throw new CdProgrammingException("Invalid axis name token [" + String.valueOf(name) + "]");
    }

    private static List<OlapCellProperty> compileCellProperties(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        ArrayList<OlapCellProperty> properties = new ArrayList<OlapCellProperty>();
        MdxSelectCellPropertyListClause clause = mdx.getCellPropertyListClause();
        if (clause != null) {
            for (MdxIdentifierExpression expression : clause.getProperties()) {
                OlapIdentifierInstr instr = (OlapIdentifierInstr)context.compile(expression);
                OlapEntityIdentifier id = instr.getId();
                if (id.isKey() || id.getPartCount() != 1) {
                    throw new CdProgrammingException("Cell property name format '" + id.asString() + "' not supported");
                }
                OlapEntityIdentifierNamePart name = (OlapEntityIdentifierNamePart)id.getFirstPart();
                String pname = name.getName();
                OlapCellProperty property = OlapCellPropertyManager.getProperty(pname);
                if (property == null) {
                    throw new OlapCompilationException(context, OlapErrorCode.CELL_PROPERTY_UNKNOWN, new Serializable[]{pname});
                }
                properties.add(property);
            }
        } else {
            List<OlapCellProperty> props = context.getMdxDefaultRequestedCellProperties();
            if (props != null) {
                properties.addAll(props);
            } else {
                properties.addAll(OlapIntrinsicCellProperties.DEFAULT);
            }
        }
        return properties;
    }

    private static List<MdxSelectQueryAxisClause> fixQueryAxisClauses(MdxSelectStatementExpression mdx) {
        List<MdxSelectQueryAxisClause> queryAxisClauses = mdx.getQueryAxisClauses();
        MdxSelectExtraAxisClauses extraAxisClauses = mdx.getExtraAxisClauses();
        if (extraAxisClauses == null || extraAxisClauses.isEmpty()) {
            return queryAxisClauses;
        }
        ArrayList<MdxSelectQueryAxisClause> queryAxisClauses_ = new ArrayList<MdxSelectQueryAxisClause>(queryAxisClauses);
        for (MdxSelectExtraAxisClause extraAxisClause : extraAxisClauses.getClauses()) {
            int idx = MdxSelectQueryCompiler.overridingAxis(queryAxisClauses_, extraAxisClause);
            if (idx > -1) {
                MdxSelectQueryAxisClause existingAxisClause = (MdxSelectQueryAxisClause)queryAxisClauses_.get(idx);
                MdxSelectAxisName existingAxisName = existingAxisClause.getAxisName();
                CdMdxStringToken existingAxisNameRole = existingAxisName.getRoleToken();
                if (existingAxisNameRole != null) {
                    MdxSelectAxisName extraAxisName = extraAxisClause.getAxisName();
                    extraAxisName.setRoleToken(existingAxisNameRole);
                }
                queryAxisClauses_.set(idx, extraAxisClause);
                continue;
            }
            queryAxisClauses_.add(extraAxisClause);
        }
        return queryAxisClauses_;
    }

    private static int overridingAxis(List<MdxSelectQueryAxisClause> queryAxisClauses, MdxSelectExtraAxisClause extraAxisClause) {
        for (int ii = 0; ii < queryAxisClauses.size(); ++ii) {
            MdxSelectAxisName extraAxisClauseName;
            MdxSelectQueryAxisClause queryAxisClause = queryAxisClauses.get(ii);
            MdxSelectAxisName queryAxisClauseName = queryAxisClause.getAxisName();
            if (!queryAxisClauseName.isOverriddenBy(extraAxisClauseName = extraAxisClause.getAxisName())) continue;
            return ii;
        }
        return -1;
    }

    @Nullable
    private static List<OlapTidyPostProcessorInstr> compileTidyPostProcessors(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        MdxSelectTidyPostProcessorClauses tppClauses = mdx.getTidyPostProcessorClauses();
        if (tppClauses == null) {
            return null;
        }
        List<MdxSelectTidyPostProcessorClause> clauses = tppClauses.getClauses();
        if (clauses.isEmpty()) {
            return null;
        }
        ArrayList<OlapTidyPostProcessorInstr> processors = new ArrayList<OlapTidyPostProcessorInstr>();
        for (int cc = 0; cc < clauses.size(); ++cc) {
            MdxSelectTidyPostProcessorClause clause = clauses.get(cc);
            OlapInstrLocationRange range = MdxSelectQueryCompiler.createRange(clause);
            String name = clause.getName();
            OlapTidyPostProcessor processor = context.getTidyPostProcessor(name);
            if (processor == null) {
                throw new OlapCompilationException(context, OlapErrorCode.TIDY_POST_PROCESSOR_UNKNOWN, new Serializable[]{name});
            }
            boolean addToResult = clause.isAddToResult();
            List<MdxFunctionArgExpression> args = clause.getArgs();
            OlapTidyPostProcessorInstr instr = processor.create(context, range, cc, addToResult, args);
            processors.add(instr);
        }
        return processors;
    }

    public OlapTopLevelSelectInstr doCompile(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        OlapCreateFunctionSelectInstr[] declaredFunctions = this.compileDeclaredFunctions(context, mdx);
        OlapInstr cube = this.compileCube(context, mdx);
        MdxAnnotation[] annotations = this.compileAnnotations(context, mdx);
        OlapCreateMeasureSelectInstr[] measures = this.compileMeasures(context, mdx);
        OlapCreateCalcMemberSelectInstr[] cmembers = this.compileCalculatedMembers(context, mdx);
        OlapCreateSetSelectInstr[] namedSets = this.compileNamedSets(context, mdx);
        OlapCreateCategoryHierarchySelectInstr[] categoryHierarchies = this.compileCategoryHierarchies(context, mdx);
        OlapCreateCategoryMemberSelectInstr[] categoryMembers = this.compileCategoryMembers(context, mdx);
        OlapAxisInstr[] axes = MdxSelectQueryCompiler.compileAxes(context, mdx, false);
        OlapSlicerInstr slicer = this.compileSlicer(context, mdx);
        List<OlapCellProperty> cellProperties = MdxSelectQueryCompiler.compileCellProperties(context, mdx);
        List<OlapTidyPostProcessorInstr> tidyPostProcessors = MdxSelectQueryCompiler.compileTidyPostProcessors(context, mdx);
        MdxSelectQueryInfo queryInfo = new MdxSelectQueryInfo(mdx.getQueryAxisClausesCount());
        OlapTopLevelSelectInstr topLevelSelect = new OlapTopLevelSelectInstr(queryInfo, MdxSelectQueryCompiler.createRange(mdx), cube, annotations, declaredFunctions, namedSets, categoryHierarchies, categoryMembers, cmembers, measures, axes, slicer, cellProperties, tidyPostProcessors);
        return topLevelSelect;
    }

    private MdxAnnotation[] compileAnnotations(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        List<MdxAnnotation> mdxAnnotations = mdx.getAnnotations();
        if (mdxAnnotations == null || mdxAnnotations.isEmpty()) {
            return new MdxAnnotation[0];
        }
        return mdxAnnotations.toArray(new MdxAnnotation[mdxAnnotations.size()]);
    }

    private OlapInstr compileCube(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        MdxSelectFilterByClauses filterBy = mdx.getFilterByClauses();
        if (filterBy == null || filterBy.isEmpty()) {
            return this.compileCubeWithNoFilterBy(context, mdx);
        }
        return this.compileCubeWithFilterBy(context, mdx);
    }

    private OlapInstr compileCubeWithNoFilterBy(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        MdxExpression subSelectClause = mdx.getSubSelectClause();
        if (subSelectClause instanceof MdxIdentifierExpression) {
            return this.compileCubeFromName(context, mdx, (MdxIdentifierExpression)subSelectClause);
        }
        if (subSelectClause instanceof MdxStatementExpression) {
            return this.compileCubeFromSubSelect(context, (MdxSelectStatementExpression)subSelectClause);
        }
        throw new CdProgrammingException("Invalid cube expression class [" + subSelectClause.getClass().getName() + "]");
    }

    private OlapInstr compileCubeWithFilterBy(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        MdxSelectFilterByClauses filterBy = mdx.getFilterByClauses();
        MdxExpression subSelectClause = mdx.getSubSelectClause();
        if (subSelectClause instanceof MdxIdentifierExpression) {
            MdxSelectStatementExpression filterByAsSubSelect = filterBy.asSubSelect((MdxIdentifierExpression)subSelectClause);
            return this.compileCubeFromSubSelect(context, filterByAsSubSelect);
        }
        if (subSelectClause instanceof MdxStatementExpression) {
            MdxSelectStatementExpression mergedSubSelect = filterBy.mergeWithSubSelect((MdxSelectStatementExpression)subSelectClause);
            return this.compileCubeFromSubSelect(context, mergedSubSelect);
        }
        throw new CdProgrammingException("Invalid cube expression class [" + subSelectClause.getClass().getName() + "]");
    }

    private OlapIdentifierInstr compileCubeFromName(OlapCompilationContext context, MdxStatementExpression mdxExpression, MdxIdentifierExpression subCubeExpr) {
        if (subCubeExpr.getPartCount() != 1) {
            throw new CdProgrammingException("Invalid cube identifier '" + subCubeExpr.asMdx() + "'");
        }
        return new OlapIdentifierInstr(MdxSelectQueryCompiler.createRange(subCubeExpr), MdxSelectQueryCompiler.createOlapIdentifier(subCubeExpr));
    }

    private OlapBaseSubSelectInstr compileCubeFromSubSelect(OlapCompilationContext context, MdxSelectStatementExpression subSelectQuery) {
        OlapInstr cube = this.compileCube(context, subSelectQuery);
        OlapAxisInstr[] axes = MdxSelectQueryCompiler.compileAxes(context, subSelectQuery, true);
        OlapSlicerInstr slicer = this.compileSlicer(context, subSelectQuery);
        if (cube instanceof OlapBaseSubSelectInstr) {
            return new OlapSubSubSelectInstr(this.compileAnnotations(context, subSelectQuery), MdxSelectQueryCompiler.createRange(subSelectQuery), (OlapBaseSubSelectInstr)cube, subSelectQuery.isNonVisual(), axes);
        }
        return new OlapSubSelectInstr(this.compileAnnotations(context, subSelectQuery), MdxSelectQueryCompiler.createRange(subSelectQuery), (OlapIdentifierInstr)cube, subSelectQuery.isNonVisual(), axes, slicer);
    }

    private OlapCreateSetSelectInstr[] compileNamedSets(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        List<MdxSelectNamedSet> clauses = mdx.getNamedSetWithClauses();
        if (clauses == null || clauses.isEmpty()) {
            return new OlapCreateSetSelectInstr[0];
        }
        OlapCreateSetSelectInstr[] namedSets = new OlapCreateSetSelectInstr[clauses.size()];
        for (int idx = 0; idx < namedSets.length; ++idx) {
            namedSets[idx] = this.compileNamedSet(context, clauses.get(idx));
        }
        return namedSets;
    }

    private OlapCreateSetSelectInstr compileNamedSet(OlapCompilationContext context, MdxSelectNamedSet namedSet) {
        return (OlapCreateSetSelectInstr)context.compile(namedSet);
    }

    private OlapCreateCategoryHierarchySelectInstr[] compileCategoryHierarchies(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        List<MdxSelectCategoryHierarchy> clauses = mdx.getCategoryHierarchyWithClauses();
        if (clauses == null || clauses.isEmpty()) {
            return new OlapCreateCategoryHierarchySelectInstr[0];
        }
        OlapCreateCategoryHierarchySelectInstr[] instrs = new OlapCreateCategoryHierarchySelectInstr[clauses.size()];
        for (int idx = 0; idx < instrs.length; ++idx) {
            MdxSelectCategoryHierarchy clause = clauses.get(idx);
            OlapInstrLocationRange idRange = MdxSelectQueryCompiler.createRange(clause.getId());
            OlapInstrLocationRange range = MdxSelectQueryCompiler.createRange(clause);
            OlapEntityIdentifier id = MdxSelectQueryCompiler.createOlapIdentifier(clause.getId());
            OlapCategoryHierarchyProperties properties = MdxCreateCategoryExpressionCompilerHelper.compileHierarchyProperties(context, id.asString(), clause.getProperties());
            instrs[idx] = new OlapCreateCategoryHierarchySelectInstr(idRange, range, id, properties);
        }
        return instrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapCreateCategoryMemberSelectInstr[] compileCategoryMembers(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        List<MdxSelectCategoryMember> clauses = mdx.getCategoryMemberWithClauses();
        if (clauses == null || clauses.isEmpty()) {
            return new OlapCreateCategoryMemberSelectInstr[0];
        }
        OlapCreateCategoryMemberSelectInstr[] instrs = new OlapCreateCategoryMemberSelectInstr[clauses.size()];
        for (int idx = 0; idx < instrs.length; ++idx) {
            MdxSelectCategoryMember clause = clauses.get(idx);
            context.pushCurrentMdxEntity(clause);
            try {
                OlapInstrLocationRange idRange = MdxSelectQueryCompiler.createRange(clause.getId());
                OlapInstrLocationRange range = MdxSelectQueryCompiler.createRange(clause);
                OlapEntityIdentifier id = MdxSelectQueryCompiler.createOlapIdentifier(clause.getId());
                boolean dynamicEvaluation = clause.isDynamicEvaluation();
                Object formula = context.compile(clause.getFormula());
                boolean calculated = clause.isCalculated();
                OlapCategoryMemberProperties properties = MdxCreateCategoryExpressionCompilerHelper.compileMemberProperties(context, id.asString(), clause.getProperties());
                if (calculated && properties.addChildren()) {
                    throw new OlapCompilationException(context, OlapErrorCode.CAT_CALC_WITH_CHILDREN, new Serializable[]{id.asString()});
                }
                instrs[idx] = new OlapCreateCategoryMemberSelectInstr(idRange, range, id, dynamicEvaluation, calculated, (OlapInstr)formula, properties);
                continue;
            }
            finally {
                context.popCurrentMdxEntity();
            }
        }
        return instrs;
    }

    private OlapCreateFunctionSelectInstr[] compileDeclaredFunctions(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        MdxCreateFunctionExpressionCompiler compiler = new MdxCreateFunctionExpressionCompiler();
        return compiler.compile(context, mdx.getFunctionWithClauses());
    }

    private OlapCreateMeasureSelectInstr[] compileMeasures(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        List<MdxSelectMeasure> clauses = mdx.getMeasureWithClauses();
        if (clauses == null || clauses.isEmpty()) {
            return new OlapCreateMeasureSelectInstr[0];
        }
        OlapCreateMeasureSelectInstr[] measures = new OlapCreateMeasureSelectInstr[clauses.size()];
        MdxCreateMeasureExpressionCompiler compiler = new MdxCreateMeasureExpressionCompiler();
        for (int idx = 0; idx < measures.length; ++idx) {
            measures[idx] = (OlapCreateMeasureSelectInstr)compiler.compile(context, clauses.get(idx));
        }
        return measures;
    }

    private OlapCreateCalcMemberSelectInstr[] compileCalculatedMembers(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        List<MdxSelectCalcMember> clauses = mdx.getCalcMembersWithClauses();
        if (clauses == null || clauses.isEmpty()) {
            return new OlapCreateCalcMemberSelectInstr[0];
        }
        OlapCreateCalcMemberSelectInstr[] cmembers = new OlapCreateCalcMemberSelectInstr[clauses.size()];
        MdxCreateCalcMemberExpressionCompiler compiler = new MdxCreateCalcMemberExpressionCompiler();
        for (int idx = 0; idx < cmembers.length; ++idx) {
            cmembers[idx] = (OlapCreateCalcMemberSelectInstr)compiler.compile(context, clauses.get(idx));
        }
        return cmembers;
    }

    @Nullable
    private OlapSlicerInstr compileSlicer(OlapCompilationContext context, MdxSelectStatementExpression mdx) {
        MdxSelectSlicerAxisClause mdxSlicer = mdx.getSlicerAxisClause();
        if (mdxSlicer == null) {
            return null;
        }
        Object instr = context.compile(mdxSlicer.getExpr());
        return new OlapSlicerInstr(MdxSelectQueryCompiler.createRange(mdxSlicer), (OlapInstr)instr);
    }
}

