/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler.ast.select;

import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxStringToken;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNameExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxAggrTypeExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxCubeExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxFalseLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxLongLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxStringLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxTrueLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.operator.MdxUnaryOperatorCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.set.MdxSetExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMemberProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMemberProperty;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.compiler.exception.OlapCompilationExceptionContext;
import crazydev.iccube.olap.entity.cmember.OlapScopeIsolation;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyManager;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapFormatStringName;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class MdxCreateXyzExpressionPropertiesCompilerHelper {
    private static final Map<String, OlapFormatStringName> FORMAT_STRING_NAMES = new CdCaseInsensitiveHashMap();

    public static OlapCellProperties compileProperties(OlapCompilationContext context, String calcMemberId, @Nullable MdxSelectMemberProperties<?> properties) {
        ArrayList<OlapCellPropertyValue> xproperties = new ArrayList<OlapCellPropertyValue>();
        String caption = null;
        String description = null;
        String displayFolder = null;
        String associatedMeasureGroup = null;
        List<OlapEntityIdentifier> nonEmptyBehavior = null;
        int visible = 1;
        int solveOrder = 0;
        Boolean isCached = null;
        OlapScopeIsolation scopeIsolation = null;
        OlapAggregationType aggregation = null;
        Boolean emptyIsZero = null;
        if (properties != null) {
            for (MdxSelectMemberProperty mdxProperty : properties.getProperties()) {
                String resolvedName = mdxProperty.getResolvedName();
                if ("CAPTION".equalsIgnoreCase(resolvedName)) {
                    caption = MdxCreateXyzExpressionPropertiesCompilerHelper.compileCaptionProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("DESCRIPTION".equalsIgnoreCase(resolvedName)) {
                    description = MdxCreateXyzExpressionPropertiesCompilerHelper.compileDescriptionProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("DISPLAY_FOLDER".equalsIgnoreCase(resolvedName)) {
                    displayFolder = MdxCreateXyzExpressionPropertiesCompilerHelper.compileDisplayFolderProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("ASSOCIATED_MEASURE_GROUP".equalsIgnoreCase(resolvedName)) {
                    associatedMeasureGroup = MdxCreateXyzExpressionPropertiesCompilerHelper.compileAssociatedMeasureGroupProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("NON_EMPTY_BEHAVIOR".equalsIgnoreCase(resolvedName)) {
                    nonEmptyBehavior = MdxCreateXyzExpressionPropertiesCompilerHelper.compileNonEmptyBehaviorProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("VISIBLE".equalsIgnoreCase(resolvedName)) {
                    visible = MdxCreateXyzExpressionPropertiesCompilerHelper.compileVisibleProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("SOLVE_ORDER".equalsIgnoreCase(resolvedName)) {
                    solveOrder = MdxCreateXyzExpressionPropertiesCompilerHelper.compileSolveOrderProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("REQUEST_CACHED".equalsIgnoreCase(resolvedName)) {
                    isCached = MdxCreateXyzExpressionPropertiesCompilerHelper.compileCachedProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("SCOPE_ISOLATION".equalsIgnoreCase(resolvedName)) {
                    scopeIsolation = MdxCreateXyzExpressionPropertiesCompilerHelper.compileScopeIsolationProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("AGGREGATION".equalsIgnoreCase(resolvedName)) {
                    aggregation = MdxCreateXyzExpressionPropertiesCompilerHelper.compileAggregationProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                if ("EMPTY_IS_ZERO".equalsIgnoreCase(resolvedName)) {
                    emptyIsZero = MdxCreateXyzExpressionPropertiesCompilerHelper.compileEmptyAsZeroProperty(context, calcMemberId, mdxProperty.getValue());
                    continue;
                }
                OlapCellPropertyValue property = MdxCreateXyzExpressionPropertiesCompilerHelper.compileProperty(context, calcMemberId, mdxProperty);
                xproperties.add(property);
            }
        }
        return new OlapCellProperties(caption, description, displayFolder, associatedMeasureGroup, nonEmptyBehavior, visible, solveOrder, isCached, scopeIsolation, aggregation, emptyIsZero, xproperties);
    }

    private static OlapAggregationType compileAggregationProperty(OlapCompilationContext context, String id, MdxExpression expression) {
        String value = null;
        if (expression instanceof MdxAggrTypeExpression) {
            aggrTypeExpr = (MdxAggrTypeExpression)expression;
            value = ((MdxAggrTypeExpression)aggrTypeExpr).getFirstToken().getLexeme();
        } else if (expression instanceof MdxStringLiteralExpression) {
            aggrTypeExpr = (MdxStringLiteralExpression)expression;
            value = ((MdxStringLiteralExpression)aggrTypeExpr).value();
        } else if (expression instanceof MdxIdentifierExpression) {
            aggrTypeExpr = (MdxIdentifierExpression)expression;
            if (((MdxIdentifierExpression)aggrTypeExpr).getPartCount() == 1) {
                CdMdxIdentifierToken part = ((MdxIdentifierExpression)aggrTypeExpr).getPart(0);
                value = part.getLexeme();
            }
        } else if (expression instanceof MdxFunctionNameExpression) {
            aggrTypeExpr = (MdxFunctionNameExpression)expression;
            value = ((MdxFunctionNameExpression)aggrTypeExpr).getName();
        }
        if (value != null) {
            value = value.toUpperCase();
        }
        if (value != null && value.startsWith("AGGR_")) {
            value = value.substring("AGGR_".length());
        }
        if (value != null) {
            try {
                OlapAggregationType aggrType = OlapAggregationType.valueOf(value);
                return aggrType;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_AGGREGATION_TYPE, new Serializable[]{expression.asMdx(), id});
    }

    private static OlapScopeIsolation compileScopeIsolationProperty(OlapCompilationContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxCubeExpression) {
            return OlapScopeIsolation.CUBE;
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_SCOPE_ISOLATION, new Serializable[]{expression.asMdx(), id});
    }

    private static boolean compileCachedProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxTrueLiteralExpression) {
            return true;
        }
        if (expression instanceof MdxFalseLiteralExpression) {
            return false;
        }
        if (expression instanceof MdxLongLiteralExpression) {
            MdxLongLiteralExpression value = (MdxLongLiteralExpression)expression;
            return value.value() != 0L;
        }
        if (expression instanceof MdxStringLiteralExpression) {
            MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
            String svalue = value.value();
            return "true".equalsIgnoreCase(svalue) || "yes".equalsIgnoreCase(svalue);
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_REQUEST_CACHED, new Serializable[]{expression.asMdx(), id});
    }

    private static String compileCaptionProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxStringLiteralExpression) {
            MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
            String svalue = value.value();
            return svalue;
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_CAPTION, new Serializable[]{expression.asMdx(), id});
    }

    private static String compileDescriptionProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxStringLiteralExpression) {
            MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
            String svalue = value.value();
            return svalue;
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_CAPTION, new Serializable[]{expression.asMdx(), id});
    }

    private static String compileDisplayFolderProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxStringLiteralExpression) {
            MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
            String svalue = value.value();
            return svalue;
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_DISPLAY_FOLDER, new Serializable[]{expression.asMdx(), id});
    }

    private static String compileAssociatedMeasureGroupProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        MdxIdentifierExpression value;
        if (expression instanceof MdxStringLiteralExpression) {
            MdxStringLiteralExpression value2 = (MdxStringLiteralExpression)expression;
            String svalue = value2.value();
            return svalue;
        }
        if (expression instanceof MdxIdentifierExpression && (value = (MdxIdentifierExpression)expression).getPartCount() == 1) {
            String svalue = value.getLastPartAsString();
            return svalue;
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_ASSOCIATED_MEASURE_GROUP, new Serializable[]{expression.asMdx(), id});
    }

    private static List<OlapEntityIdentifier> compileNonEmptyBehaviorProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        OlapEntityIdentifier mg;
        if (expression instanceof MdxIdentifierExpression && (mg = MdxCreateXyzExpressionPropertiesCompilerHelper.getNonEmptyBehaviorMeasure((MdxIdentifierExpression)expression)) != null) {
            return Collections.singletonList(mg);
        }
        if (expression instanceof MdxSetExpression) {
            MdxSetExpression setExpr = (MdxSetExpression)expression;
            List<MdxExpression> exprs = setExpr.getExprs();
            ArrayList<OlapEntityIdentifier> mgs = new ArrayList<OlapEntityIdentifier>();
            for (MdxExpression expr : exprs) {
                OlapEntityIdentifier mg2;
                if (!(expr instanceof MdxIdentifierExpression) || (mg2 = MdxCreateXyzExpressionPropertiesCompilerHelper.getNonEmptyBehaviorMeasure((MdxIdentifierExpression)expr)) == null) continue;
                mgs.add(mg2);
            }
            if (mgs.size() > 0 && mgs.size() == exprs.size()) {
                return mgs;
            }
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_NON_EMPTY_BEHAVIOR, new Serializable[]{expression.asMdx(), id});
    }

    private static OlapEntityIdentifier getNonEmptyBehaviorMeasure(MdxIdentifierExpression idExpr) {
        return MdxEntityCompiler.createOlapIdentifier(idExpr);
    }

    private static int compileVisibleProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxLongLiteralExpression) {
            MdxLongLiteralExpression value = (MdxLongLiteralExpression)expression;
            return (int)value.value();
        }
        if (expression instanceof MdxStringLiteralExpression) {
            try {
                MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
                String svalue = value.value();
                return Integer.parseInt(svalue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_VISIBLE, new Serializable[]{expression.asMdx(), id});
    }

    private static boolean compileEmptyAsZeroProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxTrueLiteralExpression) {
            return true;
        }
        if (expression instanceof MdxFalseLiteralExpression) {
            return false;
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_EMPTY_IS_ZERO, new Serializable[]{expression.asMdx(), id});
    }

    private static int compileSolveOrderProperty(OlapCompilationExceptionContext context, String id, MdxExpression expression) {
        if (expression instanceof MdxLongLiteralExpression) {
            MdxLongLiteralExpression value = (MdxLongLiteralExpression)expression;
            return (int)value.value();
        }
        if (expression instanceof MdxStringLiteralExpression) {
            try {
                MdxStringLiteralExpression value = (MdxStringLiteralExpression)expression;
                String svalue = value.value();
                return Integer.parseInt(svalue);
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        if (expression instanceof MdxUnaryOperatorCallExpression) {
            MdxUnaryOperatorCallExpression expr = (MdxUnaryOperatorCallExpression)expression;
            MdxExpression operand = expr.operand();
            CdMdxTokenKind kind = expr.getFirstToken().getKind();
            if ((kind == CdMdxTokenKind.MINUS || kind == CdMdxTokenKind.PLUS) && operand instanceof MdxLongLiteralExpression) {
                MdxLongLiteralExpression value = (MdxLongLiteralExpression)operand;
                return (kind == CdMdxTokenKind.MINUS ? -1 : 1) * (int)value.value();
            }
        }
        throw new OlapCompilationException(context, OlapErrorCode.INVALID_SOLVE_ORDER, new Serializable[]{expression.asMdx(), id});
    }

    private static OlapCellPropertyValue compileProperty(OlapCompilationContext context, String id, MdxSelectMemberProperty property) {
        OlapCellProperty cellProperty = OlapCellPropertyManager.getProperty(property.getResolvedName());
        if (cellProperty == null) {
            throw new OlapCompilationException(context, OlapErrorCode.CELL_PROPERTY_UNKNOWN_X, new Serializable[]{property.getResolvedName(), id});
        }
        if (cellProperty.isReadOnly()) {
            throw new OlapCompilationException(context, OlapErrorCode.CELL_PROPERTY_READ_ONLY, new Serializable[]{cellProperty.getName()});
        }
        MdxExpression expression = property.getValue();
        if (cellProperty.isFormatString() && expression instanceof MdxIdentifierExpression) {
            MdxIdentifierExpression fsID = (MdxIdentifierExpression)expression;
            expression = MdxCreateXyzExpressionPropertiesCompilerHelper.hackFormatString(fsID);
        }
        Object value = context.compile(expression);
        return cellProperty.createValue(((OlapInstr)value).getLocationRange().mdx(), (OlapInstr)value);
    }

    private static MdxExpression hackFormatString(MdxIdentifierExpression id) {
        String fsID;
        OlapFormatStringName name;
        if (id.getPartCount() == 1 && (name = FORMAT_STRING_NAMES.get(fsID = id.getLastPartAsString())) != null) {
            return new MdxStringLiteralExpression(new CdMdxStringToken(id.getFirstToken().getLocation(), name.name(), name.name()));
        }
        return id;
    }

    static {
        FORMAT_STRING_NAMES.put(OlapFormatStringName.Fixed.name(), OlapFormatStringName.Fixed);
        FORMAT_STRING_NAMES.put(OlapFormatStringName.Percent.name(), OlapFormatStringName.Percent);
        FORMAT_STRING_NAMES.put(OlapFormatStringName.Standard.name(), OlapFormatStringName.Standard);
        FORMAT_STRING_NAMES.put(OlapFormatStringName.Currency.name(), OlapFormatStringName.Currency);
        FORMAT_STRING_NAMES.put(OlapFormatStringName.Scientific.name(), OlapFormatStringName.Scientific);
    }
}

