/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler.ast.function;

import crazydev.common.utils.CdIoUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNativeBodyExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxNativeFunctionModuleInfo;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.compiler.exception.OlapCompilationExceptionContext;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.method.OlapModuleMethodCallInstrFactory;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxNativeFunctionExpressionCompiler
extends MdxEntityCompiler<MdxFunctionNativeBodyExpression> {
    public static NativeInfo extractNativeInfo(OlapCompilationExceptionContext context, MdxFunctionNativeBodyExpression mdx) throws IOException {
        String functionName = mdx.getFunctionName();
        String body = mdx.getBody();
        List bodyLines = CdIoUtils.readAllLines((InputStream)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)));
        if (bodyLines.size() < 2) {
            throw new OlapCompilationException(context, OlapErrorCode.NATIVE_FUNCTION_ERROR, new Serializable[]{functionName, "unexpected number of lines"});
        }
        String header = MdxNativeFunctionExpressionCompiler.extractHeader(context, functionName, bodyLines);
        MdxNativeFunctionModuleInfo moduleInfo = MdxNativeFunctionExpressionCompiler.extractModuleName(context, functionName, header);
        String footer = MdxNativeFunctionExpressionCompiler.extractFooter(context, functionName, bodyLines);
        String source = MdxNativeFunctionExpressionCompiler.extractSource(bodyLines);
        return new NativeInfo(mdx, bodyLines, moduleInfo.module(), moduleInfo.extra(), header, source, footer);
    }

    @Override
    protected OlapInstr doCompile(OlapCompilationContext context, MdxFunctionNativeBodyExpression mdx) {
        String functionName = mdx.getFunctionName();
        try {
            NativeInfo info = MdxNativeFunctionExpressionCompiler.extractNativeInfo(context, mdx);
            OlapModuleMethodCallInstrFactory factory = context.lookupModuleMethods(info.moduleName);
            if (factory == null) {
                throw new OlapCompilationException(context, OlapErrorCode.NATIVE_FUNCTION_ERROR, new Serializable[]{functionName, "the module [" + info.moduleName + "] is not supported"});
            }
            OlapInstr instr = factory.createNativeFunction(context, MdxNativeFunctionExpressionCompiler.createRange(mdx), mdx, info.source);
            return instr;
        }
        catch (IOException ex) {
            OlapLoggers.MDX_PARSER.error((Object)"native function error", (Throwable)ex);
            throw new OlapCompilationException(context, OlapErrorCode.NATIVE_FUNCTION_ERROR, new Serializable[]{functionName, ex.getMessage()});
        }
    }

    private static String trim(String line) {
        line = line.trim();
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < line.length(); ++ii) {
            char cc = line.charAt(ii);
            if (cc == '\u0000') continue;
            sb.append(cc);
        }
        String str = sb.toString();
        return str;
    }

    private static String extractHeader(OlapCompilationExceptionContext context, String functionName, List<String> bodyLines) {
        if (bodyLines.size() < 1) {
            throw new OlapCompilationException(context, OlapErrorCode.NATIVE_FUNCTION_ERROR, new Serializable[]{functionName, "unexpected number of lines"});
        }
        String line = MdxNativeFunctionExpressionCompiler.trim(bodyLines.get(0));
        if (!line.startsWith("/*")) {
            throw new OlapCompilationException(context, OlapErrorCode.NATIVE_FUNCTION_ERROR, new Serializable[]{functionName, "missing opening comment"});
        }
        return line;
    }

    private static MdxNativeFunctionModuleInfo extractModuleName(OlapCompilationExceptionContext context, String functionName, String header) {
        header = header.replace("/*", "");
        if (CdStringUtils.isNullOrBlank((String)(header = MdxNativeFunctionExpressionCompiler.trim(header)))) {
            throw new OlapCompilationException(context, OlapErrorCode.NATIVE_FUNCTION_ERROR, new Serializable[]{functionName, "missing module name (e.g., R)"});
        }
        String[] parts = header.split(":");
        if (parts.length == 2) {
            return new MdxNativeFunctionModuleInfo(parts[0].trim(), parts[1].trim());
        }
        return new MdxNativeFunctionModuleInfo(header, null);
    }

    private static String extractFooter(OlapCompilationExceptionContext context, String functionName, List<String> bodyLines) {
        if (bodyLines.size() < 2) {
            throw new OlapCompilationException(context, OlapErrorCode.NATIVE_FUNCTION_ERROR, new Serializable[]{functionName, "unexpected number of lines"});
        }
        String line = MdxNativeFunctionExpressionCompiler.trim(bodyLines.get(bodyLines.size() - 1));
        if (!line.endsWith("*/")) {
            throw new OlapCompilationException(context, OlapErrorCode.NATIVE_FUNCTION_ERROR, new Serializable[]{functionName, "missing closing comment"});
        }
        return line;
    }

    private static String extractSource(List<String> bodyLines) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 1; ii < bodyLines.size() - 1; ++ii) {
            sb.append(MdxNativeFunctionExpressionCompiler.trim(bodyLines.get(ii)));
            sb.append("\n");
        }
        String str = sb.toString();
        return str;
    }

    public static class NativeInfo {
        public final MdxFunctionNativeBodyExpression mdx;
        public final List<String> bodyLines;
        public final String moduleName;
        @Nullable
        public final String extra;
        public final String header;
        public final String source;
        public final String footer;

        public NativeInfo(MdxFunctionNativeBodyExpression mdx, List<String> bodyLines, String moduleName, @Nullable String extra, String header, String source, String footer) {
            this.mdx = mdx;
            this.bodyLines = bodyLines;
            this.moduleName = moduleName;
            this.extra = extra;
            this.header = header;
            this.source = source;
            this.footer = footer;
        }

        public boolean isSameFunctionName(NativeInfo other) {
            String thisName = this.mdx.getFunctionName();
            String otherName = other.mdx.getFunctionName();
            return thisName.equals(otherName);
        }

        public String getFunctionName() {
            return this.mdx.getFunctionName();
        }
    }
}

