/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler.ast.function;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionCallExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.eval.function.OlapDeclaredFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapIntrinsicMemberPropertyCallInstr;
import crazydev.iccube.olap.eval.function.OlapMultiArgFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapSingleArgFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import java.io.Serializable;

public class MdxFunctionCallExpressionCompiler
extends MdxEntityCompiler<MdxFunctionCallExpression> {
    @Override
    protected OlapInstr doCompile(OlapCompilationContext context, MdxFunctionCallExpression mdx) {
        MdxFunctionCallExpression.Notation notation = mdx.getNotation();
        if (MdxFunctionCallExpression.Notation.PROPERTY == notation) {
            if (mdx.getArgs().size() != 1) {
                throw new CdProgrammingException("Property [" + mdx.getName() + "] call inconsistency.");
            }
            OlapIntrinsicMemberProperty property = context.getIntrinsicProperty(mdx.getName());
            if (property == null) {
                throw new OlapCompilationException(context, OlapErrorCode.MEMBER_PROPERTY_UNKNOWN, new Serializable[]{mdx.getName()});
            }
            OlapInstr arg = MdxFunctionCallExpressionCompiler.compilePropertyCallArg(context, mdx.getArgs().get(0).getArg());
            return new OlapIntrinsicMemberPropertyCallInstr(MdxFunctionCallExpressionCompiler.createRange(mdx), property, arg);
        }
        OlapFunction function = context.lookupRegularFunction(mdx.getName());
        if (function == null) {
            return this.compileDeclaredFunction(context, MdxFunctionCallExpressionCompiler.createRange(mdx), MdxFunctionCallExpressionCompiler.toOlapNotation(notation), mdx);
        }
        OlapInstr[] args = MdxFunctionCallExpressionCompiler.compileArgs(context, function, mdx.getArgs());
        OlapInstr instr = function.asInstr(context, MdxFunctionCallExpressionCompiler.createRange(mdx), MdxFunctionCallExpressionCompiler.toOlapNotation(notation), args);
        if (instr == null) {
            instr = args.length == 1 ? this.compileAsSingleArg(context, mdx, notation, function, args) : this.compileAsMultiArg(context, mdx, notation, function, args);
        }
        return instr;
    }

    private OlapInstr compileAsSingleArg(OlapCompilationContext context, MdxFunctionCallExpression mdx, MdxFunctionCallExpression.Notation mdxNotation, OlapFunction function, OlapInstr[] args) {
        return new OlapSingleArgFunctionCallInstr(MdxFunctionCallExpressionCompiler.createRange(mdx), MdxFunctionCallExpressionCompiler.toOlapNotation(mdxNotation), function, args[0]);
    }

    private OlapInstr compileAsMultiArg(OlapCompilationContext context, MdxFunctionCallExpression mdx, MdxFunctionCallExpression.Notation mdxNotation, OlapFunction function, OlapInstr[] args) {
        return new OlapMultiArgFunctionCallInstr(MdxFunctionCallExpressionCompiler.createRange(mdx), MdxFunctionCallExpressionCompiler.toOlapNotation(mdxNotation), function, args);
    }

    private static OlapInstr compilePropertyCallArg(OlapCompilationContext context, MdxExpression mdx) {
        Object arg = context.compile(mdx);
        return arg;
    }

    private static OlapFunctionCallInstr.Notation toOlapNotation(MdxFunctionCallExpression.Notation mdxNotation) {
        switch (mdxNotation) {
            case FUNCTION_POSTFIXED: {
                return OlapFunctionCallInstr.Notation.FUNCTION_POST_FIXED;
            }
            case FUNCTION_REGULAR: {
                return OlapFunctionCallInstr.Notation.FUNCTION_REGULAR;
            }
        }
        throw new CdProgrammingException("MDX notation [" + String.valueOf((Object)mdxNotation) + "] inconsistency.");
    }

    private OlapInstr compileDeclaredFunction(OlapCompilationContext context, OlapInstrLocationRange location, OlapFunctionCallInstr.Notation mdxNotation, MdxFunctionCallExpression mdx) {
        OlapInstr[] args = MdxFunctionCallExpressionCompiler.compileArgs(context, null, mdx.getArgs());
        return new OlapDeclaredFunctionCallInstr(location, mdxNotation, mdx.getName(), args);
    }
}

